/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.examples.java.graph.util.ConnectedComponentsData;
import org.apache.flink.util.Collector;

public class TransitiveClosureNaive {
    public static void main(String ... args) throws Exception {
        DataSource edges;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        int maxIterations = params.getInt("iterations", 10);
        if (params.has("edges")) {
            edges = env.readCsvFile(params.get("edges")).fieldDelimiter(" ").types(Long.class, Long.class);
        } else {
            System.out.println("Executing TransitiveClosureNaive example with default edges data set.");
            System.out.println("Use --edges to specify file input.");
            edges = ConnectedComponentsData.getDefaultEdgeDataSet(env);
        }
        IterativeDataSet paths = edges.iterate(maxIterations);
        SingleInputUdfOperator nextPaths = ((JoinOperator)((JoinOperator)paths.join((DataSet)edges).where(new int[]{1}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>>(){

            public Tuple2<Long, Long> join(Tuple2<Long, Long> left, Tuple2<Long, Long> right) throws Exception {
                return new Tuple2(left.f0, right.f1);
            }
        }).withForwardedFieldsFirst(new String[]{"0"})).withForwardedFieldsSecond(new String[]{"1"})).union((DataSet)paths).groupBy(new int[]{0, 1}).reduceGroup((GroupReduceFunction)new GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long>>(){

            public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long>> out) throws Exception {
                out.collect(values.iterator().next());
            }
        }).withForwardedFields(new String[]{"0;1"});
        TwoInputUdfOperator newPaths = ((CoGroupOperator)paths.coGroup((DataSet)nextPaths).where(new int[]{0}).equalTo(new int[]{0}).with((CoGroupFunction)new CoGroupFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>>(){
            Set<Tuple2<Long, Long>> prevSet = new HashSet<Tuple2<Long, Long>>();

            public void coGroup(Iterable<Tuple2<Long, Long>> prevPaths, Iterable<Tuple2<Long, Long>> nextPaths, Collector<Tuple2<Long, Long>> out) throws Exception {
                for (Tuple2<Long, Long> prev : prevPaths) {
                    this.prevSet.add(prev);
                }
                for (Tuple2<Long, Long> next : nextPaths) {
                    if (this.prevSet.contains(next)) continue;
                    out.collect(next);
                }
            }
        }).withForwardedFieldsFirst(new String[]{"0"})).withForwardedFieldsSecond(new String[]{"0"});
        DataSet transitiveClosure = paths.closeWith((DataSet)nextPaths, (DataSet)newPaths);
        if (params.has("output")) {
            transitiveClosure.writeAsCsv(params.get("output"), "\n", " ");
            env.execute("Transitive Closure Example");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            transitiveClosure.print();
        }
    }
}

