/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TarArchiveInputStreamTest
extends AbstractTest {
    private void datePriorToEpoch(String archive) throws Exception {
        try (TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(TarArchiveInputStreamTest.getFile(archive).toPath(), new OpenOption[0]));){
            TarArchiveEntry tae = in.getNextTarEntry();
            Assertions.assertEquals((Object)"foo", (Object)tae.getName());
            Assertions.assertEquals((byte)48, (byte)tae.getLinkFlag());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(1969, 11, 31, 23, 59, 59);
            cal.set(14, 0);
            Assertions.assertEquals((Object)cal.getTime(), (Object)tae.getLastModifiedDate());
            Assertions.assertTrue((boolean)tae.isCheckSumOK());
        }
    }

    private void getNextEntryUntilIOException(TarArchiveInputStream archive) {
        Assertions.assertThrows(IOException.class, () -> {
            while (archive.getNextTarEntry() != null) {
            }
        });
    }

    private TarArchiveInputStream getTestStream(String name) {
        return new TarArchiveInputStream(TarArchiveInputStreamTest.class.getResourceAsStream(name));
    }

    @Test
    public void testCompress197() {
        try (TarArchiveInputStream tar = this.getTestStream("/COMPRESS-197.tar");){
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                entry = tar.getNextTarEntry();
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("COMPRESS-197: " + e.getMessage()));
        }
    }

    @Test
    public void testCompress558() throws IOException {
        String folderName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/";
        String consumerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java";
        String producerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry rootfolder = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/");
            tos.putArchiveEntry(rootfolder);
            TarArchiveEntry consumerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java");
            tos.putArchiveEntry(consumerJava);
            TarArchiveEntry producerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java");
            tos.putArchiveEntry(producerJava);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
             TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/", (Object)tis.getNextTarEntry().getName());
            Assertions.assertEquals((byte)53, (byte)tis.getCurrentEntry().getLinkFlag());
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java", (Object)tis.getNextTarEntry().getName());
            Assertions.assertEquals((byte)48, (byte)tis.getCurrentEntry().getLinkFlag());
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java", (Object)tis.getNextTarEntry().getName());
            Assertions.assertEquals((byte)48, (byte)tis.getCurrentEntry().getLinkFlag());
        }
    }

    @Test
    public void testDatePriorToEpochInGNUFormat() throws Exception {
        this.datePriorToEpoch("preepoch-star.tar");
    }

    @Test
    public void testDatePriorToEpochInPAXFormat() throws Exception {
        this.datePriorToEpoch("preepoch-posix.tar");
    }

    @Test
    public void testDirectoryWithLongNameEndsWithSlash() throws IOException, ArchiveException {
        String rootPath = this.getTempDirFile().getAbsolutePath();
        String dirDirectory = "COMPRESS-509";
        int count = 100;
        File root = new File(rootPath + "/" + "COMPRESS-509");
        root.mkdirs();
        for (int i = 1; i < 100; ++i) {
            String subDir = "";
            for (int j = 0; j < i; ++j) {
                subDir = subDir + "a";
            }
            File dir = new File(rootPath + "/" + "COMPRESS-509", "/" + subDir);
            dir.mkdir();
            String fileName = "/COMPRESS-509/" + subDir;
            File tarF = new File(rootPath + "/tar" + i + ".tar");
            try (OutputStream dest = Files.newOutputStream(tarF.toPath(), new OpenOption[0]);){
                TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));
                out.setBigNumberMode(1);
                out.setLongFileMode(2);
                File file = new File(rootPath, fileName);
                TarArchiveEntry entry = new TarArchiveEntry(file);
                entry.setName(fileName);
                out.putArchiveEntry(entry);
                out.closeArchiveEntry();
                out.flush();
            }
            try (InputStream is = Files.newInputStream(tarF.toPath(), new OpenOption[0]);
                 TarArchiveInputStream debInputStream = (TarArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);){
                TarArchiveEntry outEntry;
                while ((outEntry = debInputStream.getNextEntry()) != null) {
                    Assertions.assertTrue((boolean)outEntry.getName().endsWith("/"), (String)outEntry.getName());
                }
                continue;
            }
        }
    }

    @Test
    public void testGetAndSetOfPaxEntry() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-356.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assertions.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            Assertions.assertEquals((Object)is.getCurrentEntry(), (Object)entry);
            TarArchiveEntry weaselEntry = new TarArchiveEntry(entry.getName());
            weaselEntry.setSize(entry.getSize());
            is.setCurrentEntry(weaselEntry);
            Assertions.assertEquals((Object)entry, (Object)is.getCurrentEntry());
            Assertions.assertNotSame((Object)entry, (Object)is.getCurrentEntry());
            Assertions.assertSame((Object)weaselEntry, (Object)is.getCurrentEntry());
            Assertions.assertThrows(IllegalStateException.class, () -> {
                is.setCurrentEntry(null);
                is.read();
            }, (String)"should abort because current entry is nulled");
            is.setCurrentEntry(entry);
            is.read();
        }
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("bla.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void testParseTarTruncatedInContent() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-544_truncated_in_content-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            this.getNextEntryUntilIOException(archive);
        }
    }

    @Test
    public void testParseTarTruncatedInPadding() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-544_truncated_in_padding-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            this.getNextEntryUntilIOException(archive);
        }
    }

    @Test
    public void testParseTarWithNonNumberPaxHeaders() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-529-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> archive.getNextEntry());
        }
    }

    @Test
    public void testParseTarWithSpecialPaxHeaders() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-530-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> archive.getNextEntry());
            Assertions.assertThrows(IOException.class, () -> IOUtils.toByteArray((InputStream)archive));
        }
    }

    @Test
    public void testReadsArchiveCompletely_COMPRESS245() {
        try (InputStream is = TarArchiveInputStreamTest.class.getResourceAsStream("/COMPRESS-245.tar.gz");){
            GZIPInputStream gin = new GZIPInputStream(is);
            try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gin);){
                int count = 0;
                TarArchiveEntry entry = tar.getNextTarEntry();
                while (entry != null) {
                    ++count;
                    entry = tar.getNextTarEntry();
                }
                Assertions.assertEquals((int)31, (int)count);
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("COMPRESS-245: " + e.getMessage()));
        }
    }

    @Test
    public void testRejectsArchivesWithNegativeSizes() throws Exception {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-569-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            this.getNextEntryUntilIOException(archive);
        }
    }

    @Test
    public void testShouldConsumeArchiveCompletely() throws Exception {
        try (InputStream is = TarArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.tar");
             TarArchiveInputStream tar = new TarArchiveInputStream(is);){
            while (tar.getNextTarEntry() != null) {
            }
            byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
            byte[] actual = new byte[expected.length];
            is.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual, () -> Arrays.toString(actual));
        }
    }

    @Test
    public void testShouldReadBigGid() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setBigNumberMode(2);
            TarArchiveEntry t = new TarArchiveEntry("name");
            t.setGroupId(0xFFFFFFFEL);
            t.setSize(1L);
            tos.putArchiveEntry(t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
            TarArchiveEntry t = tis.getNextTarEntry();
            Assertions.assertEquals((long)0xFFFFFFFEL, (long)t.getLongGroupId());
        }
    }

    @Test
    public void testShouldReadGNULongNameEntryWithWrongName() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-324.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assertions.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890.txt", (Object)entry.getName());
        }
    }

    @Test
    public void testShouldThrowAnExceptionOnTruncatedEntries() throws Exception {
        Path dir = this.createTempDirectory("COMPRESS-279");
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-279-fail.tar");){
            Assertions.assertThrows(IOException.class, () -> {
                TarArchiveEntry entry = is.getNextTarEntry();
                int count = 0;
                while (entry != null) {
                    Files.copy((InputStream)is, dir.resolve(String.valueOf(count)), new CopyOption[0]);
                    ++count;
                    entry = is.getNextTarEntry();
                }
            });
        }
    }

    @Test
    public void testShouldUseSpecifiedEncodingWhenReadingGNULongNames() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String encoding = StandardCharsets.UTF_16.name();
        String name = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4";
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, encoding);){
            tos.setLongFileMode(2);
            TarArchiveEntry t = new TarArchiveEntry("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4");
            t.setSize(1L);
            tos.putArchiveEntry(t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis, encoding);){
            TarArchiveEntry t = tis.getNextTarEntry();
            Assertions.assertEquals((Object)"12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4", (Object)t.getName());
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("bla.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }

    @Test
    public void testSkipsDevNumbersWhenEntryIsNoDevice() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-417.tar");){
            Assertions.assertEquals((Object)"test1.xml", (Object)is.getNextTarEntry().getName());
            Assertions.assertEquals((byte)48, (byte)is.getCurrentEntry().getLinkFlag());
            Assertions.assertEquals((Object)"test2.xml", (Object)is.getNextTarEntry().getName());
            Assertions.assertEquals((byte)48, (byte)is.getCurrentEntry().getLinkFlag());
            Assertions.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void testSurvivesBlankLinesInPaxHeader() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-355.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assertions.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            Assertions.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void testSurvivesPaxHeaderWithNameEndingInSlash() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-356.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assertions.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            Assertions.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void testThrowException() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-553-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            this.getNextEntryUntilIOException(archive);
        }
    }

    @Test
    public void testThrowExceptionWithNullEntry() throws IOException {
        try (InputStream in = TarArchiveInputStreamTest.newInputStream("COMPRESS-554-fail.tar");
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            this.getNextEntryUntilIOException(archive);
        }
    }

    @Test
    public void testWorkaroundForBrokenTimeHeader() throws Exception {
        try (TarArchiveInputStream in = new TarArchiveInputStream(TarArchiveInputStreamTest.newInputStream("simple-aix-native-tar.tar"));){
            TarArchiveEntry tae = in.getNextTarEntry();
            tae = in.getNextTarEntry();
            Assertions.assertEquals((Object)"sample/link-to-txt-file.lnk", (Object)tae.getName());
            Assertions.assertEquals((byte)50, (byte)tae.getLinkFlag());
            Assertions.assertEquals((Object)new Date(0L), (Object)tae.getLastModifiedDate());
            Assertions.assertTrue((boolean)tae.isSymbolicLink());
            Assertions.assertTrue((boolean)tae.isCheckSumOK());
        }
    }
}

