/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.unpack200.Pack200UnpackerAdapter;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SegmentTest
extends AbstractTempDirTest {
    @Test
    public void testHelloWorld() throws Exception {
        File file = this.createTempFile("hello", "world.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/HelloWorld.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
        try (JarFile jarFile = new JarFile(file);){
            JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
            Assertions.assertNotNull((Object)entry);
            InputStream ours = jarFile.getInputStream(entry);
            try (JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));){
                JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
                Assertions.assertNotNull((Object)entry2);
                InputStream expected = jarFile2.getInputStream(entry2);
                try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                     BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                    String line1 = reader1.readLine();
                    String line2 = reader2.readLine();
                    int i = 1;
                    while (line1 != null || line2 != null) {
                        Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ ar line " + i));
                        line1 = reader1.readLine();
                        line2 = reader2.readLine();
                        ++i;
                    }
                }
            }
        }
    }

    @Test
    public void testInterfaceOnly() throws Exception {
        File file = this.createTempFile("Interface", "Only.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/InterfaceOnly.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
    }

    @Test
    public void testJustResources() throws Exception {
        File file = this.createTempFile("just", "resources.jar");
        try (InputStream in = Segment.class.getResourceAsStream("/pack200/JustResources.pack");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Segment().unpack(in, out);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bandint_oom.pack", "cpfloat_oom.pack", "cputf8_oom.pack", "favoured_oom.pack", "filebits_oom.pack", "flags_oom.pack", "references_oom.pack", "segment_header_oom.pack", "signatures_oom.pack"})
    public void testParsingOOMBounded(String testFileName) throws Exception {
        URL url = Segment.class.getResource("/org/apache/commons/compress/pack/" + testFileName);
        try (BoundedInputStream in = Pack200UnpackerAdapter.newBoundedInputStream((URL)url);
             JarOutputStream out = new JarOutputStream((OutputStream)NullOutputStream.INSTANCE);){
            Assert.assertThrows(IOException.class, () -> new Segment().unpack((InputStream)in, out));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bandint_oom.pack", "cpfloat_oom.pack", "cputf8_oom.pack", "favoured_oom.pack", "filebits_oom.pack", "flags_oom.pack", "references_oom.pack", "segment_header_oom.pack", "signatures_oom.pack"})
    public void testParsingOOMUnounded(String testFileName) throws Exception {
        try (InputStream in = Segment.class.getResourceAsStream("/org/apache/commons/compress/pack/" + testFileName);
             JarOutputStream out = new JarOutputStream((OutputStream)NullOutputStream.INSTANCE);){
            Assert.assertThrows(IOException.class, () -> new Segment().unpack(in, out));
        }
    }
}

