/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.junit.jupiter.api.Assertions;

public class CompressionDegradationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String compress(String value) throws IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.length());){
            String string;
            try (FramedLZ4CompressorOutputStream compress = new FramedLZ4CompressorOutputStream((OutputStream)byteStream);){
                String compressedValue = null;
                try {
                    compress.write(value.getBytes(StandardCharsets.UTF_8));
                    compress.finish();
                    compressedValue = Base64.getEncoder().encodeToString(byteStream.toByteArray());
                }
                finally {
                    compress.close();
                    byteStream.close();
                }
                string = compressedValue;
            }
            return string;
        }
    }

    public static void main(String[] args) throws Exception {
        try (RandomAccessFile aFile = new RandomAccessFile("src/test/resources/org/apache/commons/compress/COMPRESS-649/some-900kb-text.txt", "r");
             FileChannel inChannel = aFile.getChannel();){
            long fileSize = inChannel.size();
            ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
            inChannel.read(buffer);
            buffer.flip();
            String rawPlan = new String(buffer.array(), StandardCharsets.UTF_8);
            long start = System.currentTimeMillis();
            for (int i = 0; i < 80; ++i) {
                Assertions.assertNotNull((Object)CompressionDegradationTest.compress(rawPlan));
            }
            long end = System.currentTimeMillis();
            float sec = (float)(end - start) / 1000.0f;
            System.out.println(sec + " seconds");
        }
    }
}

