/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class BZip2Test
extends AbstractTest {
    @Test
    public void testBzip2Unarchive() throws Exception {
        File input = BZip2Test.getFile("bla.txt.bz2");
        File output = this.newTempFile("bla.txt");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("bzip2", is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testBzipCreation() throws Exception {
        File input = BZip2Test.getFile("test.txt");
        File output = this.newTempFile("test.txt.bz2");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("bzip2", out);){
            Files.copy(input.toPath(), (OutputStream)cos);
        }
        File decompressed = this.newTempFile("decompressed.txt");
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("bzip2", is);){
            Files.copy((InputStream)in, decompressed.toPath(), new CopyOption[0]);
        }
        Assertions.assertEquals((long)input.length(), (long)decompressed.length());
    }

    @Test
    public void testCOMPRESS131() throws Exception {
        File input = BZip2Test.getFile("COMPRESS-131.bz2");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream(is, true);){
            int l = 0;
            while (in.read() != -1) {
                ++l;
            }
            Assertions.assertEquals((int)539, (int)l);
        }
    }

    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = BZip2Test.getFile("multiple.bz2");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("bzip2", is);){
            Assertions.assertEquals((int)97, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = BZip2Test.getFile("multiple.bz2");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream(is, true);){
            Assertions.assertEquals((int)97, (int)in.read());
            Assertions.assertEquals((int)98, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.available());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

