/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZipUtilTest {
    private Date time;
    private ZipLong zl;

    static void assertDosDate(long value, int year, int month, int day, int hour, int minute, int second) {
        int pos = 0;
        Assertions.assertEquals((int)(year - 1980), (int)((int)(value << pos) >>> 25));
        Assertions.assertEquals((int)month, (int)((int)(value << (pos += 7)) >>> 28));
        Assertions.assertEquals((int)day, (int)((int)(value << (pos += 4)) >>> 27));
        Assertions.assertEquals((int)hour, (int)((int)(value << (pos += 5)) >>> 27));
        Assertions.assertEquals((int)minute, (int)((int)(value << (pos += 5)) >>> 26));
        Assertions.assertEquals((int)second, (int)((int)(value << pos + 6) >>> 27 << 1));
    }

    static Instant toLocalInstant(String date) {
        return LocalDateTime.parse(date).atZone(ZoneId.systemDefault()).toInstant();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.time = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.time);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        long value = year - 1980 << 25 | month << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        this.zl = new ZipLong(result);
    }

    @Test
    public void testAdjustToLong() {
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)ZipUtil.adjustToLong((int)Integer.MAX_VALUE));
        Assertions.assertEquals((long)0x80000000L, (long)ZipUtil.adjustToLong((int)Integer.MIN_VALUE));
        Assertions.assertEquals((long)0xFFFFFFFEL, (long)ZipUtil.adjustToLong((int)-2));
    }

    @Test
    public void testBigToLong() {
        BigInteger big1 = BigInteger.valueOf(1L);
        BigInteger big2 = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger big3 = BigInteger.valueOf(Long.MIN_VALUE);
        Assertions.assertEquals((long)1L, (long)ZipUtil.bigToLong((BigInteger)big1));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)ZipUtil.bigToLong((BigInteger)big2));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)ZipUtil.bigToLong((BigInteger)big3));
        BigInteger big4 = big2.add(big1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipUtil.bigToLong((BigInteger)big4), (String)"Should have thrown IllegalArgumentException");
        BigInteger big5 = big3.subtract(big1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipUtil.bigToLong((BigInteger)big5), (String)"ZipUtil.bigToLong(BigInteger) should have thrown IllegalArgumentException");
    }

    @Test
    public void testFromDosTime() {
        ZipLong testDosTime = new ZipLong(0x200000);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1980);
        cal.set(2, 0);
        cal.set(5, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date testDate = ZipUtil.fromDosTime((ZipLong)testDosTime);
        Assertions.assertEquals((long)testDate.getTime(), (long)cal.getTime().getTime());
        testDosTime = ZipUtil.toDosTime((Date)this.time);
        testDate = ZipUtil.fromDosTime((ZipLong)testDosTime);
        Assertions.assertEquals((long)(testDate.getTime() / 2000L), (long)(this.time.getTime() / 2000L));
    }

    @Test
    public void testInsideCalendar() {
        long date = ZipUtilTest.toLocalInstant("1985-02-01T09:00:00").toEpochMilli();
        byte[] b1 = ZipUtil.toDosTime((long)date);
        Assertions.assertEquals((int)0, (int)b1[0]);
        Assertions.assertEquals((int)72, (int)b1[1]);
        Assertions.assertEquals((int)65, (int)b1[2]);
        Assertions.assertEquals((int)10, (int)b1[3]);
    }

    @Test
    public void testInsideCalendar_bigValue() {
        long date = ZipUtilTest.toLocalInstant("2097-11-27T23:59:59").toEpochMilli();
        long value = ZipLong.getValue((byte[])ZipUtil.toDosTime((long)date));
        ZipUtilTest.assertDosDate(value, 2097, 11, 27, 23, 59, 58);
    }

    @Test
    public void testInsideCalendar_long() {
        long date = ZipUtilTest.toLocalInstant("1985-02-01T09:00:00").toEpochMilli();
        long value = ZipLong.getValue((byte[])ZipUtil.toDosTime((long)date));
        ZipUtilTest.assertDosDate(value, 1985, 2, 1, 9, 0, 0);
    }

    @Test
    public void testInsideCalendar_modernDate() {
        long date = ZipUtilTest.toLocalInstant("2022-12-27T16:18:23").toEpochMilli();
        long value = ZipLong.getValue((byte[])ZipUtil.toDosTime((long)date));
        ZipUtilTest.assertDosDate(value, 2022, 12, 27, 16, 18, 22);
    }

    @Test
    public void testIsDosTime() {
        Assert.assertFalse((boolean)ZipUtil.isDosTime((long)ZipUtilTest.toLocalInstant("1975-01-31T23:00:00").toEpochMilli()));
        Assert.assertTrue((boolean)ZipUtil.isDosTime((long)ZipUtilTest.toLocalInstant("1980-01-03T00:00:00").toEpochMilli()));
        Assert.assertTrue((boolean)ZipUtil.isDosTime((long)ZipUtilTest.toLocalInstant("2097-11-27T00:00:00").toEpochMilli()));
        Assert.assertFalse((boolean)ZipUtil.isDosTime((long)ZipUtilTest.toLocalInstant("2099-01-01T00:00:00").toEpochMilli()));
        long lowestExpressableDosTime = 0x210000L;
        Assert.assertTrue((boolean)ZipUtil.isDosTime((long)ZipUtil.dosToJavaTime((long)0x210000L)));
    }

    @Test
    public void testLongToBig() {
        long l0 = 0L;
        long l1 = 1L;
        long l2 = -1L;
        long l3 = Integer.MIN_VALUE;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MIN_VALUE;
        BigInteger big0 = ZipUtil.longToBig((long)0L);
        BigInteger big1 = ZipUtil.longToBig((long)1L);
        BigInteger big2 = ZipUtil.longToBig((long)-1L);
        BigInteger big3 = ZipUtil.longToBig((long)Integer.MIN_VALUE);
        BigInteger big4 = ZipUtil.longToBig((long)Long.MAX_VALUE);
        Assertions.assertEquals((long)0L, (long)big0.longValue());
        Assertions.assertEquals((long)1L, (long)big1.longValue());
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)big2.longValue());
        Assertions.assertEquals((long)0x80000000L, (long)big3.longValue());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)big4.longValue());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipUtil.longToBig((long)Long.MIN_VALUE), (String)"ZipUtil.longToBig(long) should have thrown IllegalArgumentException");
    }

    @Test
    public void testMinTime() {
        byte[] b1 = ZipUtil.toDosTime((long)0L);
        byte b10 = b1[0];
        b1[0] = (byte)(b1[0] + 1);
        byte[] b2 = ZipUtil.toDosTime((long)0L);
        Assertions.assertEquals((byte)b10, (byte)b2[0]);
    }

    @Test
    public void testOutsideCalendar() {
        long date = ZipUtilTest.toLocalInstant("1975-01-31T23:00:00").toEpochMilli();
        byte[] b1 = ZipUtil.toDosTime((long)date);
        Assertions.assertEquals((int)0, (int)b1[0]);
        Assertions.assertEquals((int)0, (int)b1[1]);
        Assertions.assertEquals((int)33, (int)b1[2]);
        Assertions.assertEquals((int)0, (int)b1[3]);
    }

    @Test
    public void testOutsideCalendar_long() {
        long date = ZipUtilTest.toLocalInstant("1975-01-31T23:00:00").toEpochMilli();
        long value = ZipLong.getValue((byte[])ZipUtil.toDosTime((long)date));
        ZipUtilTest.assertDosDate(value, 1980, 1, 1, 0, 0, 0);
    }

    @Test
    public void testReverse() {
        byte[][] bTest = new byte[][]{new byte[0], {1}, {1, 2}, {1, 2, 3}, {1, 2, 3, 4}, {1, 2, 3, 4, 5}};
        byte[][] rTest = new byte[][]{new byte[0], {1}, {2, 1}, {3, 2, 1}, {4, 3, 2, 1}, {5, 4, 3, 2, 1}};
        Assertions.assertEquals((int)bTest.length, (int)rTest.length, (String)"test and result arrays are same length");
        for (int i = 0; i < bTest.length; ++i) {
            byte[] result = ZipUtil.reverse((byte[])bTest[i]);
            Assertions.assertSame((Object)bTest[i], (Object)result, (String)"reverse mutates in-place");
            Assertions.assertArrayEquals((byte[])rTest[i], (byte[])result, (String)"reverse actually reverses");
        }
    }

    @Test
    public void testSignedByteToUnsignedInt() {
        int expectedVal = 128;
        for (int i = -128; i <= 127; ++i) {
            byte b = (byte)i;
            Assertions.assertEquals((int)expectedVal, (int)ZipUtil.signedByteToUnsignedInt((byte)b));
            if (++expectedVal != 256) continue;
            expectedVal = 0;
        }
    }

    @Test
    public void testUnknownMethod() throws Exception {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        ze.setMethod(100);
        Assertions.assertThrows(UnsupportedZipFeatureException.class, () -> ZipUtil.checkRequestedFeatures((ZipArchiveEntry)ze));
    }

    @Test
    public void testUnsignedIntToSignedByte() {
        int unsignedVal = 128;
        for (int i = -128; i <= 127; ++i) {
            byte expectedVal = (byte)i;
            Assertions.assertEquals((byte)expectedVal, (byte)ZipUtil.unsignedIntToSignedByte((int)unsignedVal));
            if (++unsignedVal != 256) continue;
            unsignedVal = 0;
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipUtil.unsignedIntToSignedByte((int)-1), (String)"ZipUtil.unsignedIntToSignedByte(-1) should have thrown IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipUtil.unsignedIntToSignedByte((int)256), (String)"ZipUtil.unsignedIntToSignedByte(256) should have thrown IllegalArgumentException");
    }

    @Test
    public void testUnsupportedMethod() throws Exception {
        ZipArchiveEntry ze = new ZipArchiveEntry();
        ze.setMethod(ZipMethod.EXPANDING_LEVEL_1.getCode());
        Assertions.assertThrows(UnsupportedZipFeatureException.class, () -> ZipUtil.checkRequestedFeatures((ZipArchiveEntry)ze));
    }

    @Test
    public void testZipLong() {
        ZipLong test = ZipUtil.toDosTime((Date)this.time);
        Assertions.assertEquals((long)test.getValue(), (long)this.zl.getValue());
    }
}

