/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.UnixStat;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExtraFieldUtilsTest
implements UnixStat {
    static final ZipShort UNRECOGNIZED_HEADER = new ZipShort(21845);
    static final ZipShort AIOB_HEADER = new ZipShort(4096);
    private AsiExtraField a;
    private UnrecognizedExtraField dummy;
    private byte[] data;
    private byte[] aLocal;

    @BeforeEach
    public void setUp() {
        this.a = new AsiExtraField();
        this.a.setMode(493);
        this.a.setDirectory(true);
        this.dummy = new UnrecognizedExtraField();
        this.dummy.setHeaderId(UNRECOGNIZED_HEADER);
        this.dummy.setLocalFileDataData(new byte[]{0});
        this.dummy.setCentralDirectoryData(new byte[]{0});
        this.aLocal = this.a.getLocalFileDataData();
        byte[] dummyLocal = this.dummy.getLocalFileDataData();
        this.data = new byte[4 + this.aLocal.length + 4 + dummyLocal.length];
        System.arraycopy(this.a.getHeaderId().getBytes(), 0, this.data, 0, 2);
        System.arraycopy(this.a.getLocalFileDataLength().getBytes(), 0, this.data, 2, 2);
        System.arraycopy(this.aLocal, 0, this.data, 4, this.aLocal.length);
        System.arraycopy(this.dummy.getHeaderId().getBytes(), 0, this.data, 4 + this.aLocal.length, 2);
        System.arraycopy(this.dummy.getLocalFileDataLength().getBytes(), 0, this.data, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyLocal, 0, this.data, 4 + this.aLocal.length + 4, dummyLocal.length);
    }

    @Test
    public void testMerge() {
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        Assertions.assertEquals((int)this.data.length, (int)local.length, (String)"local length");
        for (int i = 0; i < local.length; ++i) {
            Assertions.assertEquals((byte)this.data[i], (byte)local[i], (String)("local byte " + i));
        }
        byte[] dummyCentral = this.dummy.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + 4 + dummyCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(this.dummy.getCentralDirectoryLength().getBytes(), 0, data2, 4 + this.aLocal.length + 2, 2);
        System.arraycopy(dummyCentral, 0, data2, 4 + this.aLocal.length + 4, dummyCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, this.dummy});
        Assertions.assertEquals((int)data2.length, (int)central.length, (String)"central length");
        for (int i = 0; i < central.length; ++i) {
            Assertions.assertEquals((byte)data2[i], (byte)central[i], (String)("central byte " + i));
        }
    }

    @Test
    public void testMergeWithUnparseableData() throws Exception {
        UnparseableExtraFieldData d = new UnparseableExtraFieldData();
        byte[] b = UNRECOGNIZED_HEADER.getBytes();
        d.parseFromLocalFileData(new byte[]{b[0], b[1], 1, 0}, 0, 4);
        byte[] local = ExtraFieldUtils.mergeLocalFileDataData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        Assertions.assertEquals((int)(this.data.length - 1), (int)local.length, (String)"local length");
        for (int i = 0; i < local.length; ++i) {
            Assertions.assertEquals((byte)this.data[i], (byte)local[i], (String)("local byte " + i));
        }
        byte[] dCentral = d.getCentralDirectoryData();
        byte[] data2 = new byte[4 + this.aLocal.length + dCentral.length];
        System.arraycopy(this.data, 0, data2, 0, 4 + this.aLocal.length + 2);
        System.arraycopy(dCentral, 0, data2, 4 + this.aLocal.length, dCentral.length);
        byte[] central = ExtraFieldUtils.mergeCentralDirectoryData((ZipExtraField[])new ZipExtraField[]{this.a, d});
        Assertions.assertEquals((int)data2.length, (int)central.length, (String)"central length");
        for (int i = 0; i < central.length; ++i) {
            Assertions.assertEquals((byte)data2[i], (byte)central[i], (String)("central byte " + i));
        }
    }

    @Test
    public void testParse() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data);
        Assertions.assertEquals((int)2, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
        Assertions.assertTrue((boolean)(ze[1] instanceof UnrecognizedExtraField), (String)"type field 2");
        Assertions.assertEquals((int)1, (int)ze[1].getLocalFileDataLength().getValue(), (String)"data length field 2");
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ExtraFieldUtils.parse((byte[])data2), (String)"data should be invalid");
        Assertions.assertEquals((Object)("Bad extra field starting at " + (4 + this.aLocal.length) + ".  Block length of 1 bytes exceeds remaining data of 0 bytes."), (Object)e.getMessage(), (String)"message");
    }

    @Test
    public void testParseCentral() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)false);
        Assertions.assertEquals((int)2, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
        Assertions.assertTrue((boolean)(ze[1] instanceof UnrecognizedExtraField), (String)"type field 2");
        Assertions.assertEquals((int)1, (int)ze[1].getCentralDirectoryLength().getValue(), (String)"data length field 2");
    }

    @Test
    public void testParseTurnsArrayIndexOutOfBoundsIntoZipException() {
        ExtraFieldUtils.register(AiobThrowingExtraField.class);
        AiobThrowingExtraField f = new AiobThrowingExtraField();
        byte[] d = new byte[8];
        System.arraycopy(f.getHeaderId().getBytes(), 0, d, 0, 2);
        System.arraycopy(f.getLocalFileDataLength().getBytes(), 0, d, 2, 2);
        System.arraycopy(f.getLocalFileDataData(), 0, d, 4, 4);
        ZipException e = (ZipException)Assertions.assertThrows(ZipException.class, () -> ExtraFieldUtils.parse((byte[])d), (String)"data should be invalid");
        Assertions.assertEquals((Object)"Failed to parse corrupt ZIP extra field of type 1000", (Object)e.getMessage(), (String)"message");
    }

    @Test
    public void testParseWithRead() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        Assertions.assertEquals((int)2, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
        Assertions.assertTrue((boolean)(ze[1] instanceof UnrecognizedExtraField), (String)"type field 2");
        Assertions.assertEquals((int)1, (int)ze[1].getLocalFileDataLength().getValue(), (String)"data length field 2");
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.READ);
        Assertions.assertEquals((int)2, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
        Assertions.assertTrue((boolean)(ze[1] instanceof UnparseableExtraFieldData), (String)"type field 2");
        Assertions.assertEquals((int)4, (int)ze[1].getLocalFileDataLength().getValue(), (String)"data length field 2");
        for (int i = 0; i < 4; ++i) {
            Assertions.assertEquals((byte)data2[this.data.length - 5 + i], (byte)ze[1].getLocalFileDataData()[i], (String)("byte number " + i));
        }
    }

    @Test
    public void testParseWithSkip() throws Exception {
        ZipExtraField[] ze = ExtraFieldUtils.parse((byte[])this.data, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        Assertions.assertEquals((int)2, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
        Assertions.assertTrue((boolean)(ze[1] instanceof UnrecognizedExtraField), (String)"type field 2");
        Assertions.assertEquals((int)1, (int)ze[1].getLocalFileDataLength().getValue(), (String)"data length field 2");
        byte[] data2 = new byte[this.data.length - 1];
        System.arraycopy(this.data, 0, data2, 0, data2.length);
        ze = ExtraFieldUtils.parse((byte[])data2, (boolean)true, (ExtraFieldUtils.UnparseableExtraField)ExtraFieldUtils.UnparseableExtraField.SKIP);
        Assertions.assertEquals((int)1, (int)ze.length, (String)"number of fields");
        Assertions.assertTrue((boolean)(ze[0] instanceof AsiExtraField), (String)"type field 1");
        Assertions.assertEquals((int)16877, (int)((AsiExtraField)ze[0]).getMode(), (String)"mode field 1");
    }

    public static class AiobThrowingExtraField
    implements ZipExtraField {
        static final int LENGTH = 4;

        public byte[] getCentralDirectoryData() {
            return this.getLocalFileDataData();
        }

        public ZipShort getCentralDirectoryLength() {
            return this.getLocalFileDataLength();
        }

        public ZipShort getHeaderId() {
            return AIOB_HEADER;
        }

        public byte[] getLocalFileDataData() {
            return new byte[4];
        }

        public ZipShort getLocalFileDataLength() {
            return new ZipShort(4);
        }

        public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) {
            this.parseFromLocalFileData(buffer, offset, length);
        }

        public void parseFromLocalFileData(byte[] buffer, int offset, int length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

