/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SevenZArchiveEntryTest {
    @Test
    public void testMethodConfigurationMattersInEquals() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        SevenZArchiveEntry z3 = new SevenZArchiveEntry();
        z1.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)1)});
        z2.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)2)});
        z3.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)2)});
        Assertions.assertNotEquals((Object)z1, (Object)z2);
        Assertions.assertNotEquals((Object)z2, (Object)z1);
        Assertions.assertEquals((Object)z3, (Object)z2);
        Assertions.assertEquals((Object)z2, (Object)z3);
    }

    @Test
    public void testMethodOrderMattersInEquals() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.LZMA2), new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER)});
        z2.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)});
        Assertions.assertNotEquals((Object)z1, (Object)z2);
        Assertions.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void testNoMethodsIsDifferentFromSomeMethods() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z2.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.COPY)});
        Assertions.assertNotEquals((Object)z1, (Object)z2);
        Assertions.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void testOneMethodsIsDifferentFromTwoMethods() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.COPY)});
        z2.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)});
        Assertions.assertNotEquals((Object)z1, (Object)z2);
        Assertions.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void testSameMethodsYieldEqualEntries() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)});
        z2.setContentMethods(new SevenZMethodConfiguration[]{new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)});
        Assertions.assertEquals((Object)z1, (Object)z2);
        Assertions.assertEquals((Object)z2, (Object)z1);
    }

    @Test
    public void testShouldThrowIfAccessDateIsSetToNull() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setAccessDate(null);
            entry.getAccessDate();
        });
    }

    @Test
    public void testShouldThrowIfCreationDateIsSetToNull() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setCreationDate(null);
            entry.getCreationDate();
        });
    }

    @Test
    public void testShouldThrowIfLastModifiedDateIsSetToNull() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            SevenZArchiveEntry entry = new SevenZArchiveEntry();
            entry.setLastModifiedDate(null);
            entry.getLastModifiedDate();
        });
    }

    @Test
    public void testShouldThrowIfNoAccessDateIsSet() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new SevenZArchiveEntry().getAccessDate());
    }

    @Test
    public void testShouldThrowIfNoCreationDateIsSet() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new SevenZArchiveEntry().getCreationDate());
    }

    @Test
    public void testShouldThrowIfNoLastModifiedDateIsSet() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new SevenZArchiveEntry().getLastModifiedDate());
    }
}

