/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class Compress678Test {
    @ParameterizedTest
    @ValueSource(ints={15, 16, 17, 18, 32, 64, 128})
    public void test_LONGFILE_BSD(int fileNameLen) throws IOException {
        this.test_LONGFILE_BSD(StringUtils.repeat((char)'x', (int)fileNameLen));
    }

    private void test_LONGFILE_BSD(String fileName) throws IOException, FileNotFoundException {
        File file = new File("target/Compress678Test-b.ar");
        Files.deleteIfExists(file.toPath());
        byte[] data = new byte[]{1};
        try (ArArchiveOutputStream arOut = new ArArchiveOutputStream((OutputStream)new FileOutputStream(file));){
            arOut.setLongFileMode(1);
            arOut.putArchiveEntry(new ArArchiveEntry(fileName, (long)data.length));
            arOut.write(data);
            arOut.closeArchiveEntry();
            arOut.putArchiveEntry(new ArArchiveEntry("a", (long)data.length));
            arOut.write(data);
            arOut.closeArchiveEntry();
        }
        try (ArArchiveInputStream arIn = new ArArchiveInputStream((InputStream)new FileInputStream(file));){
            ArArchiveEntry entry = arIn.getNextEntry();
            Assertions.assertEquals((Object)fileName, (Object)entry.getName());
            Assertions.assertNotNull((Object)arIn.getNextEntry());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={15, 16, 17, 18, 32, 64, 128})
    public void test_LONGFILE_BSD_with_spaces(int fileNameLen) throws IOException {
        this.test_LONGFILE_BSD(StringUtils.repeat((String)"x y", (int)(fileNameLen / 3)));
    }

    @Test
    public void test_LONGFILE_ERROR() throws IOException {
        File file = new File("target/Compress678Test-a.ar");
        Files.deleteIfExists(file.toPath());
        String name1 = "01234567891234567";
        byte[] data = new byte[]{1};
        try (ArArchiveOutputStream arOut = new ArArchiveOutputStream((OutputStream)new FileOutputStream(file));){
            arOut.setLongFileMode(0);
            Assertions.assertThrows(IOException.class, () -> arOut.putArchiveEntry(new ArArchiveEntry("01234567891234567", (long)data.length)));
        }
    }

    @Test
    public void testShortName() throws IOException {
        File file = new File("target/Compress678Test-c.ar");
        Files.deleteIfExists(file.toPath());
        String name1 = "0123456789123456";
        byte[] data = new byte[]{1};
        try (ArArchiveOutputStream arOut = new ArArchiveOutputStream((OutputStream)new FileOutputStream(file));){
            arOut.setLongFileMode(1);
            arOut.putArchiveEntry(new ArArchiveEntry("0123456789123456", (long)data.length));
            arOut.write(data);
            arOut.closeArchiveEntry();
            arOut.putArchiveEntry(new ArArchiveEntry("a", (long)data.length));
            arOut.write(data);
            arOut.closeArchiveEntry();
        }
        try (ArArchiveInputStream arIn = new ArArchiveInputStream((InputStream)new FileInputStream(file));){
            ArArchiveEntry entry = arIn.getNextEntry();
            Assertions.assertEquals((Object)"0123456789123456", (Object)entry.getName());
            Assertions.assertNotNull((Object)arIn.getNextEntry());
        }
    }
}

