/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractTest
extends AbstractTempDirTest {
    @TempDir
    protected File tempResultDir;
    protected List<String> archiveList;
    protected final ArchiveStreamFactory factory = ArchiveStreamFactory.DEFAULT;

    public static boolean forceDelete(File file) {
        try {
            if (file != null && file.exists()) {
                FileUtils.forceDelete((File)file);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            file.deleteOnExit();
            return false;
        }
    }

    public static boolean forceDelete(Path path) {
        return AbstractTest.forceDelete(path != null ? path.toFile() : null);
    }

    public static File getFile(String path) throws IOException {
        URL url = AbstractTest.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("couldn't find " + path);
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public static Path getPath(String path) throws IOException {
        return AbstractTest.getFile(path).toPath();
    }

    public static InputStream newInputStream(String path) throws IOException {
        return Files.newInputStream(AbstractTest.getPath(path), new OpenOption[0]);
    }

    public static byte[] readAllBytes(String path) throws IOException {
        return Files.readAllBytes(AbstractTest.getPath(path));
    }

    private <O extends ArchiveOutputStream<E>, E extends ArchiveEntry> void addArchiveEntry(O outputStream, String fileName, File inputFile) throws IOException, FileNotFoundException {
        ArchiveEntry entry = outputStream.createArchiveEntry(inputFile, fileName);
        outputStream.putArchiveEntry(entry);
        Files.copy(inputFile.toPath(), outputStream);
        outputStream.closeArchiveEntry();
        this.archiveList.add(fileName);
    }

    protected void checkArchiveContent(ArchiveInputStream<?> inputStream, List<String> expected) throws Exception {
        this.checkArchiveContent(inputStream, expected, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File checkArchiveContent(ArchiveInputStream<?> inputStream, List<String> expected, boolean cleanUp) throws Exception {
        Path targetDir = this.createTempDirectory("dir-result");
        Path result = targetDir.resolve("result");
        try {
            ArchiveEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                Path outputFile = entry.resolveIn(result);
                long bytesCopied = 0L;
                if (entry.isDirectory()) {
                    Files.createDirectories(outputFile, new FileAttribute[0]);
                } else {
                    Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                    bytesCopied = Files.copy(inputStream, outputFile, new CopyOption[0]);
                }
                long size = entry.getSize();
                if (size != -1L) {
                    Assertions.assertEquals((long)size, (long)bytesCopied, (String)"Entry.size should equal bytes read.");
                }
                if (!Files.exists(outputFile, new LinkOption[0])) {
                    Assertions.fail((String)("Extraction failed: " + entry.getName()));
                }
                if (expected == null || expected.remove(this.getExpectedString(entry))) continue;
                Assertions.fail((String)("Unexpected entry: " + this.getExpectedString(entry)));
            }
            inputStream.close();
            if (expected != null && !expected.isEmpty()) {
                Assertions.fail((String)(expected.size() + " missing entries: " + Arrays.toString(expected.toArray())));
            }
            if (expected != null) {
                Assertions.assertEquals((int)0, (int)expected.size());
            }
        }
        finally {
            if (cleanUp) {
                AbstractTest.forceDelete(targetDir);
            }
        }
        return targetDir.toFile();
    }

    protected void checkArchiveContent(File archive, List<String> expected) throws Exception {
        this.checkArchiveContent(archive.toPath(), expected);
    }

    protected void checkArchiveContent(Path archive, List<String> expected) throws Exception {
        try (InputStream inputStream = Files.newInputStream(archive, new OpenOption[0]);
             ArchiveInputStream archiveInputStream = this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(inputStream));){
            this.checkArchiveContent(archiveInputStream, expected);
        }
    }

    protected void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly((Closeable)closeable);
    }

    protected Path createArchive(String archiveName) throws Exception {
        Path archivePath = this.createTempPath("test", "." + archiveName);
        this.archiveList = new ArrayList<String>();
        try (OutputStream outputStream = Files.newOutputStream(archivePath, new OpenOption[0]);){
            Path path;
            block12: {
                ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiveName, outputStream);
                try {
                    this.setLongFileMode(archiveOutputStream);
                    File file1 = AbstractTest.getFile("test1.xml");
                    File file2 = AbstractTest.getFile("test2.xml");
                    File file3 = AbstractTest.getFile("test3.xml");
                    File file4 = AbstractTest.getFile("test4.xml");
                    File file5 = AbstractTest.getFile("test.txt");
                    File file6 = AbstractTest.getFile("test with spaces.txt");
                    this.addArchiveEntry(archiveOutputStream, "testdata/test1.xml", file1);
                    this.addArchiveEntry(archiveOutputStream, "testdata/test2.xml", file2);
                    this.addArchiveEntry(archiveOutputStream, "test/test3.xml", file3);
                    this.addArchiveEntry(archiveOutputStream, "bla/test4.xml", file4);
                    this.addArchiveEntry(archiveOutputStream, "bla/test5.xml", file4);
                    this.addArchiveEntry(archiveOutputStream, "bla/blubber/test6.xml", file4);
                    this.addArchiveEntry(archiveOutputStream, "test.txt", file5);
                    this.addArchiveEntry(archiveOutputStream, "something/bla", file6);
                    this.addArchiveEntry(archiveOutputStream, "test with spaces.txt", file6);
                    archiveOutputStream.finish();
                    path = archivePath;
                    if (archiveOutputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (archiveOutputStream != null) {
                        try {
                            archiveOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                archiveOutputStream.close();
            }
            return path;
        }
    }

    protected Path createEmptyArchive(String archiveName) throws Exception {
        this.archiveList = new ArrayList<String>();
        Path archivePath = this.createTempPath("empty", "." + archiveName);
        try (OutputStream outputStream = Files.newOutputStream(archivePath, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiveName, outputStream);){
            archiveOutputStream.finish();
        }
        return archivePath;
    }

    protected Path createSingleEntryArchive(String archiveName) throws Exception {
        this.archiveList = new ArrayList<String>();
        Path archivePath = this.createTempPath("empty", "." + archiveName);
        try (OutputStream outputStream = Files.newOutputStream(archivePath, new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = this.factory.createArchiveOutputStream(archiveName, outputStream);){
            this.addArchiveEntry(archiveOutputStream, "test1.xml", AbstractTest.getFile("test1.xml"));
            archiveOutputStream.finish();
        }
        return archivePath;
    }

    public Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(this.getTempDirPath(), prefix, new FileAttribute[0]);
    }

    protected String getExpectedString(ArchiveEntry entry) {
        return entry.getName();
    }

    protected void setLongFileMode(ArchiveOutputStream<?> outputStream) {
        if (outputStream instanceof ArArchiveOutputStream) {
            ((ArArchiveOutputStream)outputStream).setLongFileMode(1);
        }
    }

    protected static interface StreamWrapper<I extends InputStream> {
        public I wrap(InputStream var1) throws Exception;
    }
}

