/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ReverseListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four"};

    @Override
    public ListIterator<E> makeEmptyIterator() {
        return new ReverseListIterator(new ArrayList());
    }

    @Override
    public ReverseListIterator<E> makeObject() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
        return new ReverseListIterator(list);
    }

    @Override
    @Test
    public void testEmptyListIteratorIsIndeedEmpty() {
        Iterator it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)-1, (int)it.nextIndex());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertAll((Executable[])new Executable[]{() -> ReverseListIteratorTest.lambda$testEmptyListIteratorIsIndeedEmpty$1((ListIterator)it), () -> ReverseListIteratorTest.lambda$testEmptyListIteratorIsIndeedEmpty$3((ListIterator)it)});
    }

    @Test
    public void testReset() {
        ReverseListIterator<E> it = this.makeObject();
        Assertions.assertEquals((Object)"Four", (Object)it.next());
        it.reset();
        Assertions.assertEquals((Object)"Four", (Object)it.next());
        it.next();
        it.next();
        it.reset();
        Assertions.assertEquals((Object)"Four", (Object)it.next());
    }

    @Test
    public void testReverse() {
        ReverseListIterator<E> it = this.makeObject();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)3, (int)it.nextIndex());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)4, (int)it.previousIndex());
        Assertions.assertEquals((Object)"Four", it.next());
        Assertions.assertEquals((int)2, (int)it.nextIndex());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)3, (int)it.previousIndex());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)"Three", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)1, (int)it.nextIndex());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)2, (int)it.previousIndex());
        Assertions.assertEquals((Object)"Two", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)0, (int)it.nextIndex());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)1, (int)it.previousIndex());
        Assertions.assertEquals((Object)"One", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)-1, (int)it.nextIndex());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertEquals((int)0, (int)it.previousIndex());
        Assertions.assertEquals((Object)"One", it.previous());
        Assertions.assertEquals((Object)"Two", it.previous());
        Assertions.assertEquals((Object)"Three", it.previous());
        Assertions.assertEquals((Object)"Four", it.previous());
    }

    @Override
    @Test
    public void testWalkForwardAndBack() {
        ArrayList list = new ArrayList();
        ReverseListIterator it = this.makeObject();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        for (int i = list.size() - 1; i >= 0; --i) {
            Assertions.assertEquals((int)(list.size() - i - 2), (int)it.nextIndex(), (String)("" + i));
            Assertions.assertEquals((int)(list.size() - i - 1), (int)it.previousIndex());
            Object obj = list.get(i);
            Assertions.assertEquals(obj, it.previous());
        }
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.previous(), (String)"NoSuchElementException must be thrown from previous at start of ListIterator");
    }

    private static /* synthetic */ void lambda$testEmptyListIteratorIsIndeedEmpty$3(ListIterator it) throws Throwable {
        Assertions.assertThrows(NoSuchElementException.class, () -> it.previous(), (String)"NoSuchElementException must be thrown from empty ListIterator");
    }

    private static /* synthetic */ void lambda$testEmptyListIteratorIsIndeedEmpty$1(ListIterator it) throws Throwable {
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next(), (String)"NoSuchElementException must be thrown from empty ListIterator");
    }
}

