/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ArrayIterator2Test<E>
extends AbstractIteratorTest<E> {
    protected int[] testArray = new int[]{2, 4, 6, 8};

    public ArrayIterator<E> makeArrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public ArrayIterator<E> makeArrayIterator(Object array, int index) {
        return new ArrayIterator(array, index);
    }

    public ArrayIterator<E> makeArrayIterator(Object array, int start, int end) {
        return new ArrayIterator(array, start, end);
    }

    @Override
    public ArrayIterator<E> makeEmptyIterator() {
        return new ArrayIterator((Object)new int[0]);
    }

    @Override
    public ArrayIterator<E> makeObject() {
        return new ArrayIterator((Object)this.testArray);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testIndexedArray() {
        ArrayIterator<E> iter = this.makeArrayIterator(this.testArray, 2);
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assertions.assertEquals((int)count, (int)(this.testArray.length - 2), (String)"the count should be right using ArrayIterator(Object,2) ");
        iter = this.makeArrayIterator(this.testArray, 1, this.testArray.length - 1);
        count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assertions.assertEquals((int)count, (int)(this.testArray.length - 2), (String)("the count should be right using ArrayIterator(Object,1," + (this.testArray.length - 1) + ") "));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.makeArrayIterator(this.testArray, -1), (String)"new ArrayIterator(Object,-1) should throw an ArrayIndexOutOfBoundsException"), () -> Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.makeArrayIterator(this.testArray, this.testArray.length + 1), (String)"new ArrayIterator(Object,length+1) should throw an ArrayIndexOutOfBoundsException"), () -> Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.makeArrayIterator(this.testArray, 0, -1), (String)"new ArrayIterator(Object,0,-1) should throw an ArrayIndexOutOfBoundsException"), () -> Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.makeArrayIterator(this.testArray, 0, this.testArray.length + 1), (String)"new ArrayIterator(Object,0,length+1) should throw an ArrayIndexOutOfBoundsException"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> this.makeArrayIterator(this.testArray, this.testArray.length - 1, this.testArray.length - 2), (String)"new ArrayIterator(Object,length-2,length-1) should throw an IllegalArgumentException")});
        iter = this.makeArrayIterator(this.testArray, 1, 1);
    }

    @Test
    public void testIterator() {
        ArrayIterator<E> iter = this.makeObject();
        for (int element : this.testArray) {
            Integer testValue = element;
            Number iterValue = (Number)iter.next();
            Assertions.assertEquals((Object)testValue, (Object)iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next());
    }
}

