/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.ComparableComparator;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComparatorChainTest
extends AbstractComparatorTest<PseudoRow> {
    @Override
    public List<PseudoRow> getComparableObjectsOrdered() {
        return new LinkedList<PseudoRow>(Arrays.asList(new PseudoRow(1, 2, 3), new PseudoRow(2, 3, 5), new PseudoRow(2, 2, 4), new PseudoRow(2, 2, 8), new PseudoRow(3, 1, 0), new PseudoRow(4, 4, 4), new PseudoRow(4, 4, 7)));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Comparator<PseudoRow> makeObject() {
        ComparatorChain chain = new ComparatorChain((Comparator)new ColumnComparator(0));
        chain.addComparator((Comparator)new ColumnComparator(1), true);
        chain.addComparator((Comparator)new ColumnComparator(2), false);
        return chain;
    }

    @Test
    public void testBadListComparatorChain() {
        LinkedList list = new LinkedList();
        ComparatorChain chain = new ComparatorChain(list);
        Integer i1 = 4;
        Integer i2 = 6;
        Assertions.assertThrows(UnsupportedOperationException.class, () -> chain.compare((Object)i1, (Object)i2));
    }

    @Test
    public void testBadNoopComparatorChain() {
        ComparatorChain chain = new ComparatorChain();
        Integer i1 = 4;
        Integer i2 = 6;
        Assertions.assertThrows(UnsupportedOperationException.class, () -> chain.compare((Object)i1, (Object)i2), (String)"An exception should be thrown when a chain contains zero comparators.");
    }

    @Test
    public void testComparatorChainOnMinValuedComparator() {
        ComparatorChain chain = new ComparatorChain();
        chain.addComparator((a, b) -> {
            int result = a.compareTo((Integer)b);
            if (result < 0) {
                return Integer.MIN_VALUE;
            }
            if (result > 0) {
                return Integer.MAX_VALUE;
            }
            return 0;
        }, true);
        Assertions.assertTrue((chain.compare((Object)4, (Object)5) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((chain.compare((Object)5, (Object)4) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)chain.compare((Object)4, (Object)4));
    }

    @Test
    public void testListComparatorChain() {
        LinkedList<ComparableComparator> list = new LinkedList<ComparableComparator>();
        list.add(new ComparableComparator());
        ComparatorChain chain = new ComparatorChain(list);
        Integer i1 = 4;
        Integer i2 = 6;
        int correctValue = i1.compareTo(i2);
        Assertions.assertEquals((int)chain.compare((Object)i1, (Object)i2), (int)correctValue, (String)"Comparison returns the right order");
    }

    @Test
    public void testNoopComparatorChain() {
        ComparatorChain chain = new ComparatorChain();
        Integer i1 = 4;
        Integer i2 = 6;
        chain.addComparator((Comparator)new ComparableComparator());
        int correctValue = i1.compareTo(i2);
        Assertions.assertEquals((int)chain.compare((Object)i1, (Object)i2), (int)correctValue, (String)"Comparison returns the right order");
    }

    public static class PseudoRow
    implements Serializable {
        private static final long serialVersionUID = 8085570439751032499L;
        public int[] cols = new int[3];

        public PseudoRow(int col1, int col2, int col3) {
            this.cols[0] = col1;
            this.cols[1] = col2;
            this.cols[2] = col3;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PseudoRow)) {
                return false;
            }
            PseudoRow row = (PseudoRow)o;
            return this.getColumn(0) == row.getColumn(0) && this.getColumn(1) == row.getColumn(1) && this.getColumn(2) == row.getColumn(2);
        }

        public int getColumn(int colIndex) {
            return this.cols[colIndex];
        }

        public String toString() {
            return "[" + this.cols[0] + "," + this.cols[1] + "," + this.cols[2] + "]";
        }
    }

    public static class ColumnComparator
    implements Comparator<PseudoRow>,
    Serializable {
        private static final long serialVersionUID = -2284880866328872105L;
        protected int colIndex;

        public ColumnComparator(int colIndex) {
            this.colIndex = colIndex;
        }

        @Override
        public int compare(PseudoRow o1, PseudoRow o2) {
            return Integer.compare(o1.getColumn(this.colIndex), o2.getColumn(this.colIndex));
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof ColumnComparator && this.colIndex == ((ColumnComparator)that).colIndex;
        }

        public int hashCode() {
            return this.colIndex;
        }
    }
}

