/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class WrappedBloomFilterTest
extends AbstractBloomFilterTest<WrappedBloomFilter> {
    @Override
    protected WrappedBloomFilter createEmptyFilter(Shape shape) {
        return new Fixture(new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 34})
    public void testCharacteristics(final int characteristics) {
        Shape shape = this.getTestShape();
        DefaultBloomFilterTest.SparseDefaultBloomFilter inner = new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape){

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
        Fixture underTest = new Fixture(inner);
        Assertions.assertEquals((int)characteristics, (int)underTest.characteristics());
    }

    private static class Fixture
    extends WrappedBloomFilter {
        Fixture(BloomFilter wrapped) {
            super(wrapped);
        }

        public WrappedBloomFilter copy() {
            return new Fixture(this.getWrapped().copy());
        }
    }
}

