/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.splitmap;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.splitmap.TransformedSplitMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedSplitMapTest
extends BulkTest {
    private final Transformer<Integer, String> intToString = String::valueOf;
    private final Transformer<Object, Class<?>> objectToClass = input -> input == null ? null : input.getClass();
    private final Transformer<String, Integer> stringToInt = Integer::valueOf;

    @Test
    public void testEmptyMap() throws IOException, ClassNotFoundException {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), (Transformer)NOPTransformer.nopTransformer());
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("src/test/resources/org/apache/commons/collections4/data/test//TransformedSplitMap.emptyCollection.version4.obj"));
        Object readObject = in.readObject();
        in.close();
        TransformedSplitMap readMap = (TransformedSplitMap)readObject;
        Assertions.assertTrue((boolean)readMap.isEmpty(), (String)"Map should be empty");
        Assertions.assertEquals((Object)map.entrySet(), (Object)readMap.entrySet());
    }

    @Test
    public void testFullMap() throws IOException, ClassNotFoundException {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), (Transformer)NOPTransformer.nopTransformer());
        map.put((Object)"a", (Object)"b");
        map.put((Object)"c", (Object)"d");
        map.put((Object)"e", (Object)"f");
        map.put((Object)"g", (Object)"h");
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("src/test/resources/org/apache/commons/collections4/data/test/TransformedSplitMap.fullCollection.version4.obj"));
        Object readObject = in.readObject();
        in.close();
        TransformedSplitMap readMap = (TransformedSplitMap)readObject;
        Assertions.assertFalse((boolean)readMap.isEmpty(), (String)"Map should not be empty");
        Assertions.assertEquals((Object)map.entrySet(), (Object)readMap.entrySet());
    }

    @Test
    public void testMapIterator() {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < 6; ++i) {
            map.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
        MapIterator it = map.mapIterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            Assertions.assertEquals((Object)k, (Object)it.getKey());
            Assertions.assertEquals((Integer)((Integer)map.get((Object)k)), (Integer)((Integer)it.getValue()));
        }
    }

    @Test
    public void testTransformedMap() {
        TransformedSplitMap map = TransformedSplitMap.transformingMap(new HashMap(), this.intToString, this.objectToClass);
        Integer[] k = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        Object[] v = new Object[]{"", new Object(), new HashMap(), 0, BigInteger.TEN, null, new Object[0]};
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < k.length; ++i) {
            map.put((Object)k[i], v[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsKey(this.intToString.transform((Object)k[i])));
            Assertions.assertFalse((boolean)map.containsKey((Object)k[i]));
            Assertions.assertTrue((boolean)map.containsValue(this.objectToClass.transform(v[i])));
            Assertions.assertTrue((boolean)(this.objectToClass.transform(v[i]) != v[i] ^ map.containsValue(v[i])));
            Assertions.assertEquals((Object)this.objectToClass.transform(v[i]), (Object)map.get(this.intToString.transform((Object)k[i])));
        }
        int sz = map.size();
        Assertions.assertNull((Object)map.remove((Object)k[0]));
        Assertions.assertEquals((int)sz, (int)map.size());
        Assertions.assertEquals((Object)this.objectToClass.transform(v[0]), (Object)map.remove(this.intToString.transform((Object)k[0])));
        Assertions.assertEquals((int)(--sz), (int)map.size());
        TransformedSplitMap map2 = TransformedSplitMap.transformingMap(new HashMap(), (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        Assertions.assertEquals((int)0, (int)map2.size());
        for (int i = 0; i < 6; ++i) {
            map2.put((Object)String.valueOf(i), (Object)String.valueOf(i));
            Assertions.assertEquals((int)(i + 1), (int)map2.size());
            Assertions.assertTrue((boolean)map2.containsValue((Object)i));
            Assertions.assertFalse((boolean)map2.containsValue((Object)String.valueOf(i)));
            Assertions.assertTrue((boolean)map2.containsKey((Object)String.valueOf(i)));
            Assertions.assertEquals((int)i, (int)((Integer)map2.get((Object)String.valueOf(i))));
        }
        int sz2 = map2.size();
        Assertions.assertEquals((Integer)0, (Integer)((Integer)map2.remove((Object)"0")));
        Assertions.assertEquals((int)(--sz2), (int)map2.size());
    }
}

