/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.CompositeCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompositeCollectionTest<E>
extends AbstractCollectionTest<E> {
    protected CompositeCollection<E> c;
    protected Collection<E> one;
    protected Collection<E> two;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "2", "3", "4"};
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new HashSet<E>(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Collection<E> makeFullCollection() {
        E[] elements;
        CompositeCollection compositeCollection = new CompositeCollection();
        for (E element : elements = this.getFullElements()) {
            HashSet<E> summand = new HashSet<E>();
            summand.add(element);
            compositeCollection.addComposited(summand);
        }
        return compositeCollection;
    }

    @Override
    public Collection<E> makeObject() {
        return new CompositeCollection();
    }

    protected void setUpMutatorTest() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){
            private static final long serialVersionUID = 1L;

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection coll : collections) {
                    coll.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                for (Collection collection : collections) {
                    collection.remove(obj);
                }
                return true;
            }
        });
    }

    protected void setUpTest() {
        this.c = new CompositeCollection();
        this.one = new HashSet();
        this.two = new HashSet();
    }

    @Test
    public void testAddAllMutator() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){
            private static final long serialVersionUID = 1L;

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection collection : collections) {
                    collection.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                return false;
            }
        });
        this.c.addComposited(this.one);
        this.two.add("foo");
        this.c.addAll(this.two);
        Assertions.assertTrue((boolean)this.c.contains((Object)"foo"));
        Assertions.assertTrue((boolean)this.one.contains("foo"));
    }

    @Test
    public void testAddAllToCollection() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        HashSet<E> toCollection = new HashSet<E>(this.c);
        Assertions.assertTrue((boolean)toCollection.containsAll((Collection<?>)this.c));
        Assertions.assertEquals((int)this.c.size(), (int)toCollection.size());
    }

    @Test
    public void testAddMutator() {
        this.setUpTest();
        this.c.setMutator(new CompositeCollection.CollectionMutator<E>(){
            private static final long serialVersionUID = 1L;

            public boolean add(CompositeCollection<E> composite, List<Collection<E>> collections, E obj) {
                for (Collection collection : collections) {
                    collection.add(obj);
                }
                return true;
            }

            public boolean addAll(CompositeCollection<E> composite, List<Collection<E>> collections, Collection<? extends E> coll) {
                for (Collection collection : collections) {
                    collection.addAll(coll);
                }
                return true;
            }

            public boolean remove(CompositeCollection<E> composite, List<Collection<E>> collections, Object obj) {
                return false;
            }
        });
        this.c.addComposited(this.one);
        this.c.add((Object)"foo");
        Assertions.assertTrue((boolean)this.c.contains((Object)"foo"));
        Assertions.assertTrue((boolean)this.one.contains("foo"));
    }

    @Test
    public void testAddNullList() {
        Collection nullList = null;
        CompositeCollection cc = new CompositeCollection();
        cc.addComposited(nullList);
        Assertions.assertEquals((int)0, (int)cc.size());
    }

    @Test
    public void testAddNullLists2Args() {
        Collection nullList = null;
        CompositeCollection cc = new CompositeCollection();
        cc.addComposited(nullList, nullList);
        Assertions.assertEquals((int)0, (int)cc.size());
    }

    @Test
    public void testAddNullListsVarArgs() {
        Object nullList = null;
        CompositeCollection cc = new CompositeCollection();
        cc.addComposited(new Collection[]{nullList, nullList, nullList});
        Assertions.assertEquals((int)0, (int)cc.size());
    }

    @Test
    public void testClear() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        this.c.clear();
        Assertions.assertTrue((boolean)this.one.isEmpty());
        Assertions.assertTrue((boolean)this.two.isEmpty());
        Assertions.assertTrue((boolean)this.c.isEmpty());
    }

    @Test
    public void testContainsAll() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("1");
        this.c.addComposited(this.one);
        Assertions.assertTrue((boolean)this.c.containsAll(this.two));
        Assertions.assertFalse((boolean)this.c.containsAll(null));
    }

    @Test
    public void testIsEmpty() {
        this.setUpTest();
        Assertions.assertTrue((boolean)this.c.isEmpty());
        HashSet<String> empty = new HashSet<String>();
        this.c.addComposited(empty);
        Assertions.assertTrue((boolean)this.c.isEmpty());
        empty.add("a");
        Assertions.assertFalse((boolean)this.c.isEmpty());
    }

    @Test
    public void testIterator() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one);
        this.c.addComposited(this.two);
        Iterator i = this.c.iterator();
        Object next = i.next();
        Assertions.assertTrue((boolean)this.c.contains(next));
        Assertions.assertTrue((boolean)this.one.contains(next));
        next = i.next();
        i.remove();
        Assertions.assertFalse((boolean)this.c.contains(next));
        Assertions.assertFalse((boolean)this.two.contains(next));
    }

    @Test
    public void testMultipleCollectionsSize() {
        this.setUpTest();
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("b");
        this.c.addComposited(set);
        HashSet<String> other = new HashSet<String>();
        other.add("c");
        this.c.addComposited(other);
        Assertions.assertEquals((int)(set.size() + other.size()), (int)this.c.size());
    }

    @Test
    public void testRemove() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        this.c.addComposited(this.one, this.two);
        this.c.remove((Object)"1");
        Assertions.assertFalse((boolean)this.c.contains((Object)"1"));
        Assertions.assertFalse((boolean)this.one.contains("1"));
        Assertions.assertFalse((boolean)this.two.contains("1"));
    }

    @Test
    public void testRemoveAll() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        ArrayList<E> removing = new ArrayList<E>(this.one);
        this.c.addComposited(this.one, this.two);
        this.c.removeAll(removing);
        Assertions.assertFalse((boolean)this.c.contains((Object)"1"));
        Assertions.assertFalse((boolean)this.one.contains("1"));
        Assertions.assertFalse((boolean)this.two.contains("1"));
        this.c.removeAll(null);
        Assertions.assertFalse((boolean)this.c.contains((Object)"1"));
        Assertions.assertFalse((boolean)this.one.contains("1"));
        Assertions.assertFalse((boolean)this.two.contains("1"));
    }

    @Test
    public void testRemoveComposited() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        this.c.addComposited(this.one, this.two);
        this.c.removeComposited(this.one);
        Assertions.assertTrue((boolean)this.c.contains((Object)"1"));
        Assertions.assertEquals((int)2, (int)this.c.size());
    }

    @Test
    public void testRemoveIf() {
        this.setUpMutatorTest();
        this.one.add("1");
        this.two.add("2");
        this.two.add("1");
        Predicate<Object> predicate = e -> e == "1";
        this.c.addComposited(this.one, this.two);
        this.c.removeIf(predicate);
        Assertions.assertFalse((boolean)this.c.contains((Object)"1"));
        Assertions.assertFalse((boolean)this.one.contains("1"));
        Assertions.assertFalse((boolean)this.two.contains("1"));
        this.c.removeIf(null);
        Assertions.assertFalse((boolean)this.c.contains((Object)"1"));
        Assertions.assertFalse((boolean)this.one.contains("1"));
        Assertions.assertFalse((boolean)this.two.contains("1"));
    }

    @Test
    public void testRetainAll() {
        this.setUpTest();
        this.one.add("1");
        this.one.add("2");
        this.two.add("1");
        this.c.addComposited(this.one);
        this.c.retainAll(this.two);
        Assertions.assertFalse((boolean)this.c.contains((Object)"2"));
        Assertions.assertFalse((boolean)this.one.contains("2"));
        Assertions.assertTrue((boolean)this.c.contains((Object)"1"));
        Assertions.assertTrue((boolean)this.one.contains("1"));
        this.c.retainAll(null);
        Assertions.assertFalse((boolean)this.c.contains((Object)"2"));
        Assertions.assertFalse((boolean)this.one.contains("2"));
        Assertions.assertTrue((boolean)this.c.contains((Object)"1"));
        Assertions.assertTrue((boolean)this.one.contains("1"));
    }

    @Test
    public void testSize() {
        this.setUpTest();
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("b");
        this.c.addComposited(set);
        Assertions.assertEquals((int)set.size(), (int)this.c.size());
    }

    @Test
    public void testToCollection() {
        this.setUpTest();
        this.one.add("1");
        this.two.add("2");
        this.c.addComposited(this.one, this.two);
        Collection foo = this.c.toCollection();
        Assertions.assertTrue((boolean)foo.containsAll((Collection<?>)this.c));
        Assertions.assertEquals((int)this.c.size(), (int)foo.size());
        this.one.add("3");
        Assertions.assertFalse((boolean)foo.containsAll((Collection<?>)this.c));
    }

    @Override
    @Test
    public void testUnsupportedRemove() {
        this.resetFull();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().remove(null));
        this.verify();
    }
}

