/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.list.PredicatedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ListUtilsTest {
    private static final String a = "a";
    private static final String b = "b";
    private static final String c = "c";
    private static final String d = "d";
    private static final String e = "e";
    private static final String x = "x";
    private static final Predicate<Number> EQUALS_TWO = input -> input.intValue() == 2;
    private String[] fullArray;
    private List<String> fullList;

    @BeforeEach
    public void setUp() {
        this.fullArray = new String[]{a, b, c, d, e};
        this.fullList = new ArrayList<String>(Arrays.asList(this.fullArray));
    }

    @Test
    public void testDefaultIfNull() {
        Assertions.assertTrue((boolean)ListUtils.defaultIfNull(null, Collections.emptyList()).isEmpty());
        ArrayList list = new ArrayList();
        Assertions.assertSame(list, (Object)ListUtils.defaultIfNull(list, Collections.emptyList()));
    }

    @Test
    public void testEmptyIfNull() {
        Assertions.assertTrue((boolean)ListUtils.emptyIfNull(null).isEmpty());
        ArrayList list = new ArrayList();
        Assertions.assertSame(list, (Object)ListUtils.emptyIfNull(list));
    }

    @Test
    public void testEquals() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> list1 = new ArrayList<String>(data);
        ArrayList<String> list2 = new ArrayList<String>(data);
        Assertions.assertEquals(list1, list2);
        Assertions.assertTrue((boolean)ListUtils.isEqualList(list1, list2));
        list1.clear();
        Assertions.assertFalse((boolean)ListUtils.isEqualList(list1, list2));
        Assertions.assertFalse((boolean)ListUtils.isEqualList(list1, null));
        Assertions.assertFalse((boolean)ListUtils.isEqualList(null, list2));
        Assertions.assertTrue((boolean)ListUtils.isEqualList(null, null));
        list2.clear();
        list1.add(a);
        list2.add(b);
        Assertions.assertFalse((boolean)ListUtils.isEqualList(list1, list2));
        list1.add(b);
        list2.add(a);
        Assertions.assertFalse((boolean)ListUtils.isEqualList(list1, list2));
    }

    @Test
    public void testGetFirst() {
        Assertions.assertEquals((Object)a, (Object)ListUtils.getFirst(this.fullList));
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.getFirst(null));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ListUtils.getFirst(new ArrayList()));
    }

    @Test
    public void testGetLast() {
        Assertions.assertEquals((Object)e, (Object)ListUtils.getLast(this.fullList));
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.getFirst(null));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ListUtils.getFirst(new ArrayList()));
    }

    @Test
    public void testHashCode() {
        List<String> data = Arrays.asList(a, b, c);
        ArrayList<String> list1 = new ArrayList<String>(data);
        ArrayList<String> list2 = new ArrayList<String>(data);
        Assertions.assertEquals((int)list1.hashCode(), (int)list2.hashCode());
        Assertions.assertEquals((int)list1.hashCode(), (int)ListUtils.hashCodeForList(list1));
        Assertions.assertEquals((int)list2.hashCode(), (int)ListUtils.hashCodeForList(list2));
        Assertions.assertEquals((int)ListUtils.hashCodeForList(list1), (int)ListUtils.hashCodeForList(list2));
        list1.clear();
        Assertions.assertNotEquals((int)ListUtils.hashCodeForList(list1), (int)ListUtils.hashCodeForList(list2));
        Assertions.assertEquals((int)0, (int)ListUtils.hashCodeForList(null));
        list1.add(null);
        Assertions.assertEquals((int)31, (int)ListUtils.hashCodeForList(list1));
    }

    @Test
    public void testIndexOf() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)d);
        int index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        Assertions.assertEquals((Object)d, (Object)this.fullList.get(index));
        testPredicate = EqualPredicate.equalPredicate((Object)"de");
        index = ListUtils.indexOf(this.fullList, (Predicate)testPredicate);
        Assertions.assertEquals((int)index, (int)-1);
        Assertions.assertEquals((int)ListUtils.indexOf(null, (Predicate)testPredicate), (int)-1);
        Assertions.assertEquals((int)ListUtils.indexOf(this.fullList, null), (int)-1);
    }

    @Test
    public void testIntersectEmptyWithEmptyList() {
        List empty = Collections.EMPTY_LIST;
        Assertions.assertTrue((boolean)ListUtils.intersection((List)empty, (List)empty).isEmpty(), (String)"result not empty");
    }

    @Test
    public void testIntersectionOrderInsensitivity() {
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add(a);
        one.add(b);
        two.add(a);
        two.add(a);
        two.add(b);
        two.add(b);
        Assertions.assertEquals((Object)ListUtils.intersection(one, two), (Object)ListUtils.intersection(two, one));
    }

    @Test
    public void testIntersectListWithNoOverlapAndDifferentTypes() {
        List<Integer> other = Arrays.asList(1, 23);
        Assertions.assertTrue((boolean)ListUtils.intersection(this.fullList, other).isEmpty());
    }

    @Test
    public void testIntersectListWithSelf() {
        Assertions.assertEquals(this.fullList, (Object)ListUtils.intersection(this.fullList, this.fullList));
    }

    @Test
    public void testIntersectNonEmptySubset() {
        ArrayList<String> other = new ArrayList<String>(this.fullList);
        Assertions.assertNotNull(other.remove(0));
        Assertions.assertNotNull(other.remove(1));
        Assertions.assertEquals(other, (Object)ListUtils.intersection(this.fullList, other));
    }

    @Test
    public void testIntersectNonEmptyWithEmptyList() {
        List empty = Collections.emptyList();
        Assertions.assertTrue((boolean)ListUtils.intersection(empty, this.fullList).isEmpty(), (String)"result not empty");
    }

    @Test
    public void testLazyFactoryList() {
        List list = ListUtils.lazyList(new ArrayList(), (Factory)new Factory<Integer>(){
            private int index;

            public Integer create() {
                ++this.index;
                return this.index;
            }
        });
        Assertions.assertNotNull(list.get(5));
        Assertions.assertEquals((int)6, (int)list.size());
        Assertions.assertNotNull(list.get(5));
        Assertions.assertEquals((int)6, (int)list.size());
    }

    @Test
    public void testLazyTransformerList() {
        final List<Integer> offsets = Arrays.asList(3, 5, 1, 5, 3, 6);
        List list = ListUtils.lazyList(new ArrayList(), (Transformer)new Transformer<Integer, Integer>(){
            private int index;

            public Integer transform(Integer input) {
                return (Integer)offsets.get(input) + this.index++;
            }
        });
        Assertions.assertNotNull(list.get(5));
        Assertions.assertEquals((int)6, (int)list.size());
        Assertions.assertNotNull(list.get(5));
        Assertions.assertEquals((int)6, (int)list.size());
    }

    @Test
    public void testLongestCommonSubsequence() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence((List)null, null), (String)"failed to check for null argument"), () -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence(Arrays.asList(Character.valueOf('A')), null), (String)"failed to check for null argument"), () -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence(null, Arrays.asList(Character.valueOf('A'))), (String)"failed to check for null argument")});
        List lcs = ListUtils.longestCommonSubsequence((List)Collections.EMPTY_LIST, (List)Collections.EMPTY_LIST);
        Assertions.assertEquals((int)0, (int)lcs.size());
        List<Character> list1 = Arrays.asList(Character.valueOf('B'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        List<Character> list2 = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('S'));
        lcs = ListUtils.longestCommonSubsequence(list1, list2);
        List<Character> expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        Assertions.assertEquals(expected, (Object)lcs);
        List<Character> list3 = Arrays.asList(Character.valueOf('A'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        lcs = ListUtils.longestCommonSubsequence(list1, list3);
        expected = Arrays.asList(Character.valueOf('A'), Character.valueOf('A'), Character.valueOf('N'), Character.valueOf('A'));
        Assertions.assertEquals(expected, (Object)lcs);
        List<Character> listZorro = Arrays.asList(Character.valueOf('Z'), Character.valueOf('O'), Character.valueOf('R'), Character.valueOf('R'), Character.valueOf('O'));
        lcs = ListUtils.longestCommonSubsequence(list1, listZorro);
        Assertions.assertTrue((boolean)lcs.isEmpty());
    }

    @Test
    public void testLongestCommonSubsequenceWithString() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence((CharSequence)null, null), (String)"failed to check for null argument"), () -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence((CharSequence)"A", null), (String)"failed to check for null argument"), () -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.longestCommonSubsequence(null, (CharSequence)"A"), (String)"failed to check for null argument")});
        String lcs = ListUtils.longestCommonSubsequence((CharSequence)"", (CharSequence)"");
        Assertions.assertEquals((int)0, (int)lcs.length());
        String banana = "BANANA";
        String ananas = "ANANAS";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ANANAS");
        Assertions.assertEquals((Object)"ANANA", (Object)lcs);
        String atana = "ATANA";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ATANA");
        Assertions.assertEquals((Object)"AANA", (Object)lcs);
        String zorro = "ZORRO";
        lcs = ListUtils.longestCommonSubsequence((CharSequence)"BANANA", (CharSequence)"ZORRO");
        Assertions.assertEquals((int)0, (int)lcs.length());
    }

    @Test
    public void testPartition() {
        ArrayList<Integer> strings = new ArrayList<Integer>();
        for (int i = 0; i <= 6; ++i) {
            strings.add(i);
        }
        List partition = ListUtils.partition(strings, (int)3);
        Assertions.assertNotNull((Object)partition);
        Assertions.assertEquals((int)3, (int)partition.size());
        Assertions.assertEquals((int)1, (int)((List)partition.get(2)).size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> partition.get(-1), (String)"Index -1 must not be negative"), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> partition.get(3), (String)("Index 3 must be less than size " + partition.size()))});
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.partition(null, (int)3), (String)"failed to check for null argument"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> ListUtils.partition((List)strings, (int)0), (String)"failed to check for size argument"), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> ListUtils.partition((List)strings, (int)-10), (String)"failed to check for size argument")});
        List partitionMax = ListUtils.partition(strings, (int)Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)partitionMax.size());
        Assertions.assertEquals((int)strings.size(), (int)((List)partitionMax.get(0)).size());
        Assertions.assertEquals(strings, partitionMax.get(0));
    }

    @Test
    public void testPredicatedList() {
        Predicate predicate = String.class::isInstance;
        List list = ListUtils.predicatedList(new ArrayList(), (Predicate)predicate);
        Assertions.assertInstanceOf(PredicatedList.class, (Object)list, (String)"returned object should be a PredicatedList");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.predicatedList(new ArrayList(), null), (String)"Expecting IllegalArgumentException for null predicate."), () -> Assertions.assertThrows(NullPointerException.class, () -> ListUtils.predicatedList(null, (Predicate)predicate), (String)"Expecting IllegalArgumentException for null list.")});
    }

    @Test
    public void testRemoveAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List remainder = ListUtils.removeAll(this.fullList, sub);
        Assertions.assertEquals((int)3, (int)remainder.size());
        this.fullList.removeAll(sub);
        Assertions.assertEquals((Object)remainder, this.fullList);
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.removeAll(null, null), (String)"expecting NullPointerException");
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.removeAll(null, new ArrayList()), (String)"expecting NullPointerException");
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.removeAll(new ArrayList(), null), (String)"expecting NullPointerException");
    }

    @Test
    public void testRetainAll() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        sub.add(b);
        sub.add(x);
        List retained = ListUtils.retainAll(this.fullList, sub);
        Assertions.assertEquals((int)2, (int)retained.size());
        sub.remove(x);
        Assertions.assertEquals((Object)retained, sub);
        this.fullList.retainAll(sub);
        Assertions.assertEquals((Object)retained, this.fullList);
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.retainAll(null, null), (String)"expecting NullPointerException");
    }

    @Test
    public void testSelect() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        List output1 = ListUtils.select(list, EQUALS_TWO);
        List output2 = ListUtils.select(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.select(list, EQUALS_TWO, new HashSet());
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)1, (int)output1.size());
        Assertions.assertEquals((Object)2, output2.iterator().next());
    }

    @Test
    public void testSelectRejected() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        list.add(4L);
        List output1 = ListUtils.selectRejected(list, EQUALS_TWO);
        List output2 = ListUtils.selectRejected(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.selectRejected(list, EQUALS_TWO, new HashSet());
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output2));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)3, (int)output1.size());
        Assertions.assertTrue((boolean)output1.contains(1L));
        Assertions.assertTrue((boolean)output1.contains(3L));
        Assertions.assertTrue((boolean)output1.contains(4L));
    }

    @Test
    public void testSubtract() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(b);
        list.add(a);
        list.add(x);
        ArrayList<String> sub = new ArrayList<String>();
        sub.add(a);
        List result = ListUtils.subtract(list, sub);
        Assertions.assertEquals((int)3, (int)result.size());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(b);
        expected.add(a);
        expected.add(x);
        Assertions.assertEquals(expected, (Object)result);
        Assertions.assertThrows(NullPointerException.class, () -> ListUtils.subtract((List)list, null), (String)"expecting NullPointerException");
    }

    @Test
    public void testSubtractNullElement() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(a);
        list.add(null);
        list.add(null);
        list.add(x);
        ArrayList<Object> sub = new ArrayList<Object>();
        sub.add(null);
        List result = ListUtils.subtract(list, sub);
        Assertions.assertEquals((int)3, (int)result.size());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(a);
        expected.add(null);
        expected.add(x);
        Assertions.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSum() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(a);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(b);
        ArrayList<String> expected1 = new ArrayList<String>();
        expected1.add(a);
        expected1.add(b);
        List result1 = ListUtils.sum(list1, list2);
        Assertions.assertEquals((int)2, (int)result1.size());
        Assertions.assertEquals(expected1, (Object)result1);
    }

    @Test
    public void testUnion() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(a);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(b);
        List result1 = ListUtils.union(list1, list2);
        ArrayList<String> expected1 = new ArrayList<String>();
        expected1.add(a);
        expected1.add(b);
        Assertions.assertEquals((int)2, (int)result1.size());
        Assertions.assertEquals(expected1, (Object)result1);
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add(a);
        List result2 = ListUtils.union(list1, list3);
        ArrayList<String> expected2 = new ArrayList<String>();
        expected2.add(a);
        expected2.add(a);
        Assertions.assertEquals((int)2, (int)result1.size());
        Assertions.assertEquals(expected2, (Object)result2);
        list1.add(null);
        List result3 = ListUtils.union(list1, list2);
        ArrayList<String> expected3 = new ArrayList<String>();
        expected3.add(a);
        expected3.add(null);
        expected3.add(b);
        Assertions.assertEquals((int)3, (int)result3.size());
        Assertions.assertEquals(expected3, (Object)result3);
        list2.add(null);
        List result4 = ListUtils.union(list1, list2);
        ArrayList<String> expected4 = new ArrayList<String>();
        expected4.add(a);
        expected4.add(null);
        expected4.add(b);
        expected4.add(null);
        Assertions.assertEquals((int)4, (int)result4.size());
        Assertions.assertEquals(expected4, (Object)result4);
    }
}

