/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PatriciaTrieTest<V>
extends AbstractSortedMapTest<String, V> {
    public PatriciaTrieTest() {
        super(PatriciaTrieTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public SortedMap<String, V> makeObject() {
        return new PatriciaTrie();
    }

    @Test
    public void testPrefixMap() {
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"", "Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assertions.assertEquals((int)8, (int)map.size());
        Assertions.assertEquals((Object)"Alabama", map.firstKey());
        Assertions.assertEquals((Object)"Alliese", map.lastKey());
        Assertions.assertEquals((Object)"Albertoo", map.get("Albertoo"));
        Assertions.assertNotNull((Object)trie.get((Object)"Xavier"));
        Assertions.assertNull(map.get("Xavier"));
        Assertions.assertNull((Object)trie.get((Object)"Alice"));
        Assertions.assertNull(map.get("Alice"));
        Iterator<Object> iterator = map.values().iterator();
        Assertions.assertEquals((Object)"Alabama", iterator.next());
        Assertions.assertEquals((Object)"Albert", iterator.next());
        Assertions.assertEquals((Object)"Alberto", iterator.next());
        Assertions.assertEquals((Object)"Albertoo", iterator.next());
        Assertions.assertEquals((Object)"Alberts", iterator.next());
        Assertions.assertEquals((Object)"Alien", iterator.next());
        Assertions.assertEquals((Object)"Allie", iterator.next());
        Assertions.assertEquals((Object)"Alliese", iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albert");
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Albert", (Object)iterator.next());
        Assertions.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assertions.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assertions.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertEquals((Object)"Albert", map.firstKey());
        Assertions.assertEquals((Object)"Alberts", map.lastKey());
        Assertions.assertNull((Object)trie.get((Object)"Albertz"));
        map.put("Albertz", "Albertz");
        Assertions.assertEquals((Object)"Albertz", (Object)trie.get((Object)"Albertz"));
        Assertions.assertEquals((int)5, (int)map.size());
        Assertions.assertEquals((Object)"Albertz", map.lastKey());
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Albert", (Object)iterator.next());
        Assertions.assertEquals((Object)"Alberto", (Object)iterator.next());
        Assertions.assertEquals((Object)"Albertoo", (Object)iterator.next());
        Assertions.assertEquals((Object)"Alberts", (Object)iterator.next());
        Assertions.assertEquals((Object)"Albertz", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"Albertz", map.remove("Albertz"));
        map = trie.prefixMap((Object)"Alberto");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"Alberto", map.firstKey());
        Assertions.assertEquals((Object)"Albertoo", map.lastKey());
        Iterator entryIterator = map.entrySet().iterator();
        Map.Entry entry = entryIterator.next();
        Assertions.assertEquals((Object)"Alberto", entry.getKey());
        Assertions.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Albertoo", entry.getKey());
        Assertions.assertEquals((Object)"Albertoo", entry.getValue());
        Assertions.assertFalse((boolean)entryIterator.hasNext());
        trie.put((Object)"Albertoad", (Object)"Albertoad");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Alberto", map.firstKey());
        Assertions.assertEquals((Object)"Albertoo", map.lastKey());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Alberto", entry.getKey());
        Assertions.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Albertoad", entry.getKey());
        Assertions.assertEquals((Object)"Albertoad", entry.getValue());
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Albertoo", entry.getKey());
        Assertions.assertEquals((Object)"Albertoo", entry.getValue());
        Assertions.assertFalse((boolean)entryIterator.hasNext());
        Assertions.assertEquals((Object)"Albertoo", (Object)trie.remove((Object)"Albertoo"));
        Assertions.assertEquals((Object)"Alberto", map.firstKey());
        Assertions.assertEquals((Object)"Albertoad", map.lastKey());
        Assertions.assertEquals((int)2, (int)map.size());
        entryIterator = map.entrySet().iterator();
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Alberto", entry.getKey());
        Assertions.assertEquals((Object)"Alberto", entry.getValue());
        entry = entryIterator.next();
        Assertions.assertEquals((Object)"Albertoad", entry.getKey());
        Assertions.assertEquals((Object)"Albertoad", entry.getValue());
        Assertions.assertFalse((boolean)entryIterator.hasNext());
        Assertions.assertEquals((Object)"Albertoad", (Object)trie.remove((Object)"Albertoad"));
        trie.put((Object)"Albertoo", (Object)"Albertoo");
        map = trie.prefixMap((Object)"X");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertFalse((boolean)map.containsKey("Albert"));
        Assertions.assertTrue((boolean)map.containsKey("Xavier"));
        Assertions.assertFalse((boolean)map.containsKey("Xalan"));
        iterator = map.values().iterator();
        Assertions.assertEquals((Object)"Xavier", (Object)iterator.next());
        Assertions.assertEquals((Object)"XyZ", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"An");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"Anna", map.firstKey());
        Assertions.assertEquals((Object)"Anna", map.lastKey());
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Anna", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ban");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"Banane", map.firstKey());
        Assertions.assertEquals((Object)"Banane", map.lastKey());
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Banane", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Am");
        Assertions.assertFalse((boolean)map.isEmpty());
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Amber", (Object)trie.remove((Object)"Amber"));
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Amma", (Object)iterator.next());
        Assertions.assertEquals((Object)"Ammun", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator = map.keySet().iterator();
        map.put("Amber", "Amber");
        Assertions.assertEquals((int)3, (int)map.size());
        Iterator<Object> iterator1 = iterator;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> iterator1.next());
        Assertions.assertEquals((Object)"Amber", map.firstKey());
        Assertions.assertEquals((Object)"Ammun", map.lastKey());
        map = trie.prefixMap((Object)"Ak\u0000");
        Assertions.assertTrue((boolean)map.isEmpty());
        map = trie.prefixMap((Object)"Ak");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"Akka", map.firstKey());
        Assertions.assertEquals((Object)"Akko", map.lastKey());
        map.put("Ak", "Ak");
        Assertions.assertEquals((Object)"Ak", map.firstKey());
        Assertions.assertEquals((Object)"Akko", map.lastKey());
        Assertions.assertEquals((int)3, (int)map.size());
        trie.put((Object)"Al", (Object)"Al");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Ak", map.remove("Ak"));
        Assertions.assertEquals((Object)"Akka", map.firstKey());
        Assertions.assertEquals((Object)"Akko", map.lastKey());
        Assertions.assertEquals((int)2, (int)map.size());
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Akka", (Object)iterator.next());
        Assertions.assertEquals((Object)"Akko", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)"Al", (Object)trie.remove((Object)"Al"));
        map = trie.prefixMap((Object)"Akka");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"Akka", map.firstKey());
        Assertions.assertEquals((Object)"Akka", map.lastKey());
        iterator = map.keySet().iterator();
        Assertions.assertEquals((Object)"Akka", (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Ab");
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
        SortedMap map1 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map1.firstKey());
        SortedMap map2 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map2.lastKey());
        iterator = map.values().iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"Albertooo");
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
        SortedMap map3 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map3.firstKey(), () -> "got a first key: " + (String)map3.firstKey());
        SortedMap map4 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map4.lastKey(), () -> "got a last key: " + (String)map4.lastKey());
        iterator = map.values().iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
        map = trie.prefixMap((Object)"");
        Assertions.assertSame((Object)trie, (Object)map);
        map = trie.prefixMap((Object)"\u0000");
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
        SortedMap map5 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map5.firstKey(), () -> "got a first key: " + (String)map5.firstKey());
        SortedMap map6 = map;
        Assertions.assertThrows(NoSuchElementException.class, () -> map6.lastKey(), () -> "got a last key: " + (String)map6.lastKey());
        iterator = map.values().iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testPrefixMapClear() {
        PatriciaTrie trie = new PatriciaTrie();
        trie.put((Object)"Anna", (Object)1);
        trie.put((Object)"Anael", (Object)2);
        trie.put((Object)"Analu", (Object)3);
        trie.put((Object)"Andreas", (Object)4);
        trie.put((Object)"Andrea", (Object)5);
        trie.put((Object)"Andres", (Object)6);
        trie.put((Object)"Anatole", (Object)7);
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Andrea", "Andreas", "Andres")), prefixMap.keySet());
        Assertions.assertEquals(Arrays.asList(5, 4, 6), new ArrayList(prefixMap.values()));
        prefixMap.clear();
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Anael", "Analu", "Anatole", "Anna")), (Object)trie.keySet());
        Assertions.assertEquals(Arrays.asList(2, 3, 7, 1), new ArrayList(trie.values()));
    }

    @Test
    public void testPrefixMapClearNothing() {
        PatriciaTrie trie = new PatriciaTrie();
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        Assertions.assertEquals(new HashSet(), prefixMap.keySet());
        Assertions.assertEquals(new ArrayList(0), new ArrayList(prefixMap.values()));
        prefixMap.clear();
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertEquals(new HashSet(), (Object)trie.keySet());
        Assertions.assertEquals(new ArrayList(0), new ArrayList(trie.values()));
    }

    @Test
    public void testPrefixMapClearUsingRemove() {
        PatriciaTrie trie = new PatriciaTrie();
        trie.put((Object)"Anna", (Object)1);
        trie.put((Object)"Anael", (Object)2);
        trie.put((Object)"Analu", (Object)3);
        trie.put((Object)"Andreas", (Object)4);
        trie.put((Object)"Andrea", (Object)5);
        trie.put((Object)"Andres", (Object)6);
        trie.put((Object)"Anatole", (Object)7);
        SortedMap prefixMap = trie.prefixMap((Object)"And");
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Andrea", "Andreas", "Andres")), prefixMap.keySet());
        Assertions.assertEquals(Arrays.asList(5, 4, 6), new ArrayList(prefixMap.values()));
        HashSet keys = new HashSet(prefixMap.keySet());
        for (String key : keys) {
            prefixMap.remove(key);
        }
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertTrue((boolean)prefixMap.isEmpty());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Anael", "Analu", "Anatole", "Anna")), (Object)trie.keySet());
        Assertions.assertEquals(Arrays.asList(2, 3, 7, 1), new ArrayList(trie.values()));
    }

    @Test
    public void testPrefixMapRemoval() {
        String[] keys;
        PatriciaTrie trie = new PatriciaTrie();
        for (String key : keys = new String[]{"Albert", "Xavier", "XyZ", "Anna", "Alien", "Alberto", "Alberts", "Allie", "Alliese", "Alabama", "Banane", "Blabla", "Amber", "Ammun", "Akka", "Akko", "Albertoo", "Amma"}) {
            trie.put((Object)key, (Object)key);
        }
        SortedMap map = trie.prefixMap((Object)"Al");
        Assertions.assertEquals((int)8, (int)map.size());
        Iterator iter = map.keySet().iterator();
        Assertions.assertEquals((Object)"Alabama", iter.next());
        Assertions.assertEquals((Object)"Albert", iter.next());
        Assertions.assertEquals((Object)"Alberto", iter.next());
        Assertions.assertEquals((Object)"Albertoo", iter.next());
        Assertions.assertEquals((Object)"Alberts", iter.next());
        Assertions.assertEquals((Object)"Alien", iter.next());
        iter.remove();
        Assertions.assertEquals((int)7, (int)map.size());
        Assertions.assertEquals((Object)"Allie", iter.next());
        Assertions.assertEquals((Object)"Alliese", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        map = trie.prefixMap((Object)"Ak");
        Assertions.assertEquals((int)2, (int)map.size());
        iter = map.keySet().iterator();
        Assertions.assertEquals((Object)"Akka", iter.next());
        iter.remove();
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"Akko", iter.next());
        Iterator iter1 = iter;
        Assertions.assertFalse((boolean)iter.hasNext(), () -> "shouldn't have next (but was: " + (String)iter1.next() + ")");
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testPrefixMapSizes() {
        PatriciaTrie aTree = new PatriciaTrie();
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084", (Object)"\u00e6\u00b5\u008b\u00e8\u00af\u0095");
        aTree.put((Object)"\u00e4\u00b9\u00a6\u00e8\u00af\u0084", (Object)"\u00e6\u00b5\u008b\u00e8\u00af\u0095");
        Assertions.assertTrue((boolean)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").containsKey("\u00e7\u0082\u00b9\u00e8\u00af\u0084"));
        Assertions.assertEquals((Object)"\u00e6\u00b5\u008b\u00e8\u00af\u0095", aTree.prefixMap((Object)"\u00e7\u0082\u00b9").get("\u00e7\u0082\u00b9\u00e8\u00af\u0084"));
        Assertions.assertFalse((boolean)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").isEmpty());
        Assertions.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").size());
        Assertions.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").size());
        Assertions.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").entrySet().size());
        Assertions.assertEquals((int)1, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084").size());
        aTree.clear();
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e8\u00af\u0084", (Object)"\u00e8\u0081\u0094\u00e7\u009b\u009f");
        aTree.put((Object)"\u00e7\u0082\u00b9\u00e7\u0089\u0088", (Object)"\u00e5\u00ae\u009a\u00e5\u0090\u0091");
        Assertions.assertEquals((int)2, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").size());
        Assertions.assertEquals((int)2, (int)aTree.prefixMap((Object)"\u00e7\u0082\u00b9").size());
    }

    @Test
    public void testPrefixMapSizes2() {
        char u8000 = Character.toChars(32768)[0];
        int char_b = 98;
        PatriciaTrie trie = new PatriciaTrie();
        String prefixString = "b";
        String longerString = "b" + u8000;
        Assertions.assertEquals((int)1, (int)"b".length());
        Assertions.assertEquals((int)2, (int)longerString.length());
        Assertions.assertTrue((boolean)longerString.startsWith("b"));
        trie.put((Object)"b", (Object)"prefixString");
        trie.put((Object)longerString, (Object)"longerString");
        Assertions.assertEquals((int)2, (int)trie.prefixMap((Object)"b").size());
        Assertions.assertTrue((boolean)trie.prefixMap((Object)"b").containsKey(longerString));
    }
}

