/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.MapBackedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapBackedSet2Test<E>
extends AbstractSetTest<E> {
    public MapBackedSet2Test() {
        super(MapBackedSet2Test.class.getSimpleName());
    }

    @Override
    public Set<E> makeObject() {
        return MapBackedSet.mapBackedSet((Map)new LinkedMap());
    }

    protected Set<E> setupSet() {
        Collection set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add(Integer.toString(i));
        }
        return set;
    }

    @Override
    @Test
    public void testCanonicalEmptyCollectionExists() {
    }

    @Override
    @Test
    public void testCanonicalFullCollectionExists() {
    }

    @Test
    public void testOrdering() {
        int i;
        Set<String> set = this.setupSet();
        Iterator<E> it = set.iterator();
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertTrue((boolean)set.remove(Integer.toString(i)), (String)"Must be able to remove int");
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong after remove ");
        }
        for (i = 0; i < 10; ++i) {
            set.add(Integer.toString(i));
        }
        Assertions.assertEquals((int)10, (int)set.size(), (String)"Size of set is wrong!");
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
    }
}

