/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractSortedSetTest<E>
extends AbstractSetTest<E> {
    public AbstractSortedSetTest(String name) {
        super(name);
    }

    public BulkTest bulkTestSortedSetHeadSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        int hiBound = loBound * 2;
        return new TestSortedSetSubSet(hiBound, true);
    }

    public BulkTest bulkTestSortedSetSubSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        int hiBound = loBound * 2;
        return new TestSortedSetSubSet(loBound, hiBound);
    }

    public BulkTest bulkTestSortedSetTailSet() {
        int length = this.getFullElements().length;
        int loBound = length / 3;
        return new TestSortedSetSubSet(loBound, false);
    }

    @Override
    public SortedSet<E> getCollection() {
        return (SortedSet)super.getCollection();
    }

    @Override
    public SortedSet<E> getConfirmed() {
        return (SortedSet)super.getConfirmed();
    }

    @Override
    public E[] getFullNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 1;
        }
        return elements;
    }

    @Override
    public E[] getOtherNonNullElements() {
        Object[] elements = new Object[30];
        for (int i = 0; i < 30; ++i) {
            elements[i] = i + i + 2;
        }
        return elements;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public SortedSet<E> makeConfirmedCollection() {
        return new TreeSet();
    }

    @Override
    public SortedSet<E> makeFullCollection() {
        return (SortedSet)super.makeFullCollection();
    }

    @Override
    public abstract SortedSet<E> makeObject();

    @Override
    public void verify() {
        super.verify();
        Iterator collIter = this.getCollection().iterator();
        Iterator confIter = this.getConfirmed().iterator();
        Object first = null;
        Object last = null;
        while (collIter.hasNext()) {
            last = first == null ? (first = collIter.next()) : collIter.next();
            Assertions.assertEquals(last, confIter.next(), (String)"Element appears to be out of order.");
        }
        if (!this.getCollection().isEmpty()) {
            Assertions.assertEquals(first, this.getCollection().first(), (String)"Incorrect element returned by first().");
            Assertions.assertEquals(last, this.getCollection().last(), (String)"Incorrect element returned by last().");
        }
    }

    public class TestSortedSetSubSet
    extends AbstractSortedSetTest<E> {
        static final int TYPE_SUBSET = 0;
        static final int TYPE_TAILSET = 1;
        static final int TYPE_HEADSET = 2;
        private final int type;
        private int lowBound;
        private int highBound;
        private final E[] fullElements;
        private final E[] otherElements;

        public TestSortedSetSubSet(int bound, boolean head) {
            super("TestSortedSetSubSet");
            if (head) {
                this.type = 2;
                this.highBound = bound;
                this.fullElements = new Object[bound];
                System.arraycopy(AbstractSortedSetTest.this.getFullElements(), 0, this.fullElements, 0, bound);
                this.otherElements = new Object[bound - 1];
                System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), 0, this.otherElements, 0, bound - 1);
            } else {
                this.type = 1;
                this.lowBound = bound;
                E[] allElements = AbstractSortedSetTest.this.getFullElements();
                this.fullElements = new Object[allElements.length - bound];
                System.arraycopy(allElements, bound, this.fullElements, 0, allElements.length - bound);
                this.otherElements = new Object[allElements.length - bound - 1];
                System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), bound, this.otherElements, 0, allElements.length - bound - 1);
            }
        }

        public TestSortedSetSubSet(int loBound, int hiBound) {
            super("TestSortedSetSubSet");
            this.type = 0;
            this.lowBound = loBound;
            this.highBound = hiBound;
            int length = hiBound - loBound;
            this.fullElements = new Object[length];
            System.arraycopy(AbstractSortedSetTest.this.getFullElements(), loBound, this.fullElements, 0, length);
            this.otherElements = new Object[length - 1];
            System.arraycopy(AbstractSortedSetTest.this.getOtherElements(), loBound, this.otherElements, 0, length - 1);
        }

        @Override
        public BulkTest bulkTestSortedSetHeadSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetSubSet() {
            return null;
        }

        @Override
        public BulkTest bulkTestSortedSetTailSet() {
            return null;
        }

        @Override
        public E[] getFullElements() {
            return this.fullElements;
        }

        @Override
        public E[] getOtherElements() {
            return this.otherElements;
        }

        private SortedSet<E> getSubSet(SortedSet<E> set) {
            E[] elements = AbstractSortedSetTest.this.getFullElements();
            switch (this.type) {
                case 0: {
                    return set.subSet(elements[this.lowBound], elements[this.highBound]);
                }
                case 2: {
                    return set.headSet(elements[this.highBound]);
                }
                case 1: {
                    return set.tailSet(elements[this.lowBound]);
                }
            }
            return null;
        }

        @Override
        public boolean isAddSupported() {
            return AbstractSortedSetTest.this.isAddSupported();
        }

        @Override
        public boolean isFailFastSupported() {
            return AbstractSortedSetTest.this.isFailFastSupported();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractSortedSetTest.this.isNullSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractSortedSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public SortedSet<E> makeFullCollection() {
            return this.getSubSet((SortedSet)AbstractSortedSetTest.this.makeFullCollection());
        }

        @Override
        public SortedSet<E> makeObject() {
            return this.getSubSet((SortedSet)AbstractSortedSetTest.this.makeObject());
        }
    }
}

