/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSetTest<E>
extends AbstractCollectionTest<E> {
    public AbstractSetTest(String name) {
        super(name);
    }

    @Override
    public Set<E> getCollection() {
        return (Set)super.getCollection();
    }

    @Override
    public Set<E> getConfirmed() {
        return (Set)super.getConfirmed();
    }

    @Override
    public boolean isEqualsCheckable() {
        return true;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        Collection set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public Set<E> makeFullCollection() {
        Collection set = this.makeObject();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public abstract Set<E> makeObject();

    @Test
    public void testSetEquals() {
        this.resetEmpty();
        Assertions.assertEquals((Object)this.getCollection(), (Object)this.getConfirmed(), (String)"Empty sets should be equal");
        this.verify();
        Collection<String> set2 = this.makeConfirmedCollection();
        set2.add("foo");
        Assertions.assertFalse((boolean)this.getCollection().equals(set2), (String)"Empty set shouldn't equal nonempty set");
        this.resetFull();
        Assertions.assertEquals((Object)this.getCollection(), (Object)this.getConfirmed(), (String)"Full sets should be equal");
        this.verify();
        set2.clear();
        set2.addAll(Arrays.asList(this.getOtherElements()));
        Assertions.assertFalse((boolean)this.getCollection().equals(set2), (String)"Sets with different contents shouldn't be equal");
    }

    @Test
    public void testSetHashCode() {
        this.resetEmpty();
        Assertions.assertEquals((int)this.getCollection().hashCode(), (int)this.getConfirmed().hashCode(), (String)"Empty sets have equal hashCodes");
        this.resetFull();
        Assertions.assertEquals((int)this.getCollection().hashCode(), (int)this.getConfirmed().hashCode(), (String)"Equal sets have equal hashCodes");
    }

    @Override
    public void verify() {
        super.verify();
        Assertions.assertEquals((Object)this.getConfirmed(), (Object)this.getCollection(), (String)"Sets should be equal");
        Assertions.assertEquals((int)this.getConfirmed().hashCode(), (int)this.getCollection().hashCode(), (String)"Sets should have equal hashCodes");
        Collection set = this.makeConfirmedCollection();
        for (Object element : this.getCollection()) {
            Assertions.assertTrue((boolean)set.add(element), (String)"Set.iterator should only return unique elements");
        }
    }
}

