/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractQueueTest<E>
extends AbstractCollectionTest<E> {
    public AbstractQueueTest(String testName) {
        super(testName);
    }

    @Override
    public Queue<E> getCollection() {
        return (Queue)super.getCollection();
    }

    public boolean isSetSupported() {
        return true;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new ArrayList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Queue<E> makeFullCollection() {
        Collection queue = this.makeObject();
        queue.addAll(Arrays.asList(this.getFullElements()));
        return queue;
    }

    @Override
    public abstract Queue<E> makeObject();

    @Test
    public void testEmptyQueueCompatibility() throws IOException, ClassNotFoundException {
        Collection queue = this.makeObject();
        if (queue instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Queue queue2 = (Queue)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(queue));
            Assertions.assertEquals((int)0, (int)queue2.size(), (String)"Queue is empty");
        }
    }

    @Test
    public void testEmptyQueueSerialization() throws IOException, ClassNotFoundException {
        Collection queue = this.makeObject();
        if (!(queue instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] object = this.writeExternalFormToBytes((Serializable)((Object)queue));
        Queue queue2 = (Queue)this.readExternalFormFromBytes(object);
        Assertions.assertEquals((int)0, (int)queue.size(), (String)"Both queues are empty");
        Assertions.assertEquals((int)0, (int)queue2.size(), (String)"Both queues are empty");
    }

    @Test
    public void testFullQueueCompatibility() throws IOException, ClassNotFoundException {
        Collection queue = this.makeFullCollection();
        if (queue instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Queue queue2 = (Queue)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(queue));
            Assertions.assertEquals((int)queue.size(), (int)queue2.size(), (String)"Queues are not the right size");
        }
    }

    @Test
    public void testFullQueueSerialization() throws IOException, ClassNotFoundException {
        Collection queue = this.makeFullCollection();
        int size = this.getFullElements().length;
        if (!(queue instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] object = this.writeExternalFormToBytes((Serializable)((Object)queue));
        Queue queue2 = (Queue)this.readExternalFormFromBytes(object);
        Assertions.assertEquals((int)size, (int)queue.size(), (String)"Both queues are same size");
        Assertions.assertEquals((int)size, (int)queue2.size(), (String)"Both queues are same size");
    }

    @Test
    public void testQueueElement() {
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> this.getCollection().element(), (String)"Queue.element should throw NoSuchElementException");
        this.resetFull();
        Assertions.assertTrue((boolean)this.getConfirmed().contains(this.getCollection().element()));
        if (!this.isRemoveSupported()) {
            return;
        }
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            Object element = this.getCollection().element();
            if (!this.isNullSupported()) {
                Assertions.assertNotNull(element);
            }
            Assertions.assertTrue((boolean)this.getConfirmed().contains(element));
            this.getCollection().remove(element);
            this.getConfirmed().remove(element);
            this.verify();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> this.getCollection().element(), (String)"Queue.element should throw NoSuchElementException");
    }

    @Test
    public void testQueueOffer() {
        E[] elements;
        if (!this.isAddSupported()) {
            return;
        }
        for (Object element : elements = this.getFullElements()) {
            this.resetEmpty();
            boolean r = this.getCollection().offer(element);
            this.getConfirmed().add(element);
            this.verify();
            Assertions.assertTrue((boolean)r, (String)"Empty queue changed after add");
            Assertions.assertEquals((int)1, (int)this.getCollection().size(), (String)"Queue size is 1 after first add");
        }
        this.resetEmpty();
        int size = 0;
        for (Object element : elements) {
            boolean r = this.getCollection().offer(element);
            this.getConfirmed().add(element);
            this.verify();
            if (r) {
                ++size;
            }
            Assertions.assertEquals((int)size, (int)this.getCollection().size(), (String)"Queue size should grow after add");
            Assertions.assertTrue((boolean)this.getCollection().contains(element), (String)"Queue should contain added element");
        }
    }

    @Test
    public void testQueuePeek() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object element = this.getCollection().peek();
        Assertions.assertNull(element);
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            element = this.getCollection().peek();
            if (!this.isNullSupported()) {
                Assertions.assertNotNull(element);
            }
            Assertions.assertTrue((boolean)this.getConfirmed().contains(element));
            this.getCollection().remove(element);
            this.getConfirmed().remove(element);
            this.verify();
        }
        element = this.getCollection().peek();
        Assertions.assertNull(element);
    }

    @Test
    public void testQueuePoll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object element = this.getCollection().poll();
        Assertions.assertNull(element);
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            element = this.getCollection().poll();
            boolean success = this.getConfirmed().remove(element);
            Assertions.assertTrue((boolean)success, (String)"poll should return correct element");
            this.verify();
        }
        element = this.getCollection().poll();
        Assertions.assertNull(element);
    }

    @Test
    public void testQueueRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> this.getCollection().remove(), (String)"Queue.remove should throw NoSuchElementException");
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            Object element = this.getCollection().remove();
            boolean success = this.getConfirmed().remove(element);
            Assertions.assertTrue((boolean)success, (String)"remove should return correct element");
            this.verify();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> this.getCollection().element(), (String)"Queue.remove should throw NoSuchElementException");
    }

    @Override
    public void verify() {
        super.verify();
        Iterator iterator1 = this.getCollection().iterator();
        for (Object e : this.getConfirmed()) {
            Assertions.assertTrue((boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = e;
            Assertions.assertEquals(o1, o2);
        }
    }
}

