/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.util.Arrays;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.multiset.UnmodifiableMultiSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableMultiSetTest<E>
extends AbstractMultiSetTest<E> {
    public UnmodifiableMultiSetTest() {
        super(UnmodifiableMultiSetTest.class.getSimpleName());
    }

    @Override
    public MultiSet<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public MultiSet<E> makeFullCollection() {
        HashMultiSet multiset = new HashMultiSet();
        multiset.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableMultiSet.unmodifiableMultiSet((MultiSet)multiset);
    }

    @Override
    public MultiSet<E> makeObject() {
        return UnmodifiableMultiSet.unmodifiableMultiSet((MultiSet)new HashMultiSet());
    }

    @Test
    public void testAdd() {
        MultiSet<E> multiset = this.makeFullCollection();
        MultiSet unmodifiableMultiSet = UnmodifiableMultiSet.unmodifiableMultiSet(multiset);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> unmodifiableMultiSet.add((Object)"One", 1));
    }

    @Test
    public void testDecorateFactory() {
        MultiSet<E> multiset = this.makeFullCollection();
        Assertions.assertSame(multiset, (Object)UnmodifiableMultiSet.unmodifiableMultiSet(multiset));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableMultiSet.unmodifiableMultiSet(null));
    }

    @Test
    public void testEntrySet() {
        MultiSet<E> multiset = this.makeFullCollection();
        MultiSet unmodifiableMultiSet = UnmodifiableMultiSet.unmodifiableMultiSet(multiset);
        Assertions.assertSame((Object)unmodifiableMultiSet.entrySet().size(), (Object)multiset.entrySet().size());
    }

    @Test
    public void testRemove() {
        MultiSet<E> multiset = this.makeFullCollection();
        MultiSet unmodifiableMultiSet = UnmodifiableMultiSet.unmodifiableMultiSet(multiset);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> unmodifiableMultiSet.remove((Object)"One", 1));
    }

    @Test
    public void testSetCount() {
        MultiSet<E> multiset = this.makeFullCollection();
        MultiSet unmodifiableMultiSet = UnmodifiableMultiSet.unmodifiableMultiSet(multiset);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> unmodifiableMultiSet.setCount((Object)"One", 2));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

