/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.util.Set;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.multiset.PredicatedMultiSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedMultiSetTest<T>
extends AbstractMultiSetTest<T> {
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    public PredicatedMultiSetTest() {
        super(PredicatedMultiSetTest.class.getSimpleName());
    }

    protected MultiSet<T> decorateMultiSet(HashMultiSet<T> multiset, Predicate<T> predicate) {
        return PredicatedMultiSet.predicatedMultiSet(multiset, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public MultiSet<T> makeObject() {
        return this.decorateMultiSet(new HashMultiSet(), this.truePredicate);
    }

    protected MultiSet<T> makeTestMultiSet() {
        return this.decorateMultiSet(new HashMultiSet(), this.stringPredicate());
    }

    protected Predicate<T> stringPredicate() {
        return String.class::isInstance;
    }

    @Test
    public void testIllegalAdd() {
        MultiSet multiset = this.makeTestMultiSet();
        Integer i = 3;
        Assertions.assertThrows(IllegalArgumentException.class, () -> multiset.add((Object)i), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)multiset.contains((Object)i), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalDecorate() {
        HashMultiSet elements = new HashMultiSet();
        elements.add((Object)"one");
        elements.add((Object)"two");
        elements.add((Object)3);
        elements.add((Object)"four");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.decorateMultiSet(elements, this.stringPredicate()), (String)"MultiSet contains an element that should fail the predicate.");
        Assertions.assertThrows(NullPointerException.class, () -> this.decorateMultiSet(new HashMultiSet(), null), (String)"Expecting NullPointerException for null predicate.");
    }

    @Test
    public void testLegalAddRemove() {
        MultiSet<T> multiset = this.makeTestMultiSet();
        Assertions.assertEquals((int)0, (int)multiset.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "1"};
        for (int i = 0; i < els.length; ++i) {
            multiset.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)multiset.size());
            Assertions.assertTrue((boolean)multiset.contains(els[i]));
        }
        Set set = ((PredicatedMultiSet)multiset).uniqueSet();
        Assertions.assertTrue((boolean)set.contains(els[0]), (String)"Unique set contains the first element");
        Assertions.assertTrue((boolean)multiset.remove(els[0]));
        set = ((PredicatedMultiSet)multiset).uniqueSet();
        Assertions.assertTrue((boolean)set.contains(els[0]), (String)"Unique set does not contain anymore the first element");
    }
}

