/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.TransformedSortedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    public TransformedSortedMapTest() {
        super(TransformedSortedMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public String[] ignoredTests() {
        return null;
    }

    @Override
    public boolean isSubMapViewsSerializable() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return TransformedSortedMap.transformingSortedMap(new TreeMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    @Test
    public void testFactory_Decorate() {
        TreeMap<String, String> base = new TreeMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedSortedMap trans = TransformedSortedMap.transformingSortedMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertEquals((Object)"1", trans.get("A"));
        Assertions.assertEquals((Object)"2", trans.get("B"));
        Assertions.assertEquals((Object)"3", trans.get("C"));
        trans.put("D", "4");
        Assertions.assertEquals((Object)4, trans.get("D"));
    }

    @Test
    public void testFactory_decorateTransform() {
        TreeMap<String, String> base = new TreeMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedSortedMap trans = TransformedSortedMap.transformedSortedMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertEquals((Object)1, trans.get("A"));
        Assertions.assertEquals((Object)2, trans.get("B"));
        Assertions.assertEquals((Object)3, trans.get("C"));
        trans.put("D", "4");
        Assertions.assertEquals((Object)4, trans.get("D"));
    }

    @Test
    public void testTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedSortedMap map = TransformedSortedMap.transformingSortedMap(new TreeMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsKey(Integer.valueOf((String)els[i])));
            TransformedSortedMap finalMap1 = map;
            int finalI = i;
            Assertions.assertThrows(ClassCastException.class, () -> TransformedSortedMapTest.lambda$testTransformedMap$0((SortedMap)finalMap1, els, finalI));
            Assertions.assertTrue((boolean)map.containsValue(els[i]));
            Assertions.assertEquals((Object)els[i], map.get(Integer.valueOf((String)els[i])));
        }
        TransformedSortedMap finalMap = map;
        Assertions.assertThrows(ClassCastException.class, () -> TransformedSortedMapTest.lambda$testTransformedMap$1((SortedMap)finalMap, els));
        Assertions.assertEquals((Object)els[0], map.remove(Integer.valueOf((String)els[0])));
        map = TransformedSortedMap.transformingSortedMap(new TreeMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsValue(Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)map.containsValue(els[i]));
            Assertions.assertTrue((boolean)map.containsKey(els[i]));
            Assertions.assertEquals((Object)Integer.valueOf((String)els[i]), map.get(els[i]));
        }
        Assertions.assertEquals((Object)Integer.valueOf((String)els[0]), map.remove(els[0]));
        Set entrySet = map.entrySet();
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        array[0].setValue("66");
        Assertions.assertEquals((Object)66, array[0].getValue());
        Assertions.assertEquals((Object)66, map.get(array[0].getKey()));
        Map.Entry entry = entrySet.iterator().next();
        entry.setValue("88");
        Assertions.assertEquals((Object)88, entry.getValue());
        Assertions.assertEquals((Object)88, map.get(entry.getKey()));
    }

    private static /* synthetic */ void lambda$testTransformedMap$1(SortedMap finalMap, Object[] els) throws Throwable {
        finalMap.remove(els[0]);
    }

    private static /* synthetic */ void lambda$testTransformedMap$0(SortedMap finalMap1, Object[] els, int finalI) throws Throwable {
        finalMap1.containsKey(els[finalI]);
    }
}

