/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.TransformedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public TransformedMapTest() {
        super(TransformedMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return TransformedMap.transformingMap(new HashMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    @Test
    public void testFactory_Decorate() {
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedMap trans = TransformedMap.transformingMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertEquals((Object)"1", trans.get("A"));
        Assertions.assertEquals((Object)"2", trans.get("B"));
        Assertions.assertEquals((Object)"3", trans.get("C"));
        trans.put("D", "4");
        Assertions.assertEquals((Object)4, trans.get("D"));
    }

    @Test
    public void testFactory_decorateTransform() {
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedMap trans = TransformedMap.transformedMap(base, TransformedCollectionTest.TO_LOWER_CASE_TRANSFORMER, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)3, (int)trans.size());
        Assertions.assertEquals((Object)1, trans.get("a"));
        Assertions.assertEquals((Object)2, trans.get("b"));
        Assertions.assertEquals((Object)3, trans.get("c"));
        trans.put("D", "4");
        Assertions.assertEquals((Object)4, trans.get("d"));
    }

    @Test
    public void testTransformedMap() {
        int i;
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedMap map = TransformedMap.transformingMap(new HashMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        Assertions.assertEquals((int)0, (int)map.size());
        for (i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsKey(Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)map.containsKey(els[i]));
            Assertions.assertTrue((boolean)map.containsValue(els[i]));
            Assertions.assertEquals((Object)els[i], map.get(Integer.valueOf((String)els[i])));
        }
        Assertions.assertNull(map.remove(els[0]));
        Assertions.assertEquals((Object)els[0], map.remove(Integer.valueOf((String)els[0])));
        map = TransformedMap.transformingMap(new HashMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)map.size());
        for (i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            Assertions.assertEquals((int)(i + 1), (int)map.size());
            Assertions.assertTrue((boolean)map.containsValue(Integer.valueOf((String)els[i])));
            Assertions.assertFalse((boolean)map.containsValue(els[i]));
            Assertions.assertTrue((boolean)map.containsKey(els[i]));
            Assertions.assertEquals((Object)Integer.valueOf((String)els[i]), map.get(els[i]));
        }
        Assertions.assertEquals((Object)Integer.valueOf((String)els[0]), map.remove(els[0]));
        Set entrySet = map.entrySet();
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        array[0].setValue("66");
        Assertions.assertEquals((Object)66, array[0].getValue());
        Assertions.assertEquals((Object)66, map.get(array[0].getKey()));
        Map.Entry entry = entrySet.iterator().next();
        entry.setValue("88");
        Assertions.assertEquals((Object)88, entry.getValue());
        Assertions.assertEquals((Object)88, map.get(entry.getKey()));
    }
}

