/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.LinkedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LinkedMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    public LinkedMapTest() {
        super(LinkedMapTest.class.getSimpleName());
    }

    public BulkTest bulkTestListView() {
        return new TestListView();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public LinkedMap<K, V> getMap() {
        return (LinkedMap)super.getMap();
    }

    @Override
    public LinkedMap<K, V> makeFullMap() {
        return (LinkedMap)super.makeFullMap();
    }

    @Override
    public LinkedMap<K, V> makeObject() {
        return new LinkedMap();
    }

    @Test
    public void testClone() {
        LinkedMap map = new LinkedMap(10);
        map.put((Object)"1", (Object)"1");
        LinkedMap cloned = map.clone();
        Assertions.assertEquals((int)map.size(), (int)cloned.size());
        Assertions.assertSame((Object)map.get((Object)"1"), cloned.get("1"));
    }

    @Test
    public void testGetByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.get(lm.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            Assertions.assertSame((Object)it.next(), (Object)lm.get(i));
            ++i;
        }
    }

    @Test
    public void testGetValueByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.getValue(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.getValue(lm.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            it.next();
            Assertions.assertSame((Object)it.getValue(), (Object)lm.getValue(i));
            ++i;
        }
    }

    @Test
    public void testIndexOf() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        Assertions.assertEquals((int)-1, (int)lm.indexOf(this.getOtherKeys()));
        this.resetFull();
        lm = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((int)i, (int)lm.indexOf(list.get(i)));
        }
    }

    @Test
    public void testInitialCapacityZero() {
        LinkedMap map = new LinkedMap(0);
        Assertions.assertEquals((int)1, (int)map.data.length);
    }

    @Test
    public void testInsertionOrder() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        K[] keys = this.getSampleKeys();
        V[] values = this.getSampleValues();
        this.resetEmpty();
        this.map.put(keys[0], values[0]);
        this.map.put(keys[1], values[1]);
        Iterator keyIter = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], keyIter.next());
        Assertions.assertSame(keys[1], keyIter.next());
        Iterator valueIter = this.map.values().iterator();
        Assertions.assertSame(values[0], valueIter.next());
        Assertions.assertSame(values[1], valueIter.next());
        this.map.put(keys[1], values[1]);
        keyIter = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], keyIter.next());
        Assertions.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        Assertions.assertSame(values[0], valueIter.next());
        Assertions.assertSame(values[1], valueIter.next());
        this.map.put(keys[1], values[2]);
        keyIter = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], keyIter.next());
        Assertions.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        Assertions.assertSame(values[0], valueIter.next());
        Assertions.assertSame(values[2], valueIter.next());
        this.map.put(keys[0], values[3]);
        keyIter = this.map.keySet().iterator();
        Assertions.assertSame(keys[0], keyIter.next());
        Assertions.assertSame(keys[1], keyIter.next());
        valueIter = this.map.values().iterator();
        Assertions.assertSame(values[3], valueIter.next());
        Assertions.assertSame(values[2], valueIter.next());
    }

    @Test
    public void testRemoveByIndex() {
        this.resetEmpty();
        LinkedMap<K, V> lm = this.getMap();
        try {
            lm.remove(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lm = this.getMap();
        try {
            lm.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lm.remove(lm.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lm.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lm.get(key);
            Assertions.assertEquals((Object)value, (Object)lm.remove(i));
            list.remove(i);
            Assertions.assertFalse((boolean)lm.containsKey(key));
        }
    }

    @Test
    public void testReset() {
        this.resetEmpty();
        LinkedMap<K, V> ordered = this.getMap();
        ((ResettableIterator)ordered.mapIterator()).reset();
        this.resetFull();
        ordered = this.getMap();
        ArrayList list = new ArrayList(ordered.keySet());
        ResettableIterator it = (ResettableIterator)ordered.mapIterator();
        Assertions.assertSame(list.get(0), (Object)it.next());
        Assertions.assertSame(list.get(1), (Object)it.next());
        it.reset();
        Assertions.assertSame(list.get(0), (Object)it.next());
    }

    public class TestListView
    extends AbstractListTest<K> {
        TestListView() {
            super("TestListView");
        }

        @Override
        public K[] getFullElements() {
            return LinkedMapTest.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return LinkedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public List<K> makeFullCollection() {
            return LinkedMapTest.this.makeFullMap().asList();
        }

        @Override
        public List<K> makeObject() {
            return LinkedMapTest.this.makeObject().asList();
        }
    }
}

