/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Map;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.HashedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HashedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public HashedMapTest() {
        super(HashedMapTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public HashedMap<K, V> makeObject() {
        return new HashedMap();
    }

    @Test
    public void testClone() {
        HashedMap map = new HashedMap(10);
        map.put((Object)"1", (Object)"1");
        HashedMap cloned = map.clone();
        Assertions.assertEquals((int)map.size(), (int)cloned.size());
        Assertions.assertSame((Object)map.get((Object)"1"), (Object)cloned.get((Object)"1"));
    }

    @Test
    public void testInitialCapacityZero() {
        HashedMap map = new HashedMap(0);
        Assertions.assertEquals((int)1, (int)map.data.length);
    }

    @Test
    public void testInternalState() {
        HashedMap map = new HashedMap(42, 0.75f);
        Assertions.assertEquals((float)0.75f, (float)map.loadFactor, (float)0.1f);
        Assertions.assertEquals((int)0, (int)map.size);
        Assertions.assertEquals((int)64, (int)map.data.length);
        Assertions.assertEquals((int)48, (int)map.threshold);
        Assertions.assertEquals((int)0, (int)map.modCount);
        HashedMap tmpMap = new HashedMap();
        for (int i = 1; i <= map.threshold; ++i) {
            tmpMap.put((Object)i, (Object)i);
        }
        map.putAll((Map)tmpMap);
        Assertions.assertEquals((int)96, (int)map.threshold);
    }
}

