/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.comparators.NullComparator;
import org.apache.commons.collections4.iterators.AbstractOrderedMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractOrderedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public AbstractOrderedMapTest(String testName) {
        super(testName);
    }

    public BulkTest bulkTestOrderedMapIterator() {
        return new InnerTestOrderedMapIterator();
    }

    @Override
    public OrderedMap<K, V> getMap() {
        return (OrderedMap)super.getMap();
    }

    @Override
    public K[] getSampleKeys() {
        ArrayList list = new ArrayList(Arrays.asList(super.getSampleKeys()));
        list.sort(new NullComparator());
        return list.toArray();
    }

    @Override
    public Map<K, V> makeConfirmedMap() {
        return new TreeMap(new NullComparator());
    }

    @Override
    public OrderedMap<K, V> makeFullMap() {
        return (OrderedMap)super.makeFullMap();
    }

    @Override
    public abstract OrderedMap<K, V> makeObject();

    @Test
    public void testFirstKey() {
        OrderedMap ordered;
        this.resetEmpty();
        OrderedMap finalOrdered = ordered = this.getMap();
        Assertions.assertThrows(NoSuchElementException.class, () -> finalOrdered.firstKey());
        this.resetFull();
        ordered = this.getMap();
        Object confirmedFirst = this.confirmed.keySet().iterator().next();
        Assertions.assertEquals(confirmedFirst, (Object)ordered.firstKey());
    }

    @Test
    public void testLastKey() {
        OrderedMap ordered;
        this.resetEmpty();
        OrderedMap finalOrdered = ordered = this.getMap();
        Assertions.assertThrows(NoSuchElementException.class, () -> finalOrdered.lastKey());
        this.resetFull();
        ordered = this.getMap();
        Object confirmedLast2 = null;
        for (Object confirmedLast2 : this.confirmed.keySet()) {
        }
        Assertions.assertEquals(confirmedLast2, (Object)ordered.lastKey());
    }

    @Test
    public void testNextKey() {
        this.resetEmpty();
        OrderedMap ordered = this.getMap();
        Assertions.assertNull((Object)ordered.nextKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assertions.assertNull((Object)ordered.nextKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Assertions.assertNull((Object)ordered.nextKey(null));
        }
        this.resetFull();
        ordered = this.getMap();
        Iterator it = this.confirmed.keySet().iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assertions.assertEquals(confirmedObject, (Object)ordered.nextKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assertions.assertNull((Object)ordered.nextKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            OrderedMap finalOrdered = ordered;
            Assertions.assertThrows(NullPointerException.class, () -> finalOrdered.nextKey(null));
        } else {
            Assertions.assertNull((Object)ordered.nextKey(null));
        }
    }

    @Test
    public void testPreviousKey() {
        this.resetEmpty();
        OrderedMap ordered = this.getMap();
        Assertions.assertNull((Object)ordered.previousKey(this.getOtherKeys()[0]));
        if (!this.isAllowNullKey()) {
            try {
                Assertions.assertNull((Object)ordered.previousKey(null));
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            Assertions.assertNull((Object)ordered.previousKey(null));
        }
        this.resetFull();
        ordered = this.getMap();
        ArrayList list = new ArrayList(this.confirmed.keySet());
        Collections.reverse(list);
        Iterator it = list.iterator();
        Object confirmedLast = it.next();
        while (it.hasNext()) {
            Object confirmedObject = it.next();
            Assertions.assertEquals(confirmedObject, (Object)ordered.previousKey(confirmedLast));
            confirmedLast = confirmedObject;
        }
        Assertions.assertNull((Object)ordered.previousKey(confirmedLast));
        if (!this.isAllowNullKey()) {
            OrderedMap finalOrdered = ordered;
            Assertions.assertThrows(NullPointerException.class, () -> finalOrdered.previousKey(null));
        } else if (!this.isAllowNullKey()) {
            Assertions.assertNull((Object)ordered.previousKey(null));
        }
    }

    public class InnerTestOrderedMapIterator
    extends AbstractOrderedMapIteratorTest<K, V> {
        public InnerTestOrderedMapIterator() {
            super("InnerTestOrderedMapIterator");
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractOrderedMapTest.this.getConfirmed();
        }

        @Override
        public OrderedMap<K, V> getMap() {
            return AbstractOrderedMapTest.this.getMap();
        }

        @Override
        public boolean isGetStructuralModify() {
            return AbstractOrderedMapTest.this.isGetStructuralModify();
        }

        @Override
        public OrderedMapIterator<K, V> makeEmptyIterator() {
            AbstractOrderedMapTest.this.resetEmpty();
            return AbstractOrderedMapTest.this.getMap().mapIterator();
        }

        @Override
        public OrderedMapIterator<K, V> makeObject() {
            AbstractOrderedMapTest.this.resetFull();
            return AbstractOrderedMapTest.this.getMap().mapIterator();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractOrderedMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractOrderedMapTest.this.isSetValueSupported();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractOrderedMapTest.this.verify();
        }
    }
}

