/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractIterableMapTest<K, V>
extends AbstractMapTest<K, V> {
    public AbstractIterableMapTest(String testName) {
        super(testName);
    }

    public BulkTest bulkTestMapIterator() {
        return new InnerTestMapIterator();
    }

    @Override
    public IterableMap<K, V> getMap() {
        return (IterableMap)super.getMap();
    }

    @Override
    public IterableMap<K, V> makeFullMap() {
        return (IterableMap)super.makeFullMap();
    }

    @Override
    public abstract IterableMap<K, V> makeObject();

    @Test
    public void testFailFastEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().entrySet().iterator();
        Map.Entry val = (Map.Entry)it.next();
        this.getMap().remove(val.getKey());
        Iterator finalIt0 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt0.next());
        this.resetFull();
        it = this.getMap().entrySet().iterator();
        it.next();
        this.getMap().clear();
        Iterator finalIt1 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt1.next());
    }

    @Test
    public void testFailFastKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().keySet().iterator();
        Object val = it.next();
        this.getMap().remove(val);
        Iterator finalIt0 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt0.next());
        this.resetFull();
        it = this.getMap().keySet().iterator();
        it.next();
        this.getMap().clear();
        Iterator finalIt1 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt1.next());
    }

    @Test
    public void testFailFastValues() {
        if (!this.isRemoveSupported()) {
            return;
        }
        if (!this.isFailFastExpected()) {
            return;
        }
        this.resetFull();
        Iterator it = this.getMap().values().iterator();
        it.next();
        this.getMap().remove(this.getMap().keySet().iterator().next());
        Iterator finalIt0 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt0.next());
        this.resetFull();
        it = this.getMap().values().iterator();
        it.next();
        this.getMap().clear();
        Iterator finalIt1 = it;
        Assertions.assertThrows(ConcurrentModificationException.class, () -> finalIt1.next());
    }

    public class InnerTestMapIterator
    extends AbstractMapIteratorTest<K, V> {
        public InnerTestMapIterator() {
            super("InnerTestMapIterator");
        }

        @Override
        public V[] addSetValues() {
            return AbstractIterableMapTest.this.getNewSampleValues();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractIterableMapTest.this.getConfirmed();
        }

        @Override
        public Map<K, V> getMap() {
            return AbstractIterableMapTest.this.getMap();
        }

        @Override
        public boolean isGetStructuralModify() {
            return AbstractIterableMapTest.this.isGetStructuralModify();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractIterableMapTest.this.resetEmpty();
            return AbstractIterableMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractIterableMapTest.this.resetFull();
            return AbstractIterableMapTest.this.getMap().mapIterator();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractIterableMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractIterableMapTest.this.isSetValueSupported();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractIterableMapTest.this.verify();
        }
    }
}

