/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.AbstractObjectTest;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.list.LazyList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyListTest
extends AbstractObjectTest {
    public LazyListTest() {
        super(LazyListTest.class.getSimpleName());
    }

    @Override
    public Object makeObject() {
        Factory dateFactory = LocalDateTime::now;
        return new LazyList(new ArrayList(), dateFactory);
    }

    @Override
    @Test
    public void testCanonicalEmptyCollectionExists() {
    }

    @Override
    @Test
    public void testCanonicalFullCollectionExists() {
    }

    @Test
    public void testCreateNullGapsWithFactory() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertNotNull((Object)fourthElement);
    }

    @Test
    public void testCreateNullGapsWithTransformer() {
        List<Integer> hours = Arrays.asList(7, 5, 8, 2);
        Transformer dateFactory = input -> LocalDateTime.now().withHour((Integer)hours.get((int)input));
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertNotNull((Object)fourthElement);
    }

    @Test
    public void testElementCreationWithFactory() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        Assertions.assertTrue((boolean)list.isEmpty());
        LocalDateTime firstElement = (LocalDateTime)list.get(0);
        Assertions.assertNotNull((Object)firstElement);
        Assertions.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void testElementCreationWithTransformer() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        Assertions.assertTrue((boolean)list.isEmpty());
        LocalDateTime firstElement = (LocalDateTime)list.get(0);
        Assertions.assertNotNull((Object)firstElement);
        Assertions.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void testGetWithNull() {
        List<Integer> hours = Arrays.asList(7, 5, 8, 2);
        Transformer transformer = input -> LocalDateTime.now().withHour((Integer)hours.get((int)input));
        LazyList list = new LazyList(new ArrayList(), transformer);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertNotNull((Object)fourthElement);
        list.remove(3);
        list.add(3, null);
        fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertNotNull((Object)fourthElement);
    }

    @Override
    @Test
    public void testSerializeDeserializeThenCompare() {
    }

    @Override
    @Test
    public void testSimpleSerialization() {
    }

    private void testSubList(List<LocalDateTime> list) {
        List<LocalDateTime> subList = list.subList(1, 3);
        Assertions.assertFalse((boolean)subList.isEmpty());
        Assertions.assertNotNull(subList);
        Assertions.assertEquals((int)2, (int)subList.size());
        subList = list.subList(0, 1);
        Assertions.assertFalse((boolean)subList.isEmpty());
        Assertions.assertEquals((int)1, (int)subList.size());
        subList = list.subList(1, 1);
        Assertions.assertTrue((boolean)subList.isEmpty());
        subList = list.subList(0, list.size());
        Assertions.assertFalse((boolean)subList.isEmpty());
        Assertions.assertEquals((int)list.size(), (int)subList.size());
    }

    @Test
    public void testSubListWitheFactory() {
        Factory dateFactory = LocalDateTime::now;
        LazyList list = new LazyList(new ArrayList(), dateFactory);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertNotNull((Object)fourthElement);
        this.testSubList((List<LocalDateTime>)list);
    }

    @Test
    public void testSubListWithTransformer() {
        List<Integer> hours = Arrays.asList(7, 5, 8, 2);
        Transformer transformer = input -> LocalDateTime.now().withHour((Integer)hours.get((int)input));
        LazyList list = new LazyList(new ArrayList(), transformer);
        LocalDateTime fourthElement = (LocalDateTime)list.get(3);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertNotNull((Object)fourthElement);
        this.testSubList((List<LocalDateTime>)list);
    }
}

