/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnmodifiableListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};
    protected List<E> testList;

    public UnmodifiableListIteratorTest() {
        super(UnmodifiableListIteratorTest.class.getSimpleName());
    }

    @Override
    public ListIterator<E> makeEmptyIterator() {
        return UnmodifiableListIterator.unmodifiableListIterator(Collections.emptyList().listIterator());
    }

    @Override
    public ListIterator<E> makeObject() {
        return UnmodifiableListIterator.unmodifiableListIterator(this.testList.listIterator());
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsSet() {
        return false;
    }

    @Test
    public void testDecorateFactory() {
        ListIterator<E> it = this.makeObject();
        Assertions.assertSame((Object)it, (Object)UnmodifiableListIterator.unmodifiableListIterator((ListIterator)it));
        it = this.testList.listIterator();
        Assertions.assertNotSame(it, (Object)UnmodifiableListIterator.unmodifiableListIterator(it));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableListIterator.unmodifiableListIterator(null));
    }

    @Test
    public void testListIterator() {
        Assertions.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }
}

