/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.UniqueFilterIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UniqueFilterIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<E> list1;

    public UniqueFilterIteratorTest() {
        super(UniqueFilterIteratorTest.class.getSimpleName());
    }

    @Override
    public UniqueFilterIterator<E> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new UniqueFilterIterator(list.iterator());
    }

    @Override
    public UniqueFilterIterator<E> makeObject() {
        Iterator<E> i = this.list1.iterator();
        return new UniqueFilterIterator(i);
    }

    @BeforeEach
    public void setUp() {
        this.list1 = new ArrayList();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list1.add("Two");
        this.list1.add("One");
        this.list1.add("Four");
        this.list1.add("Five");
        this.list1.add("Five");
        this.list1.add("Six");
        this.list1.add("Five");
    }

    @Test
    public void testIterator() {
        UniqueFilterIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator should now be empty");
        try {
            iter.next();
        }
        catch (Exception e) {
            Assertions.assertEquals(e.getClass(), new NoSuchElementException().getClass(), (String)"NoSuchElementException must be thrown");
        }
    }
}

