/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.SkippingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SkippingIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c", "d", "e", "f", "g"};
    private List<E> testList;

    public SkippingIteratorTest() {
        super(SkippingIteratorTest.class.getSimpleName());
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return new SkippingIterator(Collections.emptyList().iterator(), 0L);
    }

    @Override
    public Iterator<E> makeObject() {
        return new SkippingIterator(new ArrayList<E>(this.testList).iterator(), 1L);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testList = Arrays.asList((Object[])this.testArray);
    }

    @Test
    public void testNegativeOffset() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SkippingIterator(this.testList.iterator(), -1L), (String)"Expected IllegalArgumentException.");
    }

    @Test
    public void testOffsetGreaterThanSize() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 10L);
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testOffsetGreaterThanSize$1((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testRemoveCalledTwice() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 1L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        iter.remove();
        Assertions.assertThrows(IllegalStateException.class, () -> SkippingIteratorTest.lambda$testRemoveCalledTwice$2((Iterator)iter), (String)"Expected IllegalStateException.");
    }

    @Test
    public void testRemoveFirst() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 4L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("e"));
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testRemoveFirst$3((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testRemoveLast() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 5L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testRemoveLast$4((Iterator)iter), (String)"Expected NoSuchElementException.");
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("g"));
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testRemoveLast$5((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testRemoveMiddle() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 3L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        iter.remove();
        Assertions.assertFalse((boolean)testListCopy.contains("d"));
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testRemoveMiddle$6((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testRemoveUnsupported() {
        AbstractIteratorDecorator mockIterator = new AbstractIteratorDecorator<E>(this.testList.iterator()){

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        SkippingIterator iter = new SkippingIterator((Iterator)mockIterator, 1L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> SkippingIteratorTest.lambda$testRemoveUnsupported$7((Iterator)iter), (String)"Expected UnsupportedOperationException.");
    }

    @Test
    public void testRemoveWithoutCallingNext() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        SkippingIterator iter = new SkippingIterator(testListCopy.iterator(), 1L);
        Assertions.assertThrows(IllegalStateException.class, () -> SkippingIteratorTest.lambda$testRemoveWithoutCallingNext$8((Iterator)iter), (String)"Expected IllegalStateException.");
    }

    @Test
    public void testSameAsDecorated() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 0L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"a", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"b", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testSameAsDecorated$9((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    @Test
    public void testSkipping() {
        SkippingIterator iter = new SkippingIterator(this.testList.iterator(), 2L);
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"c", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"d", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"e", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"f", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"g", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> SkippingIteratorTest.lambda$testSkipping$10((Iterator)iter), (String)"Expected NoSuchElementException.");
    }

    private static /* synthetic */ void lambda$testSkipping$10(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testSameAsDecorated$9(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveWithoutCallingNext$8(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testRemoveUnsupported$7(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testRemoveMiddle$6(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveLast$5(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveLast$4(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveFirst$3(Iterator iter) throws Throwable {
        iter.next();
    }

    private static /* synthetic */ void lambda$testRemoveCalledTwice$2(Iterator iter) throws Throwable {
        iter.remove();
    }

    private static /* synthetic */ void lambda$testOffsetGreaterThanSize$1(Iterator iter) throws Throwable {
        iter.next();
    }
}

