/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PushbackIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c"};
    private List<E> testList;

    public PushbackIteratorTest() {
        super(PushbackIteratorTest.class.getSimpleName());
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return PushbackIterator.pushbackIterator(Collections.emptyList().iterator());
    }

    @Override
    public PushbackIterator<E> makeObject() {
        return PushbackIterator.pushbackIterator(this.testList.iterator());
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testDelayedPushback() {
        PushbackIterator<E> iter = this.makeObject();
        Assertions.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        Assertions.assertEquals((Object)"x", (Object)iter.next());
        Assertions.assertEquals((Object)"b", (Object)iter.next());
        this.validate((Iterator<E>)iter, "c");
    }

    @Test
    public void testImmediatePushback() {
        PushbackIterator<E> iter = this.makeObject();
        iter.pushback((Object)"x");
        Assertions.assertEquals((Object)"x", (Object)iter.next());
        Assertions.assertEquals((Object)"a", (Object)iter.next());
        this.validate((Iterator<E>)iter, "b", "c");
    }

    @Test
    public void testMultiplePushback() {
        PushbackIterator<E> iter = this.makeObject();
        Assertions.assertEquals((Object)"a", (Object)iter.next());
        iter.pushback((Object)"x");
        iter.pushback((Object)"y");
        Assertions.assertEquals((Object)"y", (Object)iter.next());
        Assertions.assertEquals((Object)"x", (Object)iter.next());
        Assertions.assertEquals((Object)"b", (Object)iter.next());
        this.validate((Iterator<E>)iter, "c");
    }

    @Test
    public void testNormalIteration() {
        PushbackIterator<E> iter = this.makeObject();
        Assertions.assertEquals((Object)"a", (Object)iter.next());
        Assertions.assertEquals((Object)"b", (Object)iter.next());
        Assertions.assertEquals((Object)"c", (Object)iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    private void validate(Iterator<E> iter, Object ... items) {
        for (Object x : items) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((Object)x, iter.next());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }
}

