/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PeekingIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c"};
    private List<E> testList;

    public PeekingIteratorTest() {
        super(PeekingIteratorTest.class.getSimpleName());
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return PeekingIterator.peekingIterator(Collections.emptyList().iterator());
    }

    @Override
    public PeekingIterator<E> makeObject() {
        return PeekingIterator.peekingIterator(this.testList.iterator());
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Test
    public void testEmpty() {
        Iterator<E> it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIllegalRemove() {
        PeekingIterator it = this.makeObject();
        it.next();
        it.remove();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"b", (Object)it.peek());
        Assertions.assertThrows(IllegalStateException.class, () -> it.remove());
    }

    @Test
    public void testIteratorExhausted() {
        PeekingIterator it = this.makeObject();
        it.next();
        it.next();
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertNull((Object)it.peek());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.element());
    }

    @Test
    public void testMultiplePeek() {
        PeekingIterator<E> it = this.makeObject();
        Assertions.assertEquals((Object)"a", (Object)it.peek());
        Assertions.assertEquals((Object)"a", (Object)it.peek());
        Assertions.assertEquals((Object)"a", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"b", (Object)it.peek());
        Assertions.assertEquals((Object)"b", (Object)it.peek());
        Assertions.assertEquals((Object)"b", (Object)it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"c", (Object)it.peek());
        Assertions.assertEquals((Object)"c", (Object)it.peek());
        Assertions.assertEquals((Object)"c", (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSinglePeek() {
        PeekingIterator<E> it = this.makeObject();
        Assertions.assertEquals((Object)"a", (Object)it.peek());
        Assertions.assertEquals((Object)"a", (Object)it.element());
        this.validate((Iterator<E>)it, (E[])this.testArray);
    }

    private void validate(Iterator<E> iter, E ... items) {
        for (E x : items) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals(x, iter.next());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }
}

