/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.LoopingListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class LoopingListIteratorTest {
    @Test
    public void testAdd() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.add((Object)"c");
        Assertions.assertEquals((Object)"e", (Object)loop.next());
        Assertions.assertEquals((Object)"e", (Object)loop.previous());
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        loop.add((Object)"d");
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        Assertions.assertEquals((Object)"d", (Object)loop.next());
        Assertions.assertEquals((Object)"e", (Object)loop.next());
        Assertions.assertEquals((Object)"f", (Object)loop.next());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        list = new ArrayList<String>(Arrays.asList("b", "e", "f"));
        loop = new LoopingListIterator(list);
        loop.add((Object)"a");
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        loop.reset();
        Assertions.assertEquals((Object)"f", (Object)loop.previous());
        Assertions.assertEquals((Object)"e", (Object)loop.previous());
        loop.add((Object)"d");
        Assertions.assertEquals((Object)"d", (Object)loop.previous());
        loop.add((Object)"c");
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        Assertions.assertEquals((Object)"d", (Object)loop.next());
        Assertions.assertEquals((Object)"e", (Object)loop.next());
        Assertions.assertEquals((Object)"f", (Object)loop.next());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testConstructorEx() {
        Assertions.assertThrows(NullPointerException.class, () -> new LoopingListIterator(null));
    }

    @Test
    public void testJoggingNotOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
    }

    @Test
    public void testJoggingOverBoundary() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testLooping0() {
        ArrayList list = new ArrayList();
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertFalse((boolean)loop.hasNext());
        Assertions.assertFalse((boolean)loop.hasPrevious());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NoSuchElementException.class, () -> loop.next()), () -> Assertions.assertThrows(NoSuchElementException.class, () -> loop.previous())});
    }

    @Test
    public void testLooping1() {
        List<String> list = Arrays.asList("a");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testLooping2() {
        List<String> list = Arrays.asList("a", "b");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
    }

    @Test
    public void testNextAndPreviousIndex() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertEquals((int)0, (int)loop.nextIndex());
        Assertions.assertEquals((int)2, (int)loop.previousIndex());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((int)1, (int)loop.nextIndex());
        Assertions.assertEquals((int)0, (int)loop.previousIndex());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertEquals((int)0, (int)loop.nextIndex());
        Assertions.assertEquals((int)2, (int)loop.previousIndex());
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        Assertions.assertEquals((int)2, (int)loop.nextIndex());
        Assertions.assertEquals((int)1, (int)loop.previousIndex());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertEquals((int)1, (int)loop.nextIndex());
        Assertions.assertEquals((int)0, (int)loop.previousIndex());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        Assertions.assertEquals((int)0, (int)loop.nextIndex());
        Assertions.assertEquals((int)2, (int)loop.previousIndex());
    }

    @Test
    public void testRemovingElementsAndIteratingBackwards() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        loop.remove();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        loop.remove();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)loop.hasPrevious());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
        loop.remove();
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertFalse((boolean)loop.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> loop.previous());
    }

    @Test
    public void testRemovingElementsAndIteratingForward() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertTrue((boolean)loop.hasNext());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertFalse((boolean)loop.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> loop.next());
    }

    @Test
    public void testReset() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        loop.reset();
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        loop.reset();
        Assertions.assertEquals((Object)"c", (Object)loop.previous());
        Assertions.assertEquals((Object)"b", (Object)loop.previous());
        Assertions.assertEquals((Object)"a", (Object)loop.previous());
    }

    @Test
    public void testSet() {
        List<String> list = Arrays.asList("q", "r", "z");
        LoopingListIterator loop = new LoopingListIterator(list);
        Assertions.assertEquals((Object)"z", (Object)loop.previous());
        loop.set((Object)"c");
        loop.reset();
        Assertions.assertEquals((Object)"q", (Object)loop.next());
        loop.set((Object)"a");
        Assertions.assertEquals((Object)"r", (Object)loop.next());
        loop.set((Object)"b");
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
    }
}

