/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractListIteratorTest<E>
extends AbstractIteratorTest<E> {
    public AbstractListIteratorTest(String testName) {
        super(testName);
    }

    public E addSetValue() {
        return null;
    }

    @Override
    public abstract ListIterator<E> makeEmptyIterator();

    @Override
    public abstract ListIterator<E> makeObject();

    public boolean supportsAdd() {
        return true;
    }

    public boolean supportsSet() {
        return true;
    }

    @Test
    public void testAdd() {
        Iterator it = this.makeObject();
        E addValue = this.addSetValue();
        if (!this.supportsAdd()) {
            Iterator finalIt0 = it;
            Assertions.assertThrows(UnsupportedOperationException.class, () -> AbstractListIteratorTest.lambda$testAdd$0((ListIterator)finalIt0, addValue), (String)("UnsupportedOperationException must be thrown from add of " + it.getClass().getSimpleName()));
            return;
        }
        it = this.makeObject();
        it.add(addValue);
        Assertions.assertEquals(addValue, it.previous());
        it = this.makeObject();
        it.add(addValue);
        Assertions.assertNotSame(addValue, it.next());
        it = this.makeObject();
        while (it.hasNext()) {
            it.next();
            it.add(addValue);
            Assertions.assertEquals(addValue, it.previous());
            it.next();
        }
    }

    @Test
    public void testAddThenRemove() {
        Iterator it = this.makeObject();
        if (this.supportsAdd() && this.supportsRemove()) {
            it.next();
            it.add(this.addSetValue());
            Assertions.assertThrows(IllegalStateException.class, () -> AbstractListIteratorTest.lambda$testAddThenRemove$1((ListIterator)it), (String)"IllegalStateException must be thrown from remove after add");
        }
    }

    @Test
    public void testAddThenSet() {
        Iterator it = this.makeObject();
        if (this.supportsAdd() && this.supportsSet()) {
            it.next();
            it.add(this.addSetValue());
            Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$testAddThenSet$2((ListIterator)it), (String)"IllegalStateException must be thrown from set after add");
        }
    }

    @Test
    public void testEmptyListIteratorIsIndeedEmpty() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        Iterator it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)0, (int)it.nextIndex());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((int)-1, (int)it.previousIndex());
        Assertions.assertThrows(NoSuchElementException.class, () -> AbstractListIteratorTest.lambda$testEmptyListIteratorIsIndeedEmpty$3((ListIterator)it), (String)"NoSuchElementException must be thrown from empty ListIterator");
        Assertions.assertThrows(NoSuchElementException.class, () -> AbstractListIteratorTest.lambda$testEmptyListIteratorIsIndeedEmpty$4((ListIterator)it), (String)"NoSuchElementException must be thrown from empty ListIterator");
    }

    @Test
    public void testRemoveThenSet() {
        Iterator it = this.makeObject();
        if (this.supportsRemove() && this.supportsSet()) {
            it.next();
            it.remove();
            Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$testRemoveThenSet$5((ListIterator)it), (String)"IllegalStateException must be thrown from set after remove");
        }
    }

    @Test
    public void testSet() {
        Iterator it = this.makeObject();
        if (!this.supportsSet()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.lambda$testSet$6((ListIterator)it), (String)("UnsupportedOperationException must be thrown from set in " + it.getClass().getSimpleName()));
            return;
        }
        Assertions.assertThrows(IllegalStateException.class, () -> this.lambda$testSet$7((ListIterator)it));
        it.next();
        it.set(this.addSetValue());
        it.set(this.addSetValue());
    }

    @Test
    public void testWalkForwardAndBack() {
        ArrayList list = new ArrayList();
        Iterator it = this.makeObject();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> AbstractListIteratorTest.lambda$testWalkForwardAndBack$8((ListIterator)it), (String)"NoSuchElementException must be thrown from next at end of ListIterator");
        for (int i = list.size() - 1; i >= 0; --i) {
            Assertions.assertEquals((int)(i + 1), (int)it.nextIndex());
            Assertions.assertEquals((int)i, (int)it.previousIndex());
            Object obj = list.get(i);
            Assertions.assertEquals(obj, it.previous());
        }
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> AbstractListIteratorTest.lambda$testWalkForwardAndBack$9((ListIterator)it), (String)"NoSuchElementException must be thrown from previous at start of ListIterator");
    }

    private static /* synthetic */ void lambda$testWalkForwardAndBack$9(ListIterator it) throws Throwable {
        it.previous();
    }

    private static /* synthetic */ void lambda$testWalkForwardAndBack$8(ListIterator it) throws Throwable {
        it.next();
    }

    private /* synthetic */ void lambda$testSet$7(ListIterator it) throws Throwable {
        it.set(this.addSetValue());
    }

    private /* synthetic */ void lambda$testSet$6(ListIterator it) throws Throwable {
        it.set(this.addSetValue());
    }

    private /* synthetic */ void lambda$testRemoveThenSet$5(ListIterator it) throws Throwable {
        it.set(this.addSetValue());
    }

    private static /* synthetic */ void lambda$testEmptyListIteratorIsIndeedEmpty$4(ListIterator it) throws Throwable {
        it.previous();
    }

    private static /* synthetic */ void lambda$testEmptyListIteratorIsIndeedEmpty$3(ListIterator it) throws Throwable {
        it.next();
    }

    private /* synthetic */ void lambda$testAddThenSet$2(ListIterator it) throws Throwable {
        it.set(this.addSetValue());
    }

    private static /* synthetic */ void lambda$testAddThenRemove$1(ListIterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testAdd$0(ListIterator finalIt0, Object addValue) throws Throwable {
        finalIt0.add(addValue);
    }
}

