/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class WrappedBloomFilterTest
extends AbstractBloomFilterTest<WrappedBloomFilter> {
    @Override
    protected WrappedBloomFilter createEmptyFilter(final Shape shape) {
        return new WrappedBloomFilter(new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape)){

            public BloomFilter copy() {
                DefaultBloomFilterTest.SparseDefaultBloomFilter result = new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape);
                result.merge(this.getWrapped());
                return result;
            }
        };
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 34})
    public void testCharacteristics(final int characteristics) {
        final Shape shape = this.getTestShape();
        DefaultBloomFilterTest.SparseDefaultBloomFilter inner = new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape){

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
        WrappedBloomFilter underTest = new WrappedBloomFilter(inner){

            public BloomFilter copy() {
                DefaultBloomFilterTest.SparseDefaultBloomFilter result = new DefaultBloomFilterTest.SparseDefaultBloomFilter(shape);
                result.merge(this.getWrapped());
                return result;
            }
        };
        Assertions.assertEquals((int)characteristics, (int)underTest.characteristics());
    }
}

