/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractBitMapExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.DefaultBloomFilterTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.WrappedBloomFilter;

public class BitMapExtractorFromWrappedBloomFilterTest
extends AbstractBitMapExtractorTest {
    protected Shape shape = Shape.fromKM((int)17, (int)72);

    @Override
    protected BitMapExtractor createEmptyExtractor() {
        return new WrappedBloomFilter(new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.shape)){

            public BloomFilter copy() {
                DefaultBloomFilterTest.SparseDefaultBloomFilter result = new DefaultBloomFilterTest.SparseDefaultBloomFilter(BitMapExtractorFromWrappedBloomFilterTest.this.shape);
                result.merge(this.getWrapped());
                return result;
            }
        };
    }

    @Override
    protected BitMapExtractor createExtractor() {
        IncrementingHasher hasher = new IncrementingHasher(0L, 1L);
        WrappedBloomFilter bf = new WrappedBloomFilter(new DefaultBloomFilterTest.SparseDefaultBloomFilter(this.shape)){

            public BloomFilter copy() {
                DefaultBloomFilterTest.SparseDefaultBloomFilter result = new DefaultBloomFilterTest.SparseDefaultBloomFilter(BitMapExtractorFromWrappedBloomFilterTest.this.shape);
                result.merge(this.getWrapped());
                return result;
            }
        };
        bf.merge((Hasher)hasher);
        return bf;
    }
}

