/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractOrderedBidiMapTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSortedBidiMapTest<K extends Comparable<K>, V extends Comparable<V>>
extends AbstractOrderedBidiMapTest<K, V> {
    protected List<K> sortedKeys;
    protected List<V> sortedValues = new ArrayList<V>();
    protected SortedSet<V> sortedNewValues = new TreeSet<V>();

    public AbstractSortedBidiMapTest(String testName) {
        super(testName);
        this.sortedKeys = this.getAsList(this.getSampleKeys());
        this.sortedKeys.sort(null);
        this.sortedKeys = Collections.unmodifiableList(this.sortedKeys);
        TreeMap map = new TreeMap();
        this.addSampleMappings(map);
        this.sortedValues.addAll(map.values());
        this.sortedValues = Collections.unmodifiableList(this.sortedValues);
        this.sortedNewValues.addAll(this.getAsList(this.getNewSampleValues()));
    }

    public BulkTest bulkTestHeadMap() {
        return new AbstractSortedMapTest.TestHeadMap(this);
    }

    public BulkTest bulkTestSubMap() {
        return new AbstractSortedMapTest.TestSubMap(this);
    }

    public BulkTest bulkTestTailMap() {
        return new AbstractSortedMapTest.TestTailMap(this);
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValue() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeConfirmedMap() {
        return new TreeMap();
    }

    @Override
    public SortedBidiMap<K, V> makeFullMap() {
        return (SortedBidiMap)super.makeFullMap();
    }

    @Override
    public abstract SortedBidiMap<K, V> makeObject();

    @Test
    public void testBidiClearByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable toKeyValue = (Comparable)sm.get((Object)toKey);
        SortedMap sub = sm.headMap((Object)toKey);
        int size = sm.size();
        Assertions.assertEquals((int)2, (int)sub.size());
        sub.clear();
        Assertions.assertEquals((int)0, (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)toKey));
        Assertions.assertTrue((boolean)sm.containsValue((Object)toKeyValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsKey((Object)toKeyValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsValue((Object)toKey));
        Assertions.assertFalse((boolean)sub.containsKey(toKey));
        Assertions.assertFalse((boolean)sub.containsValue(toKeyValue));
    }

    @Test
    public void testBidiClearBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable toKeyValue = (Comparable)sm.get((Object)toKey);
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        int size = sm.size();
        Assertions.assertEquals((int)3, (int)sub.size());
        sub.clear();
        Assertions.assertEquals((int)0, (int)sub.size());
        Assertions.assertEquals((int)(size - 3), (int)sm.size());
        Assertions.assertEquals((int)(size - 3), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)fromKey));
        Assertions.assertFalse((boolean)sm.containsValue((Object)fromKeyValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)fromKeyValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)fromKey));
        Assertions.assertFalse((boolean)sub.containsKey(fromKey));
        Assertions.assertFalse((boolean)sub.containsValue(fromKeyValue));
        Assertions.assertFalse((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)toKey));
        Assertions.assertTrue((boolean)sm.containsValue((Object)toKeyValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsKey((Object)toKeyValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsValue((Object)toKey));
        Assertions.assertFalse((boolean)sub.containsKey(toKey));
        Assertions.assertFalse((boolean)sub.containsValue(toKeyValue));
    }

    @Test
    public void testBidiClearByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap sub = sm.tailMap((Object)fromKey);
        int size = sm.size();
        Assertions.assertEquals((int)(size - 3), (int)sub.size());
        sub.clear();
        Assertions.assertEquals((int)0, (int)sub.size());
        Assertions.assertEquals((int)3, (int)sm.size());
        Assertions.assertEquals((int)3, (int)sm.inverseBidiMap().size());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        Assertions.assertTrue((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Assertions.assertFalse((boolean)sm.containsKey((Object)fromKey));
        Assertions.assertFalse((boolean)sm.containsValue((Object)fromKeyValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)fromKeyValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)fromKey));
        Assertions.assertFalse((boolean)sub.containsKey(fromKey));
        Assertions.assertFalse((boolean)sub.containsValue(fromKeyValue));
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
    }

    @Test
    public void testBidiHeadMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap head = sm.headMap((Object)toKey);
        Assertions.assertEquals((int)1, (int)head.size());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)head.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertTrue((boolean)head.containsValue(firstValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)head.containsKey(second));
        Assertions.assertTrue((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)head.containsValue(secondValue));
    }

    @Test
    public void testBidiRemoveByHeadMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap((Object)toKey);
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Comparable firstValue = (Comparable)sub.remove(first);
        Assertions.assertEquals((int)1, (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Comparable secondValue = (Comparable)sub.remove(second);
        Assertions.assertEquals((int)0, (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
    }

    @Test
    public void testBidiRemoveByHeadMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.headMap((Object)toKey);
        Set set = sub.entrySet();
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertEquals((int)2, (int)set.size());
        Iterator it2 = set.iterator();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)set.contains(firstEntry));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Assertions.assertTrue((boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assertions.assertEquals((int)1, (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assertions.assertEquals((int)0, (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(secondEntry));
    }

    @Test
    public void testBidiRemoveBySubMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Comparable firstValue = (Comparable)sub.remove(first);
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Comparable secondValue = (Comparable)sub.remove(second);
        Assertions.assertEquals((int)1, (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey((Object)secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
    }

    @Test
    public void testBidiRemoveBySubMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        Set set = sub.entrySet();
        Assertions.assertEquals((int)3, (int)set.size());
        Iterator it2 = set.iterator();
        it2.next();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)set.contains(firstEntry));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Assertions.assertTrue((boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assertions.assertEquals((int)1, (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(secondEntry));
    }

    @Test
    public void testBidiRemoveByTailMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap((Object)fromKey);
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Object firstValue = sub.remove(first);
        Assertions.assertEquals((int)(size - 3), (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sm.containsValue(firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(firstValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Object secondValue = sub.remove(second);
        Assertions.assertEquals((int)(size - 4), (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey((Object)second));
        Assertions.assertFalse((boolean)sm.containsValue(secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(secondValue));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue((Object)second));
        Assertions.assertFalse((boolean)sub.containsKey(second));
        Assertions.assertFalse((boolean)sub.containsValue(secondValue));
    }

    @Test
    public void testBidiRemoveByTailMapEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        it.next();
        it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable first = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        int size = sm.size();
        SortedMap sub = sm.tailMap((Object)fromKey);
        Set set = sub.entrySet();
        Iterator it2 = set.iterator();
        it2.next();
        Map.Entry firstEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Map.Entry secondEntry = AbstractSortedBidiMapTest.cloneMapEntry(it2.next());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertTrue((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)set.contains(firstEntry));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Assertions.assertTrue((boolean)set.contains(secondEntry));
        set.remove(firstEntry);
        Assertions.assertEquals((int)(size - 3), (int)sub.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.size());
        Assertions.assertEquals((int)(size - 1), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(firstEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(firstEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(firstEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(firstEntry));
        set.remove(secondEntry);
        Assertions.assertEquals((int)(size - 4), (int)sub.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.size());
        Assertions.assertEquals((int)(size - 2), (int)sm.inverseBidiMap().size());
        Assertions.assertFalse((boolean)sm.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sm.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsKey(secondEntry.getValue()));
        Assertions.assertFalse((boolean)sm.inverseBidiMap().containsValue(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsKey(secondEntry.getKey()));
        Assertions.assertFalse((boolean)sub.containsValue(secondEntry.getValue()));
        Assertions.assertFalse((boolean)set.contains(secondEntry));
    }

    @Test
    public void testBidiSubMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable toKey = (Comparable)it.next();
        Comparable third = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        Comparable thirdValue = (Comparable)sm.get((Object)third);
        SortedMap sub = sm.subMap((Object)fromKey, (Object)toKey);
        Assertions.assertEquals((int)2, (int)sub.size());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)fromKey));
        Assertions.assertTrue((boolean)sub.containsKey(fromKey));
        Assertions.assertTrue((boolean)sm.containsValue((Object)fromKeyValue));
        Assertions.assertTrue((boolean)sub.containsValue(fromKeyValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Assertions.assertTrue((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertTrue((boolean)sub.containsValue(secondValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)third));
        Assertions.assertFalse((boolean)sub.containsKey(third));
        Assertions.assertTrue((boolean)sm.containsValue((Object)thirdValue));
        Assertions.assertFalse((boolean)sub.containsValue(thirdValue));
    }

    @Test
    public void testBidiTailMapContains() {
        SortedBidiMap<K, V> sm = this.makeFullMap();
        Iterator it = sm.keySet().iterator();
        Comparable first = (Comparable)it.next();
        Comparable fromKey = (Comparable)it.next();
        Comparable second = (Comparable)it.next();
        Comparable firstValue = (Comparable)sm.get((Object)first);
        Comparable fromKeyValue = (Comparable)sm.get((Object)fromKey);
        Comparable secondValue = (Comparable)sm.get((Object)second);
        SortedMap sub = sm.tailMap((Object)fromKey);
        Assertions.assertEquals((int)(sm.size() - 1), (int)sub.size());
        Assertions.assertTrue((boolean)sm.containsKey((Object)first));
        Assertions.assertFalse((boolean)sub.containsKey(first));
        Assertions.assertTrue((boolean)sm.containsValue((Object)firstValue));
        Assertions.assertFalse((boolean)sub.containsValue(firstValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)fromKey));
        Assertions.assertTrue((boolean)sub.containsKey(fromKey));
        Assertions.assertTrue((boolean)sm.containsValue((Object)fromKeyValue));
        Assertions.assertTrue((boolean)sub.containsValue(fromKeyValue));
        Assertions.assertTrue((boolean)sm.containsKey((Object)second));
        Assertions.assertTrue((boolean)sub.containsKey(second));
        Assertions.assertTrue((boolean)sm.containsValue((Object)secondValue));
        Assertions.assertTrue((boolean)sub.containsValue(secondValue));
    }
}

