/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.bag.AbstractSortedBagTest;
import org.apache.commons.collections4.bag.TransformedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformedSortedBagTest<T>
extends AbstractSortedBagTest<T> {
    public TransformedSortedBagTest() {
        super(TransformedSortedBagTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public SortedBag<T> makeObject() {
        return TransformedSortedBag.transformingSortedBag((SortedBag)new TreeBag(), TransformedCollectionTest.NOOP_TRANSFORMER);
    }

    @Test
    public void testTransformedBag() {
        TransformedSortedBag bag = TransformedSortedBag.transformingSortedBag((SortedBag)new TreeBag(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)0, (int)bag.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            Assertions.assertEquals((int)(i + 1), (int)bag.size());
            Assertions.assertTrue((boolean)bag.contains((Object)Integer.valueOf((String)els[i])));
        }
        Assertions.assertTrue((boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }

    @Test
    public void testTransformedBag_decorateTransform() {
        Object[] els;
        TreeBag originalBag = new TreeBag();
        for (Object el : els = new Object[]{"1", "3", "5", "7", "2", "4", "6"}) {
            originalBag.add(el);
        }
        TransformedSortedBag bag = TransformedSortedBag.transformedSortedBag((SortedBag)originalBag, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)els.length, (int)bag.size());
        for (Object el : els) {
            Assertions.assertTrue((boolean)bag.contains((Object)Integer.valueOf((String)el)));
        }
        Assertions.assertTrue((boolean)bag.remove((Object)Integer.valueOf((String)els[0])));
    }
}

