/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.IterableSortedMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.MultiMap;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.collections4.map.PredicatedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class MapUtilsTest {
    private static final String THREE = "Three";
    private static final String TWO = "Two";

    private char getDecimalSeparator() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            return ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
        }
        return '.';
    }

    public Predicate<Object> getPredicate() {
        return String.class::isInstance;
    }

    @Test
    public void testConvertResourceBundle() {
        final HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        ListResourceBundle b = new ListResourceBundle(){

            @Override
            public Object[][] getContents() {
                Object[][] contents = new Object[in.size()][2];
                int n = 0;
                for (Object key : in.keySet()) {
                    Object val = in.get(key);
                    contents[n][0] = key;
                    contents[n][1] = val;
                    ++n;
                }
                return contents;
            }
        };
        Map out = MapUtils.toMap((ResourceBundle)b);
        Assertions.assertEquals(in, (Object)out);
    }

    @Test
    public void testDebugAndVerbosePrintCasting() {
        HashMap<Integer, String> inner = new HashMap<Integer, String>(2, 1.0f);
        inner.put(2, "B");
        inner.put(3, "C");
        HashMap<Integer, Object> outer = new HashMap<Integer, Object>(2, 1.0f);
        outer.put(0, inner);
        outer.put(1, "A");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        try {
            MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        }
        catch (ClassCastException e) {
            Assertions.fail((String)"No Casting should be occurring!");
        }
    }

    @Test
    public void testDebugAndVerbosePrintNullMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        outPrint.println("Print Map = " + String.valueOf(null));
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", null);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", null);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = C " + String.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("    7 = (this Map) " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", outer);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A " + String.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map) " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("    } " + HashMap.class.getName());
        outPrint.println("} " + HashMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B " + String.class.getName());
        outPrint.println("    3 = C " + String.class.getName());
        outPrint.println("    4 = null");
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, null, null);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testDebugPrintNullStream() {
        Assertions.assertThrows(NullPointerException.class, () -> MapUtils.debugPrint(null, (Object)"Map", new HashMap()), (String)"Should generate NullPointerException");
    }

    @Test
    public void testDebugPrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A " + String.class.getName());
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B " + String.class.getName());
        outPrint.println("        3 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C " + String.class.getName());
        outPrint.println("            6 = (ancestor[1] Map) " + TreeMap.class.getName());
        outPrint.println("            7 = (ancestor[0] Map) " + TreeMap.class.getName());
        outPrint.println("        } " + TreeMap.class.getName());
        outPrint.println("    } " + TreeMap.class.getName());
        outPrint.println("} " + TreeMap.class.getName());
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.debugPrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testEmptyIfNull() {
        Assertions.assertTrue((boolean)MapUtils.emptyIfNull(null).isEmpty());
        HashMap map = new HashMap();
        Assertions.assertSame(map, (Object)MapUtils.emptyIfNull(map));
    }

    @Test
    public void testFixedSizeMap() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> MapUtils.fixedSizeMap(new HashMap()).put(new Object(), new Object()));
    }

    @Test
    public void testFixedSizeSortedMap() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> MapUtils.fixedSizeSortedMap(new TreeMap()).put(1L, 1L));
    }

    @Test
    public void testGetBooleanValue() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("key", true);
        in.put("keyNumberTrue", 1);
        in.put("keyNumberFalse", 0);
        in.put("keyUnmapped", new Object());
        Assertions.assertFalse((boolean)MapUtils.getBooleanValue(null, (Object)"keyString", null));
        Assertions.assertFalse((boolean)MapUtils.getBooleanValue(in, null, null));
        Assertions.assertFalse((boolean)MapUtils.getBooleanValue(null, null, null));
        Assertions.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"key", (boolean)true));
        Assertions.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"key"));
        Assertions.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"noKey", (boolean)true));
        Assertions.assertTrue((boolean)MapUtils.getBooleanValue(in, (Object)"noKey", key -> true));
        Assertions.assertFalse((boolean)MapUtils.getBooleanValue(in, (Object)"noKey"));
        Assertions.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"key", (Boolean)true));
        Assertions.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"noKey", (Boolean)true));
        Assertions.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"noKey", key -> {
            if (System.currentTimeMillis() > 0L) {
                return true;
            }
            return false;
        }));
        Assertions.assertNull((Object)MapUtils.getBoolean(in, (Object)"noKey", key -> null));
        Assertions.assertFalse((boolean)MapUtils.getBooleanValue(in, (Object)"noKey", key -> null));
        Assertions.assertNull((Object)MapUtils.getBoolean(null, (Object)"noKey"));
        Assertions.assertFalse((boolean)MapUtils.getBoolean(in, (Object)"keyNumberFalse"));
        Assertions.assertTrue((boolean)MapUtils.getBoolean(in, (Object)"keyNumberTrue"));
        Assertions.assertNull((Object)MapUtils.getBoolean(in, (Object)"keyString"));
        Assertions.assertNull((Object)MapUtils.getBoolean(null, (Object)"keyString"));
        Assertions.assertNull((Object)MapUtils.getBoolean(in, null));
        Assertions.assertNull((Object)MapUtils.getBoolean(null, null));
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "true");
        Assertions.assertTrue((boolean)MapUtils.getBooleanValue(inStr, (Object)"str1", (boolean)true));
        Assertions.assertTrue((boolean)MapUtils.getBoolean(inStr, (Object)"str1", (Boolean)true));
    }

    @Test
    public void testGetByteValue() {
        HashMap<String, Byte> in = new HashMap<String, Byte>();
        int val = 100;
        in.put("key", (byte)100);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"key", (byte)100), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"key"), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"noKey", (byte)100), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByteValue(in, (Object)"noKey", key -> (byte)100), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getByteValue(in, (Object)"noKey"), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByte(in, (Object)"key", (Byte)100).byteValue(), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByte(in, (Object)"noKey", (Byte)100).byteValue(), (float)0.0f);
        Assertions.assertEquals((float)100.0f, (float)MapUtils.getByte(in, (Object)"noKey", key -> (byte)100).byteValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "100");
        Assertions.assertEquals((float)MapUtils.getByteValue(inStr, (Object)"str1", (byte)100), (float)100.0f, (float)0.0f);
    }

    @Test
    public void testGetDoubleValue() {
        HashMap<String, Double> in = new HashMap<String, Double>();
        in.put("key", 2.0);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getDoubleValue(in, (Object)"key", (double)0.0), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getDoubleValue(in, (Object)"key"), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getDoubleValue(in, (Object)"noKey", (double)1.0), (double)0.0);
        Assertions.assertEquals((double)5.0, (double)MapUtils.getDoubleValue(in, (Object)"noKey", key -> 5.0), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)MapUtils.getDoubleValue(in, (Object)"noKey"), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getDouble(in, (Object)"key", (Double)0.0), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getDouble(in, (Object)"noKey", (Double)1.0), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getDouble(in, (Object)"noKey", key -> 1.0), (double)0.0);
        HashMap<String, String> inStr = new HashMap<String, String>();
        char decimalSeparator = this.getDecimalSeparator();
        inStr.put("str1", "2" + decimalSeparator + "0");
        Assertions.assertEquals((double)MapUtils.getDoubleValue(inStr, (Object)"str1", (double)0.0), (double)2.0, (double)0.0);
    }

    @Test
    public void testGetFloatValue() {
        HashMap<String, Float> in = new HashMap<String, Float>();
        in.put("key", Float.valueOf(2.0f));
        Assertions.assertEquals((double)2.0, (double)MapUtils.getFloatValue(in, (Object)"key", (float)0.0f), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getFloatValue(in, (Object)"key"), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getFloatValue(in, (Object)"noKey", (float)1.0f), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getFloatValue(in, (Object)"noKey", key -> Float.valueOf(1.0f)), (double)0.0);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getFloatValue(in, (Object)"noKey"), (float)0.0f);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getFloat(in, (Object)"key", (Float)Float.valueOf(0.0f)).floatValue(), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getFloat(in, (Object)"noKey", (Float)Float.valueOf(1.0f)).floatValue(), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)MapUtils.getFloat(in, (Object)"noKey", key -> Float.valueOf(1.0f)).floatValue(), (double)0.0);
        HashMap<String, String> inStr = new HashMap<String, String>();
        char decimalSeparator = this.getDecimalSeparator();
        inStr.put("str1", "2" + decimalSeparator + "0");
        Assertions.assertEquals((double)MapUtils.getFloatValue(inStr, (Object)"str1", (float)0.0f), (double)2.0, (double)0.0);
    }

    @Test
    public void testGetIntValue() {
        HashMap<String, Integer> in = new HashMap<String, Integer>();
        in.put("key", 2);
        Assertions.assertEquals((float)2.0f, (float)MapUtils.getIntValue(in, (Object)"key", (int)0), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)MapUtils.getIntValue(in, (Object)"key"), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getIntValue(in, (Object)"noKey", (int)0), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getIntValue(in, (Object)"noKey", key -> 0), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getIntValue(in, (Object)"noKey"), (float)0.0f);
        Assertions.assertEquals((float)2.0f, (float)MapUtils.getInteger(in, (Object)"key", (Integer)0).intValue(), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getInteger(in, (Object)"noKey", (Integer)0).intValue(), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getInteger(in, (Object)"noKey", key -> 0).intValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "2");
        Assertions.assertEquals((float)MapUtils.getIntValue(inStr, (Object)"str1", (int)0), (float)2.0f, (float)0.0f);
    }

    @Test
    public void testGetLongValue() {
        HashMap<String, Long> in = new HashMap<String, Long>();
        in.put("key", 2L);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getLongValue(in, (Object)"key", (long)0L), (double)0.0);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getLongValue(in, (Object)"key"), (double)0.0);
        Assertions.assertEquals((float)1.0f, (float)MapUtils.getLongValue(in, (Object)"noKey", (long)1L), (float)0.0f);
        Assertions.assertEquals((float)1.0f, (float)MapUtils.getLongValue(in, (Object)"noKey", key -> 1L), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getLongValue(in, (Object)"noKey"), (float)0.0f);
        Assertions.assertEquals((double)2.0, (double)MapUtils.getLong(in, (Object)"key", (Long)0L).longValue(), (double)0.0);
        Assertions.assertEquals((float)1.0f, (float)MapUtils.getLong(in, (Object)"noKey", (Long)1L).longValue(), (float)0.0f);
        Assertions.assertEquals((float)1.0f, (float)MapUtils.getLong(in, (Object)"noKey", key -> 1L).longValue(), (float)0.0f);
        HashMap<String, Integer> in1 = new HashMap<String, Integer>();
        in1.put("key", 2);
        Assertions.assertEquals((Long)2L, (Long)MapUtils.getLong(in1, (Object)"key"));
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "2");
        Assertions.assertEquals((float)MapUtils.getLongValue(inStr, (Object)"str1", (long)0L), (float)2.0f, (float)0.0f);
        Assertions.assertEquals((float)MapUtils.getLong(inStr, (Object)"str1", (Long)1L).longValue(), (float)2.0f, (float)0.0f);
    }

    @Test
    public void testGetMap() {
        HashMap in = new HashMap();
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("key1", "value1");
        in.put("key1", valMap);
        Map outValue = MapUtils.getMap(in, (Object)"key1", (Map)null);
        Assertions.assertEquals((Object)"value1", outValue.get("key1"));
        Assertions.assertNull(outValue.get("key2"));
        Assertions.assertNull((Object)MapUtils.getMap(in, (Object)"key2", (Map)null));
        Assertions.assertNull((Object)MapUtils.getMap(null, (Object)"key2", (Map)null));
    }

    @Test
    public void testGetNumber() {
        HashMap<String, Integer> in = new HashMap<String, Integer>();
        Integer val = 1000;
        in.put("key", val);
        Assertions.assertEquals((float)((Number)val).intValue(), (float)MapUtils.getNumber(in, (Object)"key", (Number)val).intValue(), (float)0.0f);
        Assertions.assertEquals((float)((Number)val).intValue(), (float)MapUtils.getNumber(in, (Object)"noKey", (Number)val).intValue(), (float)0.0f);
        Assertions.assertEquals((float)((Number)val).intValue(), (float)MapUtils.getNumber(in, (Object)"noKey", key -> val).intValue(), (float)0.0f);
    }

    @Test
    public void testGetNumberValueWithInvalidString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "one");
        Assertions.assertNull((Object)MapUtils.getNumber(map, (Object)"key"));
    }

    @Test
    public void testGetObject() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key", "str");
        Assertions.assertEquals((Object)"str", (Object)MapUtils.getObject(in, (Object)"key", (Object)"default"));
        Assertions.assertEquals((Object)"str", (Object)MapUtils.getObject(in, (Object)"key"));
        Assertions.assertNull((Object)MapUtils.getObject(null, (Object)"key"));
        Assertions.assertEquals((Object)"default", (Object)MapUtils.getObject(in, (Object)"noKey", (Object)"default"));
        Assertions.assertEquals((Object)"default", (Object)MapUtils.getObject(null, (Object)"noKey", (Object)"default"));
    }

    @Test
    public void testGetShortValue() {
        HashMap<String, Short> in = new HashMap<String, Short>();
        int val = 10;
        in.put("key", (short)10);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"key", (short)10), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"key"), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"noKey", (short)10), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShortValue(in, (Object)"noKey", key -> (short)10), (float)0.0f);
        Assertions.assertEquals((float)0.0f, (float)MapUtils.getShortValue(in, (Object)"noKey"), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShort(in, (Object)"key", (Short)10).shortValue(), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShort(in, (Object)"noKey", (Short)10).shortValue(), (float)0.0f);
        Assertions.assertEquals((float)10.0f, (float)MapUtils.getShort(in, (Object)"noKey", key -> (short)10).shortValue(), (float)0.0f);
        HashMap<String, String> inStr = new HashMap<String, String>();
        inStr.put("str1", "10");
        Assertions.assertEquals((float)MapUtils.getShortValue(inStr, (Object)"str1", (short)10), (float)10.0f, (float)0.0f);
    }

    @Test
    public void testGetString() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key", "str");
        Assertions.assertEquals((Object)"str", (Object)MapUtils.getString(in, (Object)"key", (String)"default"));
        Assertions.assertEquals((Object)"str", (Object)MapUtils.getString(in, (Object)"key"));
        Assertions.assertNull((Object)MapUtils.getString(null, (Object)"key"));
        Assertions.assertEquals((Object)"default", (Object)MapUtils.getString(in, (Object)"noKey", (String)"default"));
        Assertions.assertEquals((Object)"default", (Object)MapUtils.getString(in, (Object)"noKey", key -> {
            if ("noKey".equals(key)) {
                return "default";
            }
            return "";
        }));
        Assertions.assertEquals((Object)"default", (Object)MapUtils.getString(null, (Object)"noKey", (String)"default"));
    }

    @Test
    public void testInvertEmptyMap() {
        HashMap emptyMap = new HashMap();
        Map resultMap = MapUtils.invertMap(emptyMap);
        Assertions.assertEquals(emptyMap, (Object)resultMap);
    }

    @Test
    public void testInvertMap() {
        HashMap<String, String> in = new HashMap<String, String>(5, 1.0f);
        in.put("1", "A");
        in.put("2", "B");
        in.put("3", "C");
        in.put("4", "D");
        in.put("5", "E");
        HashSet inKeySet = new HashSet(in.keySet());
        HashSet inValSet = new HashSet(in.values());
        Map out = MapUtils.invertMap(in);
        HashSet outKeySet = new HashSet(out.keySet());
        HashSet outValSet = new HashSet(out.values());
        Assertions.assertEquals(inKeySet, outValSet);
        Assertions.assertEquals(inValSet, outKeySet);
        Assertions.assertEquals((Object)"1", out.get("A"));
        Assertions.assertEquals((Object)"2", out.get("B"));
        Assertions.assertEquals((Object)"3", out.get("C"));
        Assertions.assertEquals((Object)"4", out.get("D"));
        Assertions.assertEquals((Object)"5", out.get("E"));
    }

    @Test
    public void testInvertMapNull() {
        Map nullMap = null;
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> MapUtils.invertMap((Map)nullMap));
        String actualMessage = exception.getMessage();
        Assertions.assertTrue((boolean)actualMessage.contains("map"));
    }

    @Test
    public void testIsEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        Assertions.assertTrue((boolean)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        Assertions.assertFalse((boolean)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsEmptyWithNull() {
        Map map = null;
        Assertions.assertTrue((boolean)MapUtils.isEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithEmptyMap() {
        HashMap map = new HashMap();
        Assertions.assertFalse((boolean)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithNonEmptyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item", "value");
        Assertions.assertTrue((boolean)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testIsNotEmptyWithNull() {
        Map map = null;
        Assertions.assertFalse((boolean)MapUtils.isNotEmpty(map));
    }

    @Test
    public void testIterableMap() {
        Assertions.assertThrows(NullPointerException.class, () -> MapUtils.iterableMap(null), (String)"Should throw NullPointerException");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableMap iMap = MapUtils.iterableMap(map);
        Assertions.assertEquals(map, (Object)iMap);
        Assertions.assertNotSame(map, (Object)iMap);
        HashedMap hMap = new HashedMap(map);
        Assertions.assertSame((Object)hMap, (Object)MapUtils.iterableMap((Map)hMap));
    }

    @Test
    public void testIterableSortedMap() {
        Assertions.assertThrows(NullPointerException.class, () -> MapUtils.iterableSortedMap(null), (String)"Should throw NullPointerException");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("foo", "foov");
        map.put("bar", "barv");
        map.put("baz", "bazv");
        IterableSortedMap iMap = MapUtils.iterableSortedMap(map);
        Assertions.assertEquals(map, (Object)iMap);
        Assertions.assertNotSame(map, (Object)iMap);
        Assertions.assertSame((Object)iMap, (Object)MapUtils.iterableMap((Map)iMap));
    }

    @Test
    public void testLazyMap() {
        IterableMap lazyMap = MapUtils.lazyMap(new HashMap(), () -> 1);
        lazyMap.put(TWO, 2);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)lazyMap.get(TWO)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)lazyMap.get(THREE)));
    }

    @Test
    public void testLazyMapFactory() {
        Factory factory = FactoryUtils.constantFactory((Object)5);
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Factory)factory);
        Assertions.assertTrue((boolean)(map instanceof LazyMap));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.lazyMap(new HashMap(), (Factory)null), (String)"Expecting NullPointerException for null factory"), () -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.lazyMap((Map)null, (Factory)factory), (String)"Expecting NullPointerException for null map")});
        Transformer transformer = TransformerUtils.asTransformer((Factory)factory);
        map = MapUtils.lazyMap(new HashMap(), (Transformer)transformer);
        Assertions.assertTrue((boolean)(map instanceof LazyMap));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.lazyMap(new HashMap(), (Transformer)null), (String)"Expecting NullPointerException for null transformer"), () -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.lazyMap((Map)null, (Transformer)transformer), (String)"Expecting NullPointerException for null map")});
    }

    @Test
    public void testLazyMapTransformer() {
        IterableMap map = MapUtils.lazyMap(new HashMap(), mapKey -> {
            if (mapKey instanceof String) {
                return Integer.valueOf((String)mapKey);
            }
            return null;
        });
        Assertions.assertEquals((int)0, (int)map.size());
        Integer i1 = (Integer)map.get("5");
        Assertions.assertEquals((Integer)5, (Integer)i1);
        Assertions.assertEquals((int)1, (int)map.size());
        Integer i2 = (Integer)map.get(new String(new char[]{'5'}));
        Assertions.assertEquals((Integer)5, (Integer)i2);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertSame((Object)i1, (Object)i2);
    }

    @Test
    public void testLazySortedMapFactory() {
        SortedMap lazySortedMap = MapUtils.lazySortedMap(new TreeMap(), () -> 1);
        lazySortedMap.put(TWO, 2);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)lazySortedMap.get(TWO)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)lazySortedMap.get(THREE)));
        HashSet<AbstractMap.SimpleEntry<String, Integer>> entrySet = new HashSet<AbstractMap.SimpleEntry<String, Integer>>();
        entrySet.add(new AbstractMap.SimpleEntry<String, Integer>(THREE, 1));
        entrySet.add(new AbstractMap.SimpleEntry<String, Integer>(TWO, 2));
        Assertions.assertEquals(entrySet, lazySortedMap.entrySet());
    }

    @Test
    public void testLazySortedMapTransformer() {
        SortedMap lazySortedMap = MapUtils.lazySortedMap(new TreeMap(), s -> 1);
        lazySortedMap.put(TWO, 2);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)lazySortedMap.get(TWO)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)lazySortedMap.get(THREE)));
        HashSet<AbstractMap.SimpleEntry<String, Integer>> entrySet = new HashSet<AbstractMap.SimpleEntry<String, Integer>>();
        entrySet.add(new AbstractMap.SimpleEntry<String, Integer>(THREE, 1));
        entrySet.add(new AbstractMap.SimpleEntry<String, Integer>(TWO, 2));
        Assertions.assertEquals(entrySet, lazySortedMap.entrySet());
    }

    @Test
    public void testOrderedMap() {
        HashMap<String, String> inMap = new HashMap<String, String>();
        inMap.put("key1", "value1");
        inMap.put("key2", "value2");
        OrderedMap map = MapUtils.orderedMap(inMap);
        Assertions.assertTrue((boolean)(map instanceof OrderedMap));
    }

    @Test
    public void testPopulateMap() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("3");
        list.add("5");
        list.add("7");
        list.add("2");
        list.add("4");
        list.add("6");
        HashMap map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)list.size(), (int)map.size());
        for (String element : list) {
            Assertions.assertTrue((boolean)map.containsKey(Integer.valueOf(element)));
            Assertions.assertFalse((boolean)map.containsKey(element));
            Assertions.assertTrue((boolean)map.containsValue(element));
            Assertions.assertEquals((Object)element, map.get(Integer.valueOf(element)));
        }
        map = new HashMap();
        MapUtils.populateMap(map, list, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        Assertions.assertEquals((int)list.size(), (int)map.size());
        for (String element : list) {
            Assertions.assertTrue((boolean)map.containsKey(Integer.valueOf(element)));
            Assertions.assertFalse((boolean)map.containsKey(element));
            Assertions.assertTrue((boolean)map.containsValue(Integer.valueOf(element)));
            Assertions.assertEquals((Object)Integer.valueOf(element), map.get(Integer.valueOf(element)));
        }
    }

    @Test
    public void testPopulateMultiMap() {
        ArrayList<X> list = new ArrayList<X>();
        list.add(new X(1, "x1"));
        list.add(new X(2, "x2"));
        list.add(new X(2, "x3"));
        list.add(new X(5, "x4"));
        list.add(new X(5, "x5"));
        MultiValueMap map = MultiValueMap.multiValueMap(new TreeMap());
        MapUtils.populateMap((MultiMap)map, list, input -> input.key, (Transformer)TransformerUtils.nopTransformer());
        Assertions.assertEquals((int)list.size(), (int)map.totalSize());
        for (X element : list) {
            Assertions.assertTrue((boolean)map.containsKey((Object)element.key));
            Assertions.assertTrue((boolean)map.containsValue((Object)element));
        }
    }

    @Test
    public void testPredicatedMap() {
        Predicate<Object> p = this.getPredicate();
        IterableMap map = MapUtils.predicatedMap(new HashMap(), p, p);
        Assertions.assertTrue((boolean)(map instanceof PredicatedMap));
        Assertions.assertThrows(NullPointerException.class, () -> MapUtils.predicatedMap(null, (Predicate)p, (Predicate)p), (String)"Expecting NullPointerException for null map.");
    }

    @Test
    public void testPutAll_Map_array() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.putAll(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> MapUtils.putAll(null, (Object[])new Object[0]))});
        Map test = MapUtils.putAll(new HashMap(), (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        Assertions.assertEquals((int)0, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN", "#00FF00"}, {"BLUE", "#0000FF"}});
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)"#FF0000", test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assertions.assertTrue((boolean)test.containsKey("BLUE"));
        Assertions.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IllegalArgumentException.class, () -> MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, null, {"BLUE", "#0000FF"}})), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, {"GREEN"}, {"BLUE", "#0000FF"}})), () -> Assertions.assertThrows(IllegalArgumentException.class, () -> MapUtils.putAll(new HashMap(), (Object[])new String[][]{{"RED", "#FF0000"}, new String[0], {"BLUE", "#0000FF"}}))});
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF"});
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)"#FF0000", test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assertions.assertTrue((boolean)test.containsKey("BLUE"));
        Assertions.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assertions.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new String[]{"RED", "#FF0000", "GREEN", "#00FF00", "BLUE", "#0000FF", "PURPLE"});
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)"#FF0000", test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assertions.assertTrue((boolean)test.containsKey("BLUE"));
        Assertions.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assertions.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), null);
        Assertions.assertEquals((int)0, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultMapEntry((Object)"RED", (Object)"#FF0000"), new DefaultMapEntry((Object)"GREEN", (Object)"#00FF00"), new DefaultMapEntry((Object)"BLUE", (Object)"#0000FF")});
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)"#FF0000", test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assertions.assertTrue((boolean)test.containsKey("BLUE"));
        Assertions.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assertions.assertEquals((int)3, (int)test.size());
        test = MapUtils.putAll(new HashMap(), (Object[])new Object[]{new DefaultKeyValue((Object)"RED", (Object)"#FF0000"), new DefaultKeyValue((Object)"GREEN", (Object)"#00FF00"), new DefaultKeyValue((Object)"BLUE", (Object)"#0000FF")});
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)"#FF0000", test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)"#00FF00", test.get("GREEN"));
        Assertions.assertTrue((boolean)test.containsKey("BLUE"));
        Assertions.assertEquals((Object)"#0000FF", test.get("BLUE"));
        Assertions.assertEquals((int)3, (int)test.size());
    }

    @Test
    public void testSafeAddToMap() {
        HashMap inMap = new HashMap();
        MapUtils.safeAddToMap(inMap, (Object)"key1", (Object)"value1");
        MapUtils.safeAddToMap(inMap, (Object)"key2", null);
        Assertions.assertEquals((Object)"value1", inMap.get("key1"));
        Assertions.assertEquals((Object)"", inMap.get("key2"));
    }

    @Test
    public void testSize() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "1");
        map.put("B", "2");
        Assertions.assertEquals((int)2, (int)MapUtils.size(map));
    }

    @Test
    public void testSize0() {
        Assertions.assertEquals((int)0, (int)MapUtils.size(new HashMap()));
    }

    @Test
    public void testSizeNull() {
        Assertions.assertEquals((int)0, (int)MapUtils.size(null));
    }

    @Test
    public void testToProperties() {
        HashMap<String, String> in = new HashMap<String, String>();
        in.put("key1", "A");
        in.put("key2", "B");
        in.put("key3", "C");
        Properties out = MapUtils.toProperties(in);
        Assertions.assertEquals(in.get("key1"), (Object)out.get("key1"));
        Assertions.assertEquals(in.get("key2"), (Object)out.get("key2"));
        Assertions.assertEquals(in.get("key3"), (Object)out.get("key3"));
    }

    @Test
    public void testToPropertiesEmpty() {
        Map in = null;
        Properties out = MapUtils.toProperties(in);
        Assertions.assertEquals((int)out.size(), (int)0);
    }

    @Test
    public void testTransformedMap() {
        HashMap map = new HashMap();
        IterableMap transformedMap = MapUtils.transformedMap(map, i -> i + 1L, i -> i + 10L);
        transformedMap.put(1L, 100L);
        HashSet<AbstractMap.SimpleEntry<Long, Long>> entrySet = new HashSet<AbstractMap.SimpleEntry<Long, Long>>();
        entrySet.add(new AbstractMap.SimpleEntry<Long, Long>(2L, 110L));
        Assertions.assertEquals(entrySet, transformedMap.entrySet());
    }

    @Test
    public void testTransformedSortedMap() {
        TreeMap sortedMap = new TreeMap();
        SortedMap transformedSortedMap = MapUtils.transformedSortedMap(sortedMap, i -> i + 1L, i -> i + 10L);
        transformedSortedMap.put(2L, 200L);
        transformedSortedMap.put(1L, 100L);
        HashSet<AbstractMap.SimpleEntry<Long, Long>> entrySet = new HashSet<AbstractMap.SimpleEntry<Long, Long>>();
        entrySet.add(new AbstractMap.SimpleEntry<Long, Long>(2L, 110L));
        entrySet.add(new AbstractMap.SimpleEntry<Long, Long>(3L, 210L));
        Assertions.assertEquals(entrySet, transformedSortedMap.entrySet());
    }

    @Test
    public void testUnmodifiableMap() {
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> MapUtils.unmodifiableMap(new HashMap()).clear());
    }

    @Test
    public void testUnmodifiableSortedMap() {
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> MapUtils.unmodifiableSortedMap(new TreeMap()).clear());
    }

    @Test
    public void testVerbosePrint() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = C");
        outPrint.println("    }");
        outPrint.println("    7 = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        TreeMap<Integer, String> inner = new TreeMap<Integer, String>();
        inner.put(2, "B");
        inner.put(3, "C");
        TreeMap<Integer, Object> outer = new TreeMap<Integer, Object>();
        outer.put(1, inner);
        outer.put(0, "A");
        outer.put(7, outer);
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", outer);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKey() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "A");
        outPrint.println("{");
        outPrint.println("    null = A");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKeyToMap1() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        map.put(null, map);
        outPrint.println("{");
        outPrint.println("    null = (this Map)");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullKeyToMap2() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        HashMap map = new HashMap();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.put(null, map2);
        map2.put("2", "B");
        outPrint.println("{");
        outPrint.println("    null = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullLabel() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String INDENT = "    ";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(2, "B");
        map.put(3, "C");
        map.put(4, null);
        outPrint.println("{");
        outPrint.println("    2 = B");
        outPrint.println("    3 = C");
        outPrint.println("    4 = null");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, map);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullLabelAndMap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        outPrint.println("null");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, null, null);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    @Test
    public void testVerbosePrintNullStream() {
        Assertions.assertThrows(NullPointerException.class, () -> MapUtils.verbosePrint(null, (Object)"Map", new HashMap()), (String)"Should generate NullPointerException");
    }

    @Test
    public void testVerbosePrintSelfReference() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(out);
        String LABEL = "Print Map";
        String INDENT = "    ";
        TreeMap<Integer, Object> grandfather = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> father = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> son = new TreeMap<Integer, Object>();
        grandfather.put(0, "A");
        grandfather.put(1, father);
        father.put(2, "B");
        father.put(3, grandfather);
        father.put(4, son);
        son.put(5, "C");
        son.put(6, grandfather);
        son.put(7, father);
        outPrint.println("Print Map = ");
        outPrint.println("{");
        outPrint.println("    0 = A");
        outPrint.println("    1 = ");
        outPrint.println("    {");
        outPrint.println("        2 = B");
        outPrint.println("        3 = (ancestor[0] Map)");
        outPrint.println("        4 = ");
        outPrint.println("        {");
        outPrint.println("            5 = C");
        outPrint.println("            6 = (ancestor[1] Map)");
        outPrint.println("            7 = (ancestor[0] Map)");
        outPrint.println("        }");
        outPrint.println("    }");
        outPrint.println("}");
        String EXPECTED_OUT = out.toString();
        out.reset();
        MapUtils.verbosePrint((PrintStream)outPrint, (Object)"Print Map", grandfather);
        Assertions.assertEquals((Object)EXPECTED_OUT, (Object)out.toString());
    }

    static class X
    implements Comparable<X> {
        int key;
        String name;

        X(int key, String name) {
            this.key = key;
            this.name = name;
        }

        @Override
        public int compareTo(X o) {
            return this.key - o.key | this.name.compareTo(o.name);
        }
    }
}

