/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.ClosureUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.MockTestCase;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.collection.PredicatedCollection;
import org.apache.commons.collections4.collection.SynchronizedCollection;
import org.apache.commons.collections4.collection.TransformedCollection;
import org.apache.commons.collections4.collection.UnmodifiableCollection;
import org.apache.commons.collections4.functors.DefaultEquator;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CollectionUtilsTest
extends MockTestCase {
    private static final Predicate<Number> EQUALS_TWO = input -> input.intValue() == 2;
    private List<Integer> collectionA;
    private List<Long> collectionB;
    private Collection<Integer> collectionC;
    private Collection<Integer> collectionD;
    private Collection<Integer> collectionE;
    private Collection<Number> collectionA2;
    private Collection<Number> collectionB2;
    private Collection<Number> collectionC2;
    private Iterable<Integer> iterableA;
    private Iterable<Long> iterableB;
    private Iterable<Integer> iterableC;
    private Iterable<Number> iterableA2;
    private Iterable<Number> iterableB2;
    private final Collection<Integer> emptyCollection = new ArrayList<Integer>(1);
    Transformer<Object, Integer> TRANSFORM_TO_INTEGER = input -> ((Long)input).intValue();

    private void assertCollectResult(Collection<Number> collection) {
        Assertions.assertTrue((this.collectionA.contains(1) && !this.collectionA.contains(2L) ? 1 : 0) != 0);
        Assertions.assertTrue((collection.contains(2L) && !collection.contains(1) ? 1 : 0) != 0);
    }

    @Test
    @Deprecated
    public void cardinality() {
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)1, this.iterableA));
        Assertions.assertEquals((int)2, (int)CollectionUtils.cardinality((Object)2, this.iterableA));
        Assertions.assertEquals((int)3, (int)CollectionUtils.cardinality((Object)3, this.iterableA));
        Assertions.assertEquals((int)4, (int)CollectionUtils.cardinality((Object)4, this.iterableA));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)5, this.iterableA));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)1L, this.iterableB));
        Assertions.assertEquals((int)4, (int)CollectionUtils.cardinality((Object)2L, this.iterableB));
        Assertions.assertEquals((int)3, (int)CollectionUtils.cardinality((Object)3L, this.iterableB));
        Assertions.assertEquals((int)2, (int)CollectionUtils.cardinality((Object)4L, this.iterableB));
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)5L, this.iterableB));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)2L, this.iterableA2));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)2, this.iterableB2));
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("C");
        set.add("E");
        set.add("E");
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)"A", set));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)"B", set));
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)"C", set));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)"D", set));
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)"E", set));
        HashBag bag = new HashBag();
        bag.add((Object)"A", 3);
        bag.add((Object)"C");
        bag.add((Object)"E");
        bag.add((Object)"E");
        Assertions.assertEquals((int)3, (int)CollectionUtils.cardinality((Object)"A", (Iterable)bag));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)"B", (Iterable)bag));
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality((Object)"C", (Iterable)bag));
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality((Object)"D", (Iterable)bag));
        Assertions.assertEquals((int)2, (int)CollectionUtils.cardinality((Object)"E", (Iterable)bag));
    }

    @Test
    @Deprecated
    public void cardinalityOfNull() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality(null, list));
        Map freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertNull(freq.get(null));
        list.add("A");
        Assertions.assertEquals((int)0, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertNull(freq.get(null));
        list.add(null);
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(null)));
        list.add("B");
        Assertions.assertEquals((int)1, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(null)));
        list.add(null);
        Assertions.assertEquals((int)2, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(null)));
        list.add("B");
        Assertions.assertEquals((int)2, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(null)));
        list.add(null);
        Assertions.assertEquals((int)3, (int)CollectionUtils.cardinality(null, list));
        freq = CollectionUtils.getCardinalityMap(list);
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq.get(null)));
    }

    @Test
    @Deprecated
    public void countMatches() {
        Assertions.assertEquals((int)4, (int)CollectionUtils.countMatches(this.iterableB, EQUALS_TWO));
        Assertions.assertEquals((int)0, (int)CollectionUtils.countMatches(this.iterableA, null));
        Assertions.assertEquals((int)0, (int)CollectionUtils.countMatches(null, EQUALS_TWO));
        Assertions.assertEquals((int)0, (int)CollectionUtils.countMatches(null, null));
    }

    @Test
    @Deprecated
    public void exists() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Assertions.assertFalse((boolean)CollectionUtils.exists(null, null));
        Assertions.assertFalse((boolean)CollectionUtils.exists(list, null));
        Assertions.assertFalse((boolean)CollectionUtils.exists(null, EQUALS_TWO));
        Assertions.assertFalse((boolean)CollectionUtils.exists(list, EQUALS_TWO));
        list.add(1);
        list.add(3);
        list.add(4);
        Assertions.assertFalse((boolean)CollectionUtils.exists(list, EQUALS_TWO));
        list.add(2);
        Assertions.assertTrue((boolean)CollectionUtils.exists(list, EQUALS_TWO));
    }

    @Test
    @Deprecated
    public void find() {
        Predicate testPredicate = EqualPredicate.equalPredicate((Object)4);
        Integer test = (Integer)CollectionUtils.find(this.collectionA, (Predicate)testPredicate);
        Assertions.assertEquals((int)4, (int)test);
        testPredicate = EqualPredicate.equalPredicate((Object)45);
        test = (Integer)CollectionUtils.find(this.collectionA, (Predicate)testPredicate);
        Assertions.assertNull((Object)test);
        Assertions.assertNull((Object)CollectionUtils.find(null, (Predicate)testPredicate));
        Assertions.assertNull((Object)CollectionUtils.find(this.collectionA, null));
    }

    @Test
    @Deprecated
    public void forAllButLastDoCollection() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<List<Number>> col = new ArrayList<List<Number>>();
        col.add(this.collectionA);
        col.add(this.collectionB);
        List lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assertions.assertSame((Object)lastElement, this.collectionB);
        Assertions.assertTrue((this.collectionA.isEmpty() && !this.collectionB.isEmpty() ? 1 : 0) != 0);
        col.clear();
        col.add(this.collectionB);
        lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assertions.assertSame((Object)lastElement, this.collectionB);
        Assertions.assertFalse((boolean)this.collectionB.isEmpty());
        col.clear();
        lastElement = (List)CollectionUtils.forAllButLastDo(col, (Closure)testClosure);
        Assertions.assertNull((Object)lastElement);
        List<String> strings = Arrays.asList("a", "b", "c");
        StringBuilder result = new StringBuilder();
        result.append((String)CollectionUtils.forAllButLastDo(strings, input -> result.append(input + ";")));
        Assertions.assertEquals((Object)"a;b;c", (Object)result.toString());
        List<String> oneString = Arrays.asList("a");
        StringBuilder resultOne = new StringBuilder();
        resultOne.append((String)CollectionUtils.forAllButLastDo(oneString, input -> resultOne.append(input + ";")));
        Assertions.assertEquals((Object)"a", (Object)resultOne.toString());
        Assertions.assertNull((Object)CollectionUtils.forAllButLastDo(strings, (Closure)null));
        Assertions.assertNull((Object)CollectionUtils.forAllButLastDo((Iterable)null, (Closure)null));
    }

    @Test
    @Deprecated
    public void forAllButLastDoIterator() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<List<Number>> col = new ArrayList<List<Number>>();
        col.add(this.collectionA);
        col.add(this.collectionB);
        List lastElement = (List)CollectionUtils.forAllButLastDo(col.iterator(), (Closure)testClosure);
        Assertions.assertSame((Object)lastElement, this.collectionB);
        Assertions.assertTrue((this.collectionA.isEmpty() && !this.collectionB.isEmpty() ? 1 : 0) != 0);
        Assertions.assertNull((Object)CollectionUtils.forAllButLastDo(col.iterator(), (Closure)null));
        Assertions.assertNull((Object)CollectionUtils.forAllButLastDo((Iterator)null, (Closure)null));
    }

    @Test
    @Deprecated
    public void forAllDoCollection() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<Collection<Integer>> col = new ArrayList<Collection<Integer>>();
        col.add(this.collectionA);
        col.add(this.collectionC);
        Closure resultClosure = CollectionUtils.forAllDo(col, (Closure)testClosure);
        Assertions.assertSame((Object)testClosure, (Object)resultClosure);
        Assertions.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo(col, (Closure)null);
        Assertions.assertNull((Object)resultClosure);
        Assertions.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo((Iterable)null, (Closure)testClosure);
        col.add(null);
        CollectionUtils.forAllDo(col, (Closure)testClosure);
    }

    @Test
    @Deprecated
    public void forAllDoFailure() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<String> col = new ArrayList<String>();
        col.add("x");
        Assertions.assertThrows(FunctorException.class, () -> CollectionUtils.forAllDo((Iterable)col, (Closure)testClosure));
    }

    @Test
    @Deprecated
    public void forAllDoIterator() {
        Closure testClosure = ClosureUtils.invokerClosure((String)"clear");
        ArrayList<Collection<Integer>> col = new ArrayList<Collection<Integer>>();
        col.add(this.collectionA);
        col.add(this.collectionC);
        Closure resultClosure = CollectionUtils.forAllDo(col.iterator(), (Closure)testClosure);
        Assertions.assertSame((Object)testClosure, (Object)resultClosure);
        Assertions.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo(col.iterator(), (Closure)null);
        Assertions.assertNull((Object)resultClosure);
        Assertions.assertTrue((this.collectionA.isEmpty() && this.collectionC.isEmpty() ? 1 : 0) != 0);
        resultClosure = CollectionUtils.forAllDo((Iterator)null, (Closure)testClosure);
        col.add(null);
        CollectionUtils.forAllDo(col.iterator(), (Closure)testClosure);
    }

    @Test
    @Deprecated
    public void getFromEnumeration() throws Exception {
        Vector<String> vector = new Vector<String>();
        vector.addElement("zero");
        vector.addElement("one");
        Enumeration en = vector.elements();
        Assertions.assertEquals((Object)"zero", (Object)CollectionUtils.get(en, (int)0));
        en = vector.elements();
        Assertions.assertEquals((Object)"one", (Object)CollectionUtils.get(en, (int)1));
        Enumeration finalEn = en;
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Object)finalEn, (int)3), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertFalse((boolean)en.hasMoreElements());
    }

    @Test
    @Deprecated
    public void getFromIterable() throws Exception {
        HashBag bag = new HashBag();
        bag.add((Object)"element", 1);
        Assertions.assertEquals((Object)"element", (Object)CollectionUtils.get((Iterable)bag, (int)0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtilsTest.lambda$getFromIterable$6((Bag)bag));
    }

    @Test
    @Deprecated
    public void getFromIterator() throws Exception {
        Iterator<Integer> iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)1, (int)((Integer)CollectionUtils.get(iterator, (int)0)));
        iterator = this.iterableA.iterator();
        Assertions.assertEquals((int)2, (int)((Integer)CollectionUtils.get(iterator, (int)1)));
        Iterator<Integer> finalIterator = iterator;
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Iterator)finalIterator, (int)10), (String)"Expecting IndexOutOfBoundsException.");
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private <T> void next(Iterator<T> iterator, T t) {
        this.expect(iterator.hasNext()).andReturn((Object)true);
        this.expect(iterator.next()).andReturn(t);
    }

    @BeforeEach
    public void setUp() {
        this.collectionA = new ArrayList<Integer>();
        this.collectionA.add(1);
        this.collectionA.add(2);
        this.collectionA.add(2);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(3);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionA.add(4);
        this.collectionB = new LinkedList<Long>();
        this.collectionB.add(5L);
        this.collectionB.add(4L);
        this.collectionB.add(4L);
        this.collectionB.add(3L);
        this.collectionB.add(3L);
        this.collectionB.add(3L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionB.add(2L);
        this.collectionC = new ArrayList<Integer>();
        for (Long l : this.collectionB) {
            this.collectionC.add(l.intValue());
        }
        this.iterableA = this.collectionA;
        this.iterableB = this.collectionB;
        this.iterableC = this.collectionC;
        this.collectionA2 = new ArrayList<Integer>(this.collectionA);
        this.collectionB2 = new LinkedList<Long>(this.collectionB);
        this.collectionC2 = new LinkedList<Integer>(this.collectionC);
        this.iterableA2 = this.collectionA2;
        this.iterableB2 = this.collectionB2;
        this.collectionD = new ArrayList<Integer>();
        this.collectionD.add(1);
        this.collectionD.add(3);
        this.collectionD.add(3);
        this.collectionD.add(3);
        this.collectionD.add(5);
        this.collectionD.add(7);
        this.collectionD.add(7);
        this.collectionD.add(10);
        this.collectionE = new ArrayList<Integer>();
        this.collectionE.add(2);
        this.collectionE.add(4);
        this.collectionE.add(4);
        this.collectionE.add(5);
        this.collectionE.add(6);
        this.collectionE.add(6);
        this.collectionE.add(9);
    }

    @Test
    public void testAddAllForElements() {
        CollectionUtils.addAll(this.collectionA, (Object[])new Integer[]{5});
        Assertions.assertTrue((boolean)this.collectionA.contains(5));
    }

    @Test
    public void testAddAllForEnumeration() {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        h.put(5, 5);
        Enumeration enumeration = h.keys();
        CollectionUtils.addAll(this.collectionA, enumeration);
        Assertions.assertTrue((boolean)this.collectionA.contains(5));
    }

    @Test
    public void testAddAllForIterable() {
        Collection inputCollection;
        Collection inputIterable = inputCollection = (Collection)this.createMock(Collection.class);
        Iterable iterable = (Iterable)this.createMock(Iterable.class);
        Iterator iterator = (Iterator)this.createMock(Iterator.class);
        Collection c = (Collection)this.createMock(Collection.class);
        this.expect(iterable.iterator()).andReturn((Object)iterator);
        this.next(iterator, 1L);
        this.next(iterator, 2L);
        this.next(iterator, 3L);
        this.expect(iterator.hasNext()).andReturn((Object)false);
        this.expect(c.add(1L)).andReturn((Object)true);
        this.expect(c.add(2L)).andReturn((Object)true);
        this.expect(c.add(3L)).andReturn((Object)true);
        this.expect(c.addAll(inputCollection)).andReturn((Object)true);
        this.expect(iterable.iterator()).andReturn((Object)iterator);
        this.next(iterator, 1L);
        this.expect(iterator.hasNext()).andReturn((Object)false);
        this.expect(c.add(1L)).andReturn((Object)false);
        this.expect(c.addAll(inputCollection)).andReturn((Object)false);
        this.replay();
        Assertions.assertTrue((boolean)CollectionUtils.addAll((Collection)c, (Iterable)iterable));
        Assertions.assertTrue((boolean)CollectionUtils.addAll((Collection)c, (Iterable)inputIterable));
        Assertions.assertFalse((boolean)CollectionUtils.addAll((Collection)c, (Iterable)iterable));
        Assertions.assertFalse((boolean)CollectionUtils.addAll((Collection)c, (Iterable)inputIterable));
        this.verify();
    }

    @Test
    public void testaddAllNullColl1() {
        ArrayList list = new ArrayList();
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addAll(null, (Iterable)list));
    }

    @Test
    public void testAddAllNullColl2() {
        ArrayList list = new ArrayList();
        Iterable list2 = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addAll((Collection)list, (Iterable)list2));
    }

    @Test
    public void testAddAllNullColl3() {
        ArrayList list = new ArrayList();
        Iterator list2 = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addAll((Collection)list, (Iterator)list2));
    }

    @Test
    public void testAddAllNullColl4() {
        ArrayList list = new ArrayList();
        Enumeration enumArray = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addAll((Collection)list, (Enumeration)enumArray));
    }

    @Test
    public void testAddAllNullColl5() {
        ArrayList list = new ArrayList();
        Integer[] array = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addAll((Collection)list, (Object[])array));
    }

    @Test
    public void testAddIgnoreNull() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        Assertions.assertFalse((boolean)CollectionUtils.addIgnoreNull(set, null));
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertFalse((boolean)CollectionUtils.addIgnoreNull(set, (Object)"1"));
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertTrue((boolean)CollectionUtils.addIgnoreNull(set, (Object)"4"));
        Assertions.assertEquals((int)4, (int)set.size());
        Assertions.assertTrue((boolean)set.contains("4"));
    }

    @Test
    public void testAddIgnoreNullNullColl() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.addIgnoreNull(null, (Object)"1"));
    }

    @Test
    public void testCollate() {
        List result = CollectionUtils.collate(this.emptyCollection, this.emptyCollection);
        Assertions.assertEquals((int)0, (int)result.size(), (String)"Merge empty with empty");
        result = CollectionUtils.collate(this.collectionA, this.emptyCollection);
        Assertions.assertEquals(this.collectionA, (Object)result, (String)"Merge empty with non-empty");
        List result1 = CollectionUtils.collate(this.collectionD, this.collectionE);
        List result2 = CollectionUtils.collate(this.collectionE, this.collectionD);
        Assertions.assertEquals((Object)result1, (Object)result2, (String)"Merge two lists 1");
        ArrayList<Integer> combinedList = new ArrayList<Integer>(this.collectionD);
        combinedList.addAll(this.collectionE);
        combinedList.sort(null);
        Assertions.assertEquals(combinedList, (Object)result2, (String)"Merge two lists 2");
        Comparator reverseComparator = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        result = CollectionUtils.collate(this.emptyCollection, this.emptyCollection, (Comparator)reverseComparator);
        Assertions.assertEquals((int)0, (int)result.size(), (String)"Comparator Merge empty with empty");
        Collections.reverse((List)this.collectionD);
        Collections.reverse((List)this.collectionE);
        Collections.reverse(combinedList);
        result1 = CollectionUtils.collate(this.collectionD, this.collectionE, (Comparator)reverseComparator);
        result2 = CollectionUtils.collate(this.collectionE, this.collectionD, (Comparator)reverseComparator);
        Assertions.assertEquals((Object)result1, (Object)result2, (String)"Comparator Merge two lists 1");
        Assertions.assertEquals(combinedList, (Object)result2, (String)"Comparator Merge two lists 2");
    }

    @Test
    public void testCollateException0() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.collate(null, this.collectionC));
    }

    @Test
    public void testCollateException1() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.collate(this.collectionA, null));
    }

    @Test
    public void testCollateException2() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.collate(this.collectionA, this.collectionC, null));
    }

    @Test
    public void testCollateIgnoreDuplicates() {
        List result1 = CollectionUtils.collate(this.collectionD, this.collectionE, (boolean)false);
        List result2 = CollectionUtils.collate(this.collectionE, this.collectionD, (boolean)false);
        Assertions.assertEquals((Object)result1, (Object)result2, (String)"Merge two lists 1 - ignore duplicates");
        HashSet<Integer> combinedSet = new HashSet<Integer>(this.collectionD);
        combinedSet.addAll(this.collectionE);
        ArrayList<Integer> combinedList = new ArrayList<Integer>(combinedSet);
        combinedList.sort(null);
        Assertions.assertEquals(combinedList, (Object)result2, (String)"Merge two lists 2 - ignore duplicates");
    }

    @Test
    public void testCollect() {
        Transformer transformer = TransformerUtils.constantTransformer((Object)2L);
        Collection collection = CollectionUtils.collect(this.iterableA, (Transformer)transformer);
        Assertions.assertEquals((int)collection.size(), (int)this.collectionA.size());
        this.assertCollectResult(collection);
        ArrayList list = (ArrayList)CollectionUtils.collect(this.collectionA, (Transformer)transformer, new ArrayList());
        Assertions.assertEquals((int)list.size(), (int)this.collectionA.size());
        this.assertCollectResult(list);
        Iterator<Integer> iterator = null;
        list = (ArrayList)CollectionUtils.collect(iterator, (Transformer)transformer, new ArrayList());
        iterator = this.iterableA.iterator();
        list = (ArrayList)CollectionUtils.collect(iterator, (Transformer)transformer, (Collection)list);
        Assertions.assertEquals((int)collection.size(), (int)this.collectionA.size());
        this.assertCollectResult(collection);
        iterator = this.collectionA.iterator();
        collection = CollectionUtils.collect(iterator, (Transformer)transformer);
        Assertions.assertEquals((int)collection.size(), (int)this.collectionA.size());
        Assertions.assertTrue((collection.contains(2L) && !collection.contains(1) ? 1 : 0) != 0);
        collection = CollectionUtils.collect((Iterator)null, (Transformer)null);
        Assertions.assertTrue((boolean)collection.isEmpty());
        int size = this.collectionA.size();
        this.collectionB = (List)CollectionUtils.collect((Iterable)null, (Transformer)transformer, this.collectionB);
        Assertions.assertTrue((this.collectionA.size() == size && this.collectionA.contains(1) ? 1 : 0) != 0);
        CollectionUtils.collect(this.collectionB, null, this.collectionA);
        Assertions.assertTrue((this.collectionA.size() == size && this.collectionA.contains(1) ? 1 : 0) != 0);
    }

    @Test
    public void testContainsAll() {
        ArrayList empty = new ArrayList(0);
        ArrayList<String> one = new ArrayList<String>(1);
        one.add("1");
        ArrayList<String> two = new ArrayList<String>(1);
        two.add("2");
        ArrayList<String> three = new ArrayList<String>(1);
        three.add("3");
        ArrayList<String> odds = new ArrayList<String>(2);
        odds.add("1");
        odds.add("3");
        ArrayList<String> multiples = new ArrayList<String>(3);
        multiples.add("1");
        multiples.add("3");
        multiples.add("1");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(one, odds), (String)"containsAll({1},{1,3}) should return false.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, one), (String)"containsAll({1,3},{1}) should return true.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(three, odds), (String)"containsAll({3},{1,3}) should return false.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, three), (String)"containsAll({1,3},{3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(two, two), (String)"containsAll({2},{2}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, odds), (String)"containsAll({1,3},{1,3}) should return true.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(two, odds), (String)"containsAll({2},{1,3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(odds, two), (String)"containsAll({1,3},{2}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(one, three), (String)"containsAll({1},{3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(three, one), (String)"containsAll({3},{1}) should return false.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, empty), (String)"containsAll({1,3},{}) should return true.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAll(empty, odds), (String)"containsAll({},{1,3}) should return false.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(empty, empty), (String)"containsAll({},{}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, multiples), (String)"containsAll({1,3},{1,3,1}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAll(odds, odds), (String)"containsAll({1,3,1},{1,3,1}) should return true.");
    }

    @Test
    public void testContainsAnyInArray() {
        ArrayList empty = new ArrayList(0);
        Object[] emptyArr = new String[]{};
        ArrayList<String> one = new ArrayList<String>(1);
        one.add("1");
        Object[] oneArr = new String[]{"1"};
        ArrayList<String> two = new ArrayList<String>(1);
        two.add("2");
        Object[] twoArr = new String[]{"2"};
        ArrayList<String> three = new ArrayList<String>(1);
        three.add("3");
        Object[] threeArr = new String[]{"3"};
        ArrayList<String> odds = new ArrayList<String>(2);
        odds.add("1");
        odds.add("3");
        Object[] oddsArr = new String[]{"1", "3"};
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(one, (Object[])oddsArr), (String)"containsAny({1},{1,3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, (Object[])oneArr), (String)"containsAny({1,3},{1}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(three, (Object[])oddsArr), (String)"containsAny({3},{1,3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, (Object[])threeArr), (String)"containsAny({1,3},{3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(two, (Object[])twoArr), (String)"containsAny({2},{2}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, (Object[])oddsArr), (String)"containsAny({1,3},{1,3}) should return true.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(two, (Object[])oddsArr), (String)"containsAny({2},{1,3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(odds, (Object[])twoArr), (String)"containsAny({1,3},{2}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(one, (Object[])threeArr), (String)"containsAny({1},{3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(three, (Object[])oneArr), (String)"containsAny({3},{1}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(odds, (Object[])emptyArr), (String)"containsAny({1,3},{}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(empty, (Object[])oddsArr), (String)"containsAny({},{1,3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(empty, (Object[])emptyArr), (String)"containsAny({},{}) should return false.");
    }

    @Test
    public void testContainsAnyInArrayNullArray() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        String[] array = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny((Collection)list, (Object[])array));
    }

    @Test
    public void testContainsAnyInArrayNullColl1() {
        String[] oneArr = new String[]{"1"};
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny(null, (Object[])oneArr));
    }

    @Test
    public void testContainsAnyInArrayNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Collection list2 = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny((Collection)list, (Collection)list2));
    }

    @Test
    public void testContainsAnyInCollection() {
        ArrayList empty = new ArrayList(0);
        ArrayList<String> one = new ArrayList<String>(1);
        one.add("1");
        ArrayList<String> two = new ArrayList<String>(1);
        two.add("2");
        ArrayList<String> three = new ArrayList<String>(1);
        three.add("3");
        ArrayList<String> odds = new ArrayList<String>(2);
        odds.add("1");
        odds.add("3");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(one, odds), (String)"containsAny({1},{1,3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, one), (String)"containsAny({1,3},{1}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(three, odds), (String)"containsAny({3},{1,3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, three), (String)"containsAny({1,3},{3}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(two, two), (String)"containsAny({2},{2}) should return true.");
        Assertions.assertTrue((boolean)CollectionUtils.containsAny(odds, odds), (String)"containsAny({1,3},{1,3}) should return true.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(two, odds), (String)"containsAny({2},{1,3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(odds, two), (String)"containsAny({1,3},{2}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(one, three), (String)"containsAny({1},{3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(three, one), (String)"containsAny({3},{1}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(odds, empty), (String)"containsAny({1,3},{}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(empty, odds), (String)"containsAny({},{1,3}) should return false.");
        Assertions.assertFalse((boolean)CollectionUtils.containsAny(empty, empty), (String)"containsAny({},{}) should return false.");
    }

    @Test
    public void testContainsAnyNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny(null, (Collection)list));
    }

    @Test
    public void testContainsAnyNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Collection list2 = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny((Collection)list, (Collection)list2));
    }

    @Test
    public void testContainsAnyNullColl3() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        String[] array = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.containsAny((Collection)list, (Object[])array));
    }

    @Test
    public void testDisjunction() {
        Collection col = CollectionUtils.disjunction(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(1)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(2)));
        Assertions.assertNull(freq.get(3));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(4)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(5)));
        Collection col2 = CollectionUtils.disjunction(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(1)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(2)));
        Assertions.assertNull(freq2.get(3));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(4)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(5)));
    }

    @Test
    public void testDisjunctionAsSymmetricDifference() {
        Collection dis = CollectionUtils.disjunction(this.collectionA, this.collectionC);
        Collection amb = CollectionUtils.subtract(this.collectionA, this.collectionC);
        Collection bma = CollectionUtils.subtract(this.collectionC, this.collectionA);
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)dis, (Collection)CollectionUtils.union((Iterable)amb, (Iterable)bma)));
    }

    @Test
    public void testDisjunctionAsUnionMinusIntersection() {
        Collection dis = CollectionUtils.disjunction(this.collectionA, this.collectionC);
        Collection un = CollectionUtils.union(this.collectionA, this.collectionC);
        Collection inter = CollectionUtils.intersection(this.collectionA, this.collectionC);
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)dis, (Collection)CollectionUtils.subtract((Iterable)un, (Iterable)inter)));
    }

    @Test
    public void testDisjunctionNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.disjunction(null, (Iterable)list));
    }

    @Test
    public void testDisjunctionNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.disjunction((Iterable)list, null));
    }

    @Test
    public void testEmptyCollection() throws Exception {
        Collection coll = CollectionUtils.emptyCollection();
        Assertions.assertEquals((Object)CollectionUtils.EMPTY_COLLECTION, (Object)coll);
    }

    @Test
    public void testEmptyIfNull() {
        Assertions.assertTrue((boolean)CollectionUtils.emptyIfNull(null).isEmpty());
        ArrayList collection = new ArrayList();
        Assertions.assertSame(collection, (Object)CollectionUtils.emptyIfNull(collection));
    }

    @Test
    public void testExtractSingleton() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            ArrayList collNull = null;
            Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.extractSingleton((Collection)collNull), (String)"expected NullPointerException from extractSingleton(null)");
        }, () -> {
            ArrayList collEmpty = new ArrayList();
            Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.extractSingleton((Collection)collEmpty), (String)"expected IllegalArgumentException from extractSingleton(empty)");
        }, () -> {
            ArrayList<String> coll = new ArrayList<String>();
            coll.add("foo");
            Assertions.assertEquals((Object)"foo", (Object)CollectionUtils.extractSingleton(coll));
            coll.add("bar");
            Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.extractSingleton((Collection)coll), (String)"expected IllegalArgumentException from extractSingleton(size == 2)");
        }});
    }

    @Test
    public void testFilter() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(1);
        ints.add(2);
        ints.add(3);
        ints.add(3);
        ArrayList<Integer> iterable = ints;
        Assertions.assertTrue((boolean)CollectionUtils.filter(iterable, EQUALS_TWO));
        Assertions.assertEquals((int)1, (int)ints.size());
        Assertions.assertEquals((int)2, (int)((Integer)ints.get(0)));
    }

    @Test
    public void testFilterInverse() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(1);
        ints.add(2);
        ints.add(3);
        ints.add(3);
        ArrayList<Integer> iterable = ints;
        Assertions.assertTrue((boolean)CollectionUtils.filterInverse(iterable, EQUALS_TWO));
        Assertions.assertEquals((int)3, (int)ints.size());
        Assertions.assertEquals((int)1, (int)((Integer)ints.get(0)));
        Assertions.assertEquals((int)3, (int)((Integer)ints.get(1)));
        Assertions.assertEquals((int)3, (int)((Integer)ints.get(2)));
    }

    @Test
    public void testFilterInverseNullParameters() throws Exception {
        List<Long> longs = Collections.nCopies(4, 10L);
        Assertions.assertFalse((boolean)CollectionUtils.filterInverse(longs, null));
        Assertions.assertEquals((int)4, (int)longs.size());
        Assertions.assertFalse((boolean)CollectionUtils.filterInverse(null, EQUALS_TWO));
        Assertions.assertEquals((int)4, (int)longs.size());
        Assertions.assertFalse((boolean)CollectionUtils.filterInverse(null, null));
        Assertions.assertEquals((int)4, (int)longs.size());
    }

    @Test
    public void testFilterNullParameters() throws Exception {
        List<Long> longs = Collections.nCopies(4, 10L);
        Assertions.assertFalse((boolean)CollectionUtils.filter(longs, null));
        Assertions.assertEquals((int)4, (int)longs.size());
        Assertions.assertFalse((boolean)CollectionUtils.filter(null, EQUALS_TWO));
        Assertions.assertEquals((int)4, (int)longs.size());
        Assertions.assertFalse((boolean)CollectionUtils.filter(null, null));
        Assertions.assertEquals((int)4, (int)longs.size());
    }

    @Test
    public void testGet() {
        Assertions.assertEquals((Object)2, (Object)CollectionUtils.get(this.collectionA, (int)2));
        Assertions.assertEquals((Object)2, (Object)CollectionUtils.get(this.collectionA.iterator(), (int)2));
        Map map = CollectionUtils.getCardinalityMap(this.collectionA);
        LinkedHashMap linkedMap = new LinkedHashMap(map);
        Assertions.assertEquals(linkedMap.entrySet().iterator().next(), (Object)CollectionUtils.get(linkedMap, (int)0));
    }

    @Test
    public void testGet1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.get(null, (int)0));
    }

    @Test
    public void testGetCardinalityMap() {
        Map freqA = CollectionUtils.getCardinalityMap(this.iterableA);
        Assertions.assertEquals((int)1, (int)((Integer)freqA.get(1)));
        Assertions.assertEquals((int)2, (int)((Integer)freqA.get(2)));
        Assertions.assertEquals((int)3, (int)((Integer)freqA.get(3)));
        Assertions.assertEquals((int)4, (int)((Integer)freqA.get(4)));
        Assertions.assertNull(freqA.get(5));
        Map freqB = CollectionUtils.getCardinalityMap(this.iterableB);
        Assertions.assertNull(freqB.get(1L));
        Assertions.assertEquals((int)4, (int)((Integer)freqB.get(2L)));
        Assertions.assertEquals((int)3, (int)((Integer)freqB.get(3L)));
        Assertions.assertEquals((int)2, (int)((Integer)freqB.get(4L)));
        Assertions.assertEquals((int)1, (int)((Integer)freqB.get(5L)));
    }

    @Test
    public void testGetCardinalityMapNull() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.getCardinalityMap(null));
    }

    @Test
    public void testGetEnumeration() {
        Vector<Integer> vectorA = new Vector<Integer>(this.collectionA);
        Enumeration<Integer> e = vectorA.elements();
        Assertions.assertEquals((Object)2, (Object)CollectionUtils.get(e, (int)2));
        Assertions.assertTrue((boolean)e.hasMoreElements());
        Assertions.assertEquals((Object)4, (Object)CollectionUtils.get(e, (int)6));
        Assertions.assertFalse((boolean)e.hasMoreElements());
    }

    @Test
    public void testGetFromHashMap() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("zeroKey", "zero");
        expected.put("oneKey", "one");
        Map.Entry entry = CollectionUtils.get(expected, (int)0);
        Assertions.assertTrue((entry.toString().equals("zeroKey=zero") || entry.toString().equals("oneKey=one") ? 1 : 0) != 0);
        entry = CollectionUtils.get(expected, (int)1);
        Assertions.assertTrue((entry.toString().equals("zeroKey=zero") || entry.toString().equals("oneKey=one") ? 1 : 0) != 0);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Map)expected, (int)2), (String)"Expecting IndexOutOfBoundsException."), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Map)expected, (int)-2), (String)"Expecting IndexOutOfBoundsException.")});
    }

    @Test
    public void testGetFromLinkedHashMap() {
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("zeroKey", "zero");
        expected.put("oneKey", "one");
        LinkedHashMap<String, String> found = new LinkedHashMap<String, String>();
        Map.Entry entry = CollectionUtils.get(expected, (int)0);
        found.put((String)entry.getKey(), (String)entry.getValue());
        entry = CollectionUtils.get(expected, (int)1);
        found.put((String)entry.getKey(), (String)entry.getValue());
        Assertions.assertEquals(expected, found);
    }

    @Test
    public void testGetFromList() throws Exception {
        List list = (List)this.createMock(List.class);
        this.expect((String)list.get(0)).andReturn((Object)"zero");
        this.expect((String)list.get(1)).andReturn((Object)"one");
        this.replay();
        String string = (String)CollectionUtils.get((Iterable)list, (int)0);
        Assertions.assertEquals((Object)"zero", (Object)string);
        Assertions.assertEquals((Object)"one", (Object)CollectionUtils.get((Iterable)list, (int)1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get(new ArrayList(), (int)2));
    }

    @Test
    public void testGetFromMapIndexOutOfRange() {
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("zeroKey", "zero");
        expected.put("oneKey", "one");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Map)expected, (int)2), (String)"Expecting IndexOutOfBoundsException."), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Map)expected, (int)-2), (String)"Expecting IndexOutOfBoundsException.")});
    }

    @Test
    public void testGetFromObject() throws Exception {
        Object obj = new Object();
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.get((Object)obj, (int)0));
    }

    @Test
    public void testGetFromObjectArray() throws Exception {
        Object[] objArray = new Object[]{"zero", "one"};
        Assertions.assertEquals((Object)"zero", (Object)CollectionUtils.get((Object)objArray, (int)0));
        Assertions.assertEquals((Object)"one", (Object)CollectionUtils.get((Object)objArray, (int)1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Object)objArray, (int)2));
    }

    @Test
    public void testGetFromPrimitiveArray() throws Exception {
        int[] array = new int[]{10, 20};
        Assertions.assertEquals((Object)10, (Object)CollectionUtils.get((Object)array, (int)0));
        Assertions.assertEquals((Object)20, (Object)CollectionUtils.get((Object)array, (int)1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get((Object)array, (int)2));
    }

    @Test
    public void testGetFromTreeMap() {
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("zeroKey", "zero");
        expected.put("oneKey", "one");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("zeroKey", "zero");
        map.put("oneKey", "one");
        Map.Entry test = CollectionUtils.get(map, (int)1);
        Assertions.assertEquals((Object)"zeroKey", test.getKey());
        Assertions.assertEquals((Object)"zero", test.getValue());
        test = CollectionUtils.get(map, (int)0);
        Assertions.assertEquals((Object)"oneKey", test.getKey());
        Assertions.assertEquals((Object)"one", test.getValue());
    }

    @Test
    public void testGetIterator() {
        Iterator<Integer> it = this.collectionA.iterator();
        Assertions.assertEquals((Object)2, (Object)CollectionUtils.get(it, (int)2));
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)4, (Object)CollectionUtils.get(it, (int)6));
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetNegative() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get(this.collectionA, (int)-3));
    }

    @Test
    public void testGetPositiveOutOfBounds() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.get(this.collectionA.iterator(), (int)30));
    }

    @Test
    public void testHashCode() {
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o == null ? 0 : Objects.hashCode(o);
            }
        };
        Assertions.assertEquals((int)this.collectionA.hashCode(), (int)CollectionUtils.hashCode(this.collectionA, (Equator)e));
    }

    @Test
    public void testHashCodeNullCollection() {
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o == null ? 0 : Objects.hashCode(o);
            }
        };
        Collection collection = null;
        Assertions.assertEquals((int)0, (int)CollectionUtils.hashCode(collection, (Equator)e));
    }

    @Test
    public void testHashCodeNullEquator() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.hashCode(this.collectionB, null));
    }

    @Test
    public void testIntersection() {
        Collection col = CollectionUtils.intersection(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assertions.assertNull(freq.get(1));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(2)));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq.get(3)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(4)));
        Assertions.assertNull(freq.get(5));
        Collection col2 = CollectionUtils.intersection(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assertions.assertNull(freq2.get(1));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(2)));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq2.get(3)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(4)));
        Assertions.assertNull(freq2.get(5));
    }

    @Test
    public void testIntersectionNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.intersection(null, (Iterable)list));
    }

    @Test
    public void testIntersectionNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.intersection((Iterable)list, null));
    }

    @Test
    public void testIntersectionUsesMethodEquals() {
        Integer elta = 17;
        Integer eltb = 17;
        Assertions.assertSame((Object)elta, (Object)eltb);
        ArrayList<Integer> cola = new ArrayList<Integer>();
        ArrayList<Integer> colb = new ArrayList<Integer>();
        cola.add(elta);
        colb.add(eltb);
        Collection intersection = CollectionUtils.intersection(cola, colb);
        Assertions.assertEquals((int)1, (int)intersection.size());
        Object eltc = intersection.iterator().next();
        Assertions.assertTrue((eltc == elta && eltc == eltb ? 1 : 0) != 0);
        Assertions.assertEquals((Object)elta, eltc);
        Assertions.assertEquals(eltc, (Object)elta);
        Assertions.assertEquals((Object)eltb, eltc);
        Assertions.assertEquals(eltc, (Object)eltb);
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertFalse((boolean)CollectionUtils.isNotEmpty(null));
        Assertions.assertTrue((boolean)CollectionUtils.isNotEmpty(this.collectionA));
    }

    @Test
    public void testIsEmptyWithEmptyCollection() {
        Assertions.assertTrue((boolean)CollectionUtils.isEmpty(new ArrayList()));
    }

    @Test
    public void testIsEmptyWithNonEmptyCollection() {
        Assertions.assertFalse((boolean)CollectionUtils.isEmpty(Collections.singletonList("item")));
    }

    @Test
    public void testIsEmptyWithNull() {
        Assertions.assertTrue((boolean)CollectionUtils.isEmpty(null));
    }

    @Test
    public void testIsEqualCollection() {
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionC));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionC, this.collectionA));
    }

    @Test
    public void testIsEqualCollection2() {
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("1");
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(b, a));
        b.add("1");
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("2");
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(b, a));
        b.add("2");
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
        a.add("1");
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(b, a));
        b.add("1");
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(a, b));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(b, a));
    }

    @Test
    public void testIsEqualCollectionEquator() {
        Collection collB = CollectionUtils.collect(this.collectionB, this.TRANSFORM_TO_INTEGER);
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o % 2 == 0 ? Integer.valueOf(0).hashCode() : Integer.valueOf(1).hashCode();
            }
        };
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionA, (Equator)e));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, (Collection)collB, (Equator)e));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)collB, this.collectionA, (Equator)e));
        DefaultEquator defaultEquator = DefaultEquator.defaultEquator();
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionB, (Equator)defaultEquator));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, (Collection)collB, (Equator)defaultEquator));
    }

    @Test
    public void testIsEqualCollectionNullColl1() {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        list.add(1);
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o % 2 == 0 ? Integer.valueOf(0).hashCode() : Integer.valueOf(1).hashCode();
            }
        };
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtilsTest.lambda$testIsEqualCollectionNullColl1$50(list, (Equator)e));
    }

    @Test
    public void testIsEqualCollectionNullColl2() {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        list.add(1);
        Equator<Integer> e = new Equator<Integer>(){

            public boolean equate(Integer o1, Integer o2) {
                return !(o1 % 2 == 0 ^ o2 % 2 == 0);
            }

            public int hash(Integer o) {
                return o % 2 == 0 ? Integer.valueOf(0).hashCode() : Integer.valueOf(1).hashCode();
            }
        };
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtilsTest.lambda$testIsEqualCollectionNullColl2$51(list, (Equator)e));
    }

    @Test
    public void testIsEqualCollectionNullEquator() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isEqualCollection(this.collectionA, this.collectionA, null));
    }

    @Test
    public void testIsEqualCollectionReturnsFalse() {
        ArrayList<Integer> b = new ArrayList<Integer>(this.collectionA);
        b.remove(1);
        b.add(5);
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(this.collectionA, b));
        Assertions.assertFalse((boolean)CollectionUtils.isEqualCollection(b, this.collectionA));
    }

    @Test
    public void testIsEqualCollectionToSelf() {
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionA, this.collectionA));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection(this.collectionB, this.collectionB));
    }

    @Test
    public void testIsFull() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        Assertions.assertFalse((boolean)CollectionUtils.isFull(set));
        CircularFifoQueue buf = new CircularFifoQueue(set);
        Assertions.assertFalse((boolean)CollectionUtils.isFull((Collection)buf));
        buf.remove((Object)"2");
        Assertions.assertFalse((boolean)CollectionUtils.isFull((Collection)buf));
        buf.add((Object)"2");
        Assertions.assertFalse((boolean)CollectionUtils.isFull((Collection)buf));
    }

    @Test
    public void testIsFullNullColl() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isFull(null));
    }

    @Test
    public void testIsNotEmptyWithEmptyCollection() {
        Assertions.assertFalse((boolean)CollectionUtils.isNotEmpty(new ArrayList()));
    }

    @Test
    public void testIsNotEmptyWithNonEmptyCollection() {
        Assertions.assertTrue((boolean)CollectionUtils.isNotEmpty(Collections.singletonList("item")));
    }

    @Test
    public void testIsNotEmptyWithNull() {
        Assertions.assertFalse((boolean)CollectionUtils.isNotEmpty(null));
    }

    @Test
    public void testIsProperSubCollection() {
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> b = new ArrayList<String>();
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(a, b));
        b.add("1");
        Assertions.assertTrue((boolean)CollectionUtils.isProperSubCollection(a, b));
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(b, a));
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(b, b));
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(a, a));
        a.add("1");
        a.add("2");
        b.add("2");
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(b, a));
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(a, b));
        a.add("1");
        Assertions.assertTrue((boolean)CollectionUtils.isProperSubCollection(b, a));
        Assertions.assertTrue((boolean)CollectionUtils.isProperSubCollection((Collection)CollectionUtils.intersection(this.collectionA, this.collectionC), this.collectionA));
        Assertions.assertTrue((boolean)CollectionUtils.isProperSubCollection((Collection)CollectionUtils.subtract(a, b), a));
        Assertions.assertFalse((boolean)CollectionUtils.isProperSubCollection(a, (Collection)CollectionUtils.subtract(a, b)));
    }

    @Test
    public void testIsProperSubCollectionNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isProperSubCollection(null, (Collection)list));
    }

    @Test
    public void testIsProperSubCollectionNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isProperSubCollection((Collection)list, null));
    }

    @Test
    public void testIsSubCollection() {
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, this.collectionC));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionC, this.collectionA));
    }

    @Test
    public void testIsSubCollection2() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(1);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(2);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(2);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(3);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(3);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(3);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(4);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(4);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(4);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(4);
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
        c.add(5);
        Assertions.assertFalse((boolean)CollectionUtils.isSubCollection(c, this.collectionA));
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, c));
    }

    @Test
    public void testIsSubCollectionNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isSubCollection(null, (Collection)list));
    }

    @Test
    public void testIsSubCollectionNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.isSubCollection((Collection)list, null));
    }

    @Test
    public void testIsSubCollectionOfSelf() {
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionA, this.collectionA));
        Assertions.assertTrue((boolean)CollectionUtils.isSubCollection(this.collectionB, this.collectionB));
    }

    @Test
    @Deprecated
    public void testMatchesAll() {
        Assertions.assertFalse((boolean)CollectionUtils.matchesAll(null, null));
        Assertions.assertFalse((boolean)CollectionUtils.matchesAll(this.collectionA, null));
        Predicate lessThanFive = object -> object < 5;
        Assertions.assertTrue((boolean)CollectionUtils.matchesAll(this.collectionA, (Predicate)lessThanFive));
        Predicate lessThanFour = object -> object < 4;
        Assertions.assertFalse((boolean)CollectionUtils.matchesAll(this.collectionA, (Predicate)lessThanFour));
        Assertions.assertTrue((boolean)CollectionUtils.matchesAll(null, (Predicate)lessThanFour));
        Assertions.assertTrue((boolean)CollectionUtils.matchesAll(this.emptyCollection, (Predicate)lessThanFour));
    }

    @Test
    public void testMaxSize() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        Assertions.assertEquals((int)-1, (int)CollectionUtils.maxSize(set));
        CircularFifoQueue buf = new CircularFifoQueue(set);
        Assertions.assertEquals((int)3, (int)CollectionUtils.maxSize((Collection)buf));
        buf.remove("2");
        Assertions.assertEquals((int)3, (int)CollectionUtils.maxSize((Collection)buf));
        buf.add("2");
        Assertions.assertEquals((int)3, (int)CollectionUtils.maxSize((Collection)buf));
    }

    @Test
    public void testMaxSizeNullColl() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.maxSize(null));
    }

    @Test
    public void testPermutations() {
        List<Integer> sample = this.collectionA.subList(0, 5);
        Collection permutations = CollectionUtils.permutations(sample);
        int collSize = sample.size();
        int factorial = 1;
        for (int i = 1; i <= collSize; ++i) {
            factorial *= i;
        }
        Assertions.assertEquals((int)factorial, (int)permutations.size());
    }

    @Test
    public void testPermutationsWithNullCollection() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.permutations(null));
    }

    @Test
    public void testPredicatedCollection() {
        Predicate predicate = PredicateUtils.instanceofPredicate(Integer.class);
        Collection collection = CollectionUtils.predicatedCollection(new ArrayList(), (Predicate)predicate);
        Assertions.assertTrue((boolean)(collection instanceof PredicatedCollection), (String)"returned object should be a PredicatedCollection");
    }

    @Test
    public void testPredicatedCollectionNullColl() {
        Predicate predicate = PredicateUtils.instanceofPredicate(Integer.class);
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.predicatedCollection(null, (Predicate)predicate));
    }

    @Test
    public void testPredicatedCollectionNullPredicate() {
        ArrayList list = new ArrayList();
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.predicatedCollection((Collection)list, null));
    }

    @Test
    public void testRemoveAll() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        base.add("B");
        base.add("C");
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        sub.add("C");
        sub.add("X");
        Collection result = CollectionUtils.removeAll(base, sub);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertFalse((boolean)result.contains("A"));
        Assertions.assertTrue((boolean)result.contains("B"));
        Assertions.assertFalse((boolean)result.contains("C"));
        Assertions.assertEquals((int)3, (int)base.size());
        Assertions.assertTrue((boolean)base.contains("A"));
        Assertions.assertTrue((boolean)base.contains("B"));
        Assertions.assertTrue((boolean)base.contains("C"));
        Assertions.assertEquals((int)3, (int)sub.size());
        Assertions.assertTrue((boolean)sub.contains("A"));
        Assertions.assertTrue((boolean)sub.contains("C"));
        Assertions.assertTrue((boolean)sub.contains("X"));
    }

    @Test
    public void testRemoveAllNullBaseColl() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeAll(null, (Collection)sub));
    }

    @Test
    public void testRemoveAllNullSubColl() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeAll((Collection)base, null));
    }

    @Test
    public void testRemoveAllWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        ArrayList<String> remove = new ArrayList<String>();
        remove.add("AA");
        remove.add("CX");
        remove.add("XZ");
        Collection result = CollectionUtils.removeAll(base, remove, (Equator)new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        });
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertTrue((boolean)result.contains("AC"));
        Assertions.assertTrue((boolean)result.contains("BB"));
        Assertions.assertFalse((boolean)result.contains("CA"));
        Assertions.assertEquals((int)3, (int)base.size());
        Assertions.assertTrue((boolean)base.contains("AC"));
        Assertions.assertTrue((boolean)base.contains("BB"));
        Assertions.assertTrue((boolean)base.contains("CA"));
        Assertions.assertEquals((int)3, (int)remove.size());
        Assertions.assertTrue((boolean)remove.contains("AA"));
        Assertions.assertTrue((boolean)remove.contains("CX"));
        Assertions.assertTrue((boolean)remove.contains("XZ"));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeAll(null, null, (Equator)DefaultEquator.defaultEquator()), (String)"expecting NullPointerException"), () -> Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeAll((Iterable)base, (Iterable)remove, null), (String)"expecting NullPointerException")});
    }

    @Test
    public void testRemoveCount() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Collection result = CollectionUtils.removeCount(list, (int)0, (int)0);
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)0, (int)result.size());
        result = CollectionUtils.removeCount(list, (int)0, (int)1);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)2, (int)((Integer)list.get(0)));
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.contains(1));
        list.add(5);
        list.add(6);
        result = CollectionUtils.removeCount(list, (int)1, (int)3);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((int)2, (int)((Integer)list.get(0)));
        Assertions.assertEquals((int)6, (int)((Integer)list.get(1)));
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertTrue((boolean)result.contains(3));
        Assertions.assertTrue((boolean)result.contains(4));
        Assertions.assertTrue((boolean)result.contains(5));
    }

    @Test
    public void testRemoveCountNegative() {
        ArrayList list = new ArrayList();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.removeCount((Collection)list, (int)0, (int)-1));
    }

    @Test
    public void testRemoveCountStartNegative() {
        ArrayList list = new ArrayList();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.removeCount((Collection)list, (int)-1, (int)1));
    }

    @Test
    public void testRemoveCountWithNull() {
        Collection list = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeCount((Collection)list, (int)0, (int)1));
    }

    @Test
    public void testRemoveCountWrongCount() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.removeCount((Collection)list, (int)0, (int)2));
    }

    @Test
    public void testRemoveRange() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Collection result = CollectionUtils.removeRange(list, (int)0, (int)0);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)0, (int)result.size());
        list.add(2);
        list.add(3);
        result = CollectionUtils.removeRange(list, (int)1, (int)3);
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)1, (int)((Integer)list.get(0)));
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertTrue((boolean)result.contains(2));
        Assertions.assertTrue((boolean)result.contains(3));
    }

    @Test
    public void testRemoveRangeEndIndexNegative() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.removeRange((Collection)list, (int)0, (int)-1));
    }

    @Test
    public void testRemoveRangeEndLowStart() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.removeRange((Collection)list, (int)1, (int)0));
    }

    @Test
    public void testRemoveRangeNull() {
        Collection list = null;
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.removeRange((Collection)list, (int)0, (int)0));
    }

    @Test
    public void testRemoveRangeStartIndexNegative() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.removeRange((Collection)list, (int)-1, (int)1));
    }

    @Test
    public void testRemoveRangeWrongEndIndex() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> CollectionUtils.removeRange((Collection)list, (int)0, (int)2));
    }

    @Test
    public void testRetainAll() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        base.add("B");
        base.add("C");
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        sub.add("C");
        sub.add("X");
        Collection result = CollectionUtils.retainAll(base, sub);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertTrue((boolean)result.contains("A"));
        Assertions.assertFalse((boolean)result.contains("B"));
        Assertions.assertTrue((boolean)result.contains("C"));
        Assertions.assertEquals((int)3, (int)base.size());
        Assertions.assertTrue((boolean)base.contains("A"));
        Assertions.assertTrue((boolean)base.contains("B"));
        Assertions.assertTrue((boolean)base.contains("C"));
        Assertions.assertEquals((int)3, (int)sub.size());
        Assertions.assertTrue((boolean)sub.contains("A"));
        Assertions.assertTrue((boolean)sub.contains("C"));
        Assertions.assertTrue((boolean)sub.contains("X"));
    }

    @Test
    public void testRetainAllNullBaseColl() {
        ArrayList<String> sub = new ArrayList<String>();
        sub.add("A");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.retainAll(null, (Collection)sub));
    }

    @Test
    public void testRetainAllNullSubColl() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("A");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.retainAll((Collection)base, null));
    }

    @Test
    public void testRetainAllWithEquator() {
        ArrayList<String> base = new ArrayList<String>();
        base.add("AC");
        base.add("BB");
        base.add("CA");
        ArrayList<String> retain = new ArrayList<String>();
        retain.add("AA");
        retain.add("CX");
        retain.add("XZ");
        Collection result = CollectionUtils.retainAll(base, retain, (Equator)new Equator<String>(){

            public boolean equate(String o1, String o2) {
                return o1.charAt(1) == o2.charAt(1);
            }

            public int hash(String o) {
                return o.charAt(1);
            }
        });
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)result.contains("CA"));
        Assertions.assertFalse((boolean)result.contains("BB"));
        Assertions.assertFalse((boolean)result.contains("AC"));
        Assertions.assertEquals((int)3, (int)base.size());
        Assertions.assertTrue((boolean)base.contains("AC"));
        Assertions.assertTrue((boolean)base.contains("BB"));
        Assertions.assertTrue((boolean)base.contains("CA"));
        Assertions.assertEquals((int)3, (int)retain.size());
        Assertions.assertTrue((boolean)retain.contains("AA"));
        Assertions.assertTrue((boolean)retain.contains("CX"));
        Assertions.assertTrue((boolean)retain.contains("XZ"));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.retainAll(null, null, null), (String)"expecting NullPointerException"), () -> Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.retainAll((Iterable)base, (Iterable)retain, null), (String)"expecting NullPointerException")});
    }

    @Test
    public void testReverse() {
        CollectionUtils.reverseArray((Object[])new Object[0]);
        Object[] a = this.collectionA.toArray(ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY);
        CollectionUtils.reverseArray((Object[])a);
        Collections.reverse(this.collectionA);
        Assertions.assertEquals(this.collectionA, Arrays.asList(a));
    }

    @Test
    public void testReverseArrayNull() {
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.reverseArray(null));
    }

    @Test
    public void testSelect() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Collection output1 = CollectionUtils.select(list, EQUALS_TWO);
        Collection output2 = CollectionUtils.select(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.select(list, EQUALS_TWO, new HashSet());
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)1, (int)output1.size());
        Assertions.assertEquals((Object)2, output2.iterator().next());
    }

    @Test
    public void testSelectRejected() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        list.add(4L);
        Collection output1 = CollectionUtils.selectRejected(list, EQUALS_TWO);
        Collection output2 = CollectionUtils.selectRejected(list, EQUALS_TWO);
        HashSet output3 = (HashSet)CollectionUtils.selectRejected(list, EQUALS_TWO, new HashSet());
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output2));
        Assertions.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)output1, (Collection)output3));
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)3, (int)output1.size());
        Assertions.assertTrue((boolean)output1.contains(1L));
        Assertions.assertTrue((boolean)output1.contains(3L));
        Assertions.assertTrue((boolean)output1.contains(4L));
    }

    @Test
    public void testSelectWithOutputCollections() {
        ArrayList<Integer> input = new ArrayList<Integer>();
        input.add(1);
        input.add(2);
        input.add(3);
        input.add(4);
        ArrayList output = new ArrayList();
        ArrayList rejected = new ArrayList();
        CollectionUtils.select(input, EQUALS_TWO, output, rejected);
        Assertions.assertEquals((int)1, (int)output.size());
        Assertions.assertEquals((int)2, (int)((Integer)CollectionUtils.extractSingleton(output)));
        Object[] expected = new Integer[]{1, 3, 4};
        Assertions.assertArrayEquals((Object[])expected, (Object[])rejected.toArray());
        output.clear();
        rejected.clear();
        CollectionUtils.select((Iterable)null, EQUALS_TWO, output, rejected);
        Assertions.assertTrue((boolean)output.isEmpty());
        Assertions.assertTrue((boolean)rejected.isEmpty());
    }

    @Test
    public void testSize_Array() {
        Object[] objectArray = new Object[]{};
        Assertions.assertEquals((int)0, (int)CollectionUtils.size((Object)objectArray));
        String[] stringArray = new String[3];
        Assertions.assertEquals((int)3, (int)CollectionUtils.size((Object)stringArray));
        stringArray[0] = "a";
        stringArray[1] = "b";
        stringArray[2] = "c";
        Assertions.assertEquals((int)3, (int)CollectionUtils.size((Object)stringArray));
    }

    @Test
    public void testSize_Enumeration() {
        Vector<String> list = new Vector<String>();
        Assertions.assertEquals((int)0, (int)CollectionUtils.size(list.elements()));
        list.add("a");
        Assertions.assertEquals((int)1, (int)CollectionUtils.size(list.elements()));
        list.add("b");
        Assertions.assertEquals((int)2, (int)CollectionUtils.size(list.elements()));
    }

    @Test
    public void testSize_Iterator() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertEquals((int)0, (int)CollectionUtils.size(list.iterator()));
        list.add("a");
        Assertions.assertEquals((int)1, (int)CollectionUtils.size(list.iterator()));
        list.add("b");
        Assertions.assertEquals((int)2, (int)CollectionUtils.size(list.iterator()));
    }

    @Test
    public void testSize_List() {
        ArrayList<String> list = null;
        Assertions.assertEquals((int)0, (int)CollectionUtils.size(list));
        list = new ArrayList<String>();
        Assertions.assertEquals((int)0, (int)CollectionUtils.size(list));
        list.add("a");
        Assertions.assertEquals((int)1, (int)CollectionUtils.size(list));
        list.add("b");
        Assertions.assertEquals((int)2, (int)CollectionUtils.size(list));
    }

    @Test
    public void testSize_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assertions.assertEquals((int)0, (int)CollectionUtils.size(map));
        map.put("1", "a");
        Assertions.assertEquals((int)1, (int)CollectionUtils.size(map));
        map.put("2", "b");
        Assertions.assertEquals((int)2, (int)CollectionUtils.size(map));
    }

    @Test
    public void testSize_Other() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.size((Object)"not a list"));
    }

    @Test
    public void testSize_PrimitiveArray() {
        int[] intArray = new int[]{};
        Assertions.assertEquals((int)0, (int)CollectionUtils.size((Object)intArray));
        double[] doubleArray = new double[3];
        Assertions.assertEquals((int)3, (int)CollectionUtils.size((Object)doubleArray));
        doubleArray[0] = 0.0;
        doubleArray[1] = 1.0;
        doubleArray[2] = 2.5;
        Assertions.assertEquals((int)3, (int)CollectionUtils.size((Object)doubleArray));
    }

    @Test
    public void testSizeIsEmpty_Array() {
        Object[] objectArray = new Object[]{};
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty((Object)objectArray));
        String[] stringArray = new String[3];
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty((Object)stringArray));
        stringArray[0] = "a";
        stringArray[1] = "b";
        stringArray[2] = "c";
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty((Object)stringArray));
    }

    @Test
    public void testSizeIsEmpty_Enumeration() {
        Vector<String> list = new Vector<String>();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(list.elements()));
        list.add("a");
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty(list.elements()));
        Enumeration en = list.elements();
        en.nextElement();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(en));
    }

    @Test
    public void testSizeIsEmpty_Iterator() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(list.iterator()));
        list.add("a");
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty(list.iterator()));
        Iterator it = list.iterator();
        it.next();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(it));
    }

    @Test
    public void testSizeIsEmpty_List() {
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(list));
        list.add("a");
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty(list));
    }

    @Test
    public void testSizeIsEmpty_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(map));
        map.put("1", "a");
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty(map));
    }

    @Test
    public void testSizeIsEmpty_Null() {
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty(null));
    }

    @Test
    public void testSizeIsEmpty_Other() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.sizeIsEmpty((Object)"not a list"), (String)"Expecting IllegalArgumentException");
    }

    @Test
    public void testSizeIsEmpty_PrimitiveArray() {
        int[] intArray = new int[]{};
        Assertions.assertTrue((boolean)CollectionUtils.sizeIsEmpty((Object)intArray));
        double[] doubleArray = new double[3];
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty((Object)doubleArray));
        doubleArray[0] = 0.0;
        doubleArray[1] = 1.0;
        doubleArray[2] = 2.5;
        Assertions.assertFalse((boolean)CollectionUtils.sizeIsEmpty((Object)doubleArray));
    }

    @Test
    public void testSubtract() {
        Collection col = CollectionUtils.subtract(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(1)));
        Assertions.assertNull(freq.get(2));
        Assertions.assertNull(freq.get(3));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq.get(4)));
        Assertions.assertNull(freq.get(5));
        Collection col2 = CollectionUtils.subtract(this.collectionC2, this.collectionA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(5)));
        Assertions.assertNull(freq2.get(4));
        Assertions.assertNull(freq2.get(3));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(2)));
        Assertions.assertNull(freq2.get(1));
    }

    @Test
    public void testSubtractNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.subtract(null, (Iterable)list));
    }

    @Test
    public void testSubtractNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.subtract((Iterable)list, null));
    }

    @Test
    public void testSubtractWithPredicate() {
        Predicate predicate = n -> n.longValue() > 3L;
        Collection col = CollectionUtils.subtract(this.iterableA, this.collectionC, (Predicate)predicate);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(1)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(2)));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq2.get(3)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)freq2.get(4)));
        Assertions.assertNull(freq2.get(5));
    }

    @Test
    @Deprecated
    public void testSynchronizedCollection() {
        Collection col = CollectionUtils.synchronizedCollection(new ArrayList());
        Assertions.assertTrue((boolean)(col instanceof SynchronizedCollection), (String)"Returned object should be a SynchronizedCollection.");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.synchronizedCollection(null), (String)"Expecting NullPointerException for null collection.");
    }

    @Test
    public void testTransform1() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        CollectionUtils.transform(list, this.TRANSFORM_TO_INTEGER);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)1, list.get(0));
        Assertions.assertEquals((Object)2, list.get(1));
        Assertions.assertEquals((Object)3, list.get(2));
        list = new ArrayList();
        list.add(1L);
        list.add(2L);
        list.add(3L);
        CollectionUtils.transform(null, this.TRANSFORM_TO_INTEGER);
        Assertions.assertEquals((int)3, (int)list.size());
        CollectionUtils.transform(list, null);
        Assertions.assertEquals((int)3, (int)list.size());
        CollectionUtils.transform(null, null);
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testTransform2() {
        HashSet<Long> set = new HashSet<Long>();
        set.add(1L);
        set.add(2L);
        set.add(3L);
        CollectionUtils.transform(set, input -> 4);
        Assertions.assertEquals((int)1, (int)set.size());
        Assertions.assertEquals((Object)4, set.iterator().next());
    }

    @Test
    public void testTransformedCollection() {
        Transformer transformer = TransformerUtils.nopTransformer();
        Collection collection = CollectionUtils.transformingCollection(new ArrayList(), (Transformer)transformer);
        Assertions.assertTrue((boolean)(collection instanceof TransformedCollection), (String)"returned object should be a TransformedCollection");
    }

    @Test
    public void testTransformedCollection_2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        Collection result = CollectionUtils.transformingCollection(list, this.TRANSFORM_TO_INTEGER);
        Assertions.assertTrue((boolean)result.contains("1"));
        Assertions.assertTrue((boolean)result.contains("2"));
        Assertions.assertTrue((boolean)result.contains("3"));
    }

    @Test
    public void testTransformingCollectionNullColl() {
        Transformer transformer = TransformerUtils.nopTransformer();
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.transformingCollection(null, (Transformer)transformer));
    }

    @Test
    public void testTransformingCollectionNullTransformer() {
        ArrayList list = new ArrayList();
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.transformingCollection((Collection)list, null));
    }

    @Test
    public void testUnion() {
        Collection col = CollectionUtils.union(this.iterableA, this.iterableC);
        Map freq = CollectionUtils.getCardinalityMap((Iterable)col);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(1)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)freq.get(2)));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq.get(3)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)freq.get(4)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq.get(5)));
        Collection col2 = CollectionUtils.union(this.collectionC2, this.iterableA);
        Map freq2 = CollectionUtils.getCardinalityMap((Iterable)col2);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(1)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)freq2.get(2)));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)freq2.get(3)));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)freq2.get(4)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)freq2.get(5)));
    }

    @Test
    public void testUnionNullColl1() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.union(null, (Iterable)list));
    }

    @Test
    public void testUnionNullColl2() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("1");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.union((Iterable)list, null));
    }

    @Test
    @Deprecated
    public void testUnmodifiableCollection() {
        Collection col = CollectionUtils.unmodifiableCollection(new ArrayList());
        Assertions.assertTrue((boolean)(col instanceof UnmodifiableCollection), (String)"Returned object should be a UnmodifiableCollection.");
        Assertions.assertThrows(NullPointerException.class, () -> CollectionUtils.unmodifiableCollection(null), (String)"Expecting NullPointerException for null collection.");
    }

    private static /* synthetic */ void lambda$testIsEqualCollectionNullColl2$51(Collection list, Equator e) throws Throwable {
        CollectionUtils.isEqualCollection((Collection)list, null, (Equator)e);
    }

    private static /* synthetic */ void lambda$testIsEqualCollectionNullColl1$50(Collection list, Equator e) throws Throwable {
        CollectionUtils.isEqualCollection(null, (Collection)list, (Equator)e);
    }

    private static /* synthetic */ void lambda$getFromIterable$6(Bag bag) throws Throwable {
        CollectionUtils.get((Iterable)bag, (int)1);
    }
}

