/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BagUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SortedBag;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.PredicatedBag;
import org.apache.commons.collections4.bag.PredicatedSortedBag;
import org.apache.commons.collections4.bag.SynchronizedBag;
import org.apache.commons.collections4.bag.SynchronizedSortedBag;
import org.apache.commons.collections4.bag.TransformedBag;
import org.apache.commons.collections4.bag.TransformedSortedBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.bag.UnmodifiableBag;
import org.apache.commons.collections4.bag.UnmodifiableSortedBag;
import org.apache.commons.collections4.functors.TruePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class BagUtilsTest {
    protected Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected Transformer<Object, Object> nopTransformer = TransformerUtils.nopTransformer();

    @Test
    public void testPredicatedBag() {
        Bag bag = BagUtils.predicatedBag((Bag)new HashBag(), this.truePredicate);
        Assertions.assertTrue((boolean)(bag instanceof PredicatedBag), (String)"Returned object should be a PredicatedBag.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.predicatedBag(null, this.truePredicate), (String)"Expecting NullPointerException for null bag."), () -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.predicatedBag((Bag)new HashBag(), null), (String)"Expecting NullPointerException for null predicate.")});
    }

    @Test
    public void testPredicatedSortedBag() {
        SortedBag bag = BagUtils.predicatedSortedBag((SortedBag)new TreeBag(), this.truePredicate);
        Assertions.assertTrue((boolean)(bag instanceof PredicatedSortedBag), (String)"Returned object should be a PredicatedSortedBag.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.predicatedSortedBag(null, this.truePredicate), (String)"Expecting NullPointerException for null bag."), () -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.predicatedSortedBag((SortedBag)new TreeBag(), null), (String)"Expecting NullPointerException for null predicate.")});
    }

    @Test
    public void testSynchronizedBag() {
        Bag bag = BagUtils.synchronizedBag((Bag)new HashBag());
        Assertions.assertTrue((boolean)(bag instanceof SynchronizedBag), (String)"Returned object should be a SynchronizedBag.");
        Assertions.assertThrows(NullPointerException.class, () -> BagUtils.synchronizedBag(null), (String)"Expecting NullPointerException for null bag.");
    }

    @Test
    public void testSynchronizedSortedBag() {
        SortedBag bag = BagUtils.synchronizedSortedBag((SortedBag)new TreeBag());
        Assertions.assertTrue((boolean)(bag instanceof SynchronizedSortedBag), (String)"Returned object should be a SynchronizedSortedBag.");
        Assertions.assertThrows(NullPointerException.class, () -> BagUtils.synchronizedSortedBag(null), (String)"Expecting NullPointerException for null bag.");
    }

    @Test
    public void testTransformedBag() {
        Bag bag = BagUtils.transformingBag((Bag)new HashBag(), this.nopTransformer);
        Assertions.assertTrue((boolean)(bag instanceof TransformedBag), (String)"Returned object should be an TransformedBag.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.transformingBag(null, this.nopTransformer), (String)"Expecting NullPointerException for null bag."), () -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.transformingBag((Bag)new HashBag(), null), (String)"Expecting NullPointerException for null transformer.")});
    }

    @Test
    public void testTransformedSortedBag() {
        SortedBag bag = BagUtils.transformingSortedBag((SortedBag)new TreeBag(), this.nopTransformer);
        Assertions.assertTrue((boolean)(bag instanceof TransformedSortedBag), (String)"Returned object should be an TransformedSortedBag");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.transformingSortedBag(null, this.nopTransformer), (String)"Expecting NullPointerException for null bag."), () -> Assertions.assertThrows(NullPointerException.class, () -> BagUtils.transformingSortedBag((SortedBag)new TreeBag(), null), (String)"Expecting NullPointerException for null transformer.")});
    }

    @Test
    public void testUnmodifiableBag() {
        Bag bag = BagUtils.unmodifiableBag((Bag)new HashBag());
        Assertions.assertTrue((boolean)(bag instanceof UnmodifiableBag), (String)"Returned object should be an UnmodifiableBag.");
        Assertions.assertThrows(NullPointerException.class, () -> BagUtils.unmodifiableBag(null), (String)"Expecting NullPointerException for null bag.");
        Assertions.assertSame((Object)bag, (Object)BagUtils.unmodifiableBag((Bag)bag), (String)"UnmodifiableBag shall not be decorated");
    }

    @Test
    public void testUnmodifiableSortedBag() {
        SortedBag bag = BagUtils.unmodifiableSortedBag((SortedBag)new TreeBag());
        Assertions.assertTrue((boolean)(bag instanceof UnmodifiableSortedBag), (String)"Returned object should be an UnmodifiableSortedBag.");
        Assertions.assertThrows(NullPointerException.class, () -> BagUtils.unmodifiableSortedBag(null), (String)"Expecting NullPointerException for null bag.");
        Assertions.assertSame((Object)bag, (Object)BagUtils.unmodifiableSortedBag((SortedBag)bag), (String)"UnmodifiableSortedBag shall not be decorated");
    }
}

