/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.jms.reply.CorrelationTimeoutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSelectorCreator {
    protected static final Logger LOG = LoggerFactory.getLogger(MessageSelectorCreator.class);
    protected final TimeoutMap<String, ?> timeoutMap;
    protected final ConcurrentSkipListSet<String> correlationIds;
    protected volatile boolean dirty = true;
    protected StringBuilder expression;
    private final Object lock = new Object();

    public MessageSelectorCreator(CorrelationTimeoutMap timeoutMap) {
        this.timeoutMap = timeoutMap;
        this.timeoutMap.addListener((type, cid, value) -> this.timeoutEvent(type, (String)cid));
        this.correlationIds = new ConcurrentSkipListSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.dirty) {
                return this.expression.toString();
            }
            this.expression = new StringBuilder(256);
            this.expression.append("JMSCorrelationID='");
            if (this.correlationIds.isEmpty()) {
                this.expression.append("CamelDummyJmsMessageSelector'");
            } else {
                boolean first = true;
                for (String value : this.correlationIds) {
                    if (!first) {
                        this.expression.append(" OR JMSCorrelationID='");
                    }
                    this.expression.append(value).append("'");
                    if (!first) continue;
                    first = false;
                }
            }
            String answer = this.expression.toString();
            this.dirty = false;
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutEvent(TimeoutMap.Listener.Type type, String cid) {
        Object object = this.lock;
        synchronized (object) {
            if (type == TimeoutMap.Listener.Type.Put) {
                this.correlationIds.add(cid);
            } else if (type == TimeoutMap.Listener.Type.Remove || type == TimeoutMap.Listener.Type.Evict) {
                this.correlationIds.remove(cid);
            }
            this.dirty = true;
        }
    }
}

