/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class BaseOrderedProperties
extends Properties {
    protected final Lock lock = new ReentrantLock();
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();

    BaseOrderedProperties() {
    }

    public Map<String, Object> asMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.lock.lock();
        try {
            Object object = this.doPut(key.toString(), value.toString());
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Object doPut(String key, String value) {
        return this.map.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<?, ?> t) {
        this.lock.lock();
        try {
            for (Map.Entry<?, ?> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object get(Object key) {
        this.lock.lock();
        try {
            Object object = this.map.get(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object remove(Object key) {
        this.lock.lock();
        try {
            Object object = this.map.remove(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getProperty(String key) {
        return (String)this.map.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return (String)this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public Enumeration<Object> keys() {
        this.lock.lock();
        try {
            Enumeration<Object> enumeration = new Vector<String>(this.map.keySet()).elements();
            return enumeration;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<Object> keySet() {
        return new LinkedHashSet<Object>(this.map.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return new ArrayList<Object>(this.map.values());
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

