/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.Command;
import org.apache.activemq.jms.pool.IntrospectionSupport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.MQTTWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.mqtt.codec.MQTTFrame;

public abstract class AbstractMQTTSocket
extends TransportSupport
implements MQTTTransport,
BrokerServiceAware {
    protected ReentrantLock protocolLock = new ReentrantLock();
    protected volatile MQTTProtocolConverter protocolConverter = null;
    protected MQTTWireFormat wireFormat = new MQTTWireFormat();
    protected final MQTTInactivityMonitor mqttInactivityMonitor = new MQTTInactivityMonitor((Transport)this, (WireFormat)this.wireFormat);
    protected final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    protected BrokerService brokerService;
    protected volatile int receiveCounter;
    protected final String remoteAddress;
    protected X509Certificate[] peerCertificates;
    private Map<String, Object> transportOptions;

    public AbstractMQTTSocket(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void oneway(Object command) throws IOException {
        this.protocolLock.lock();
        try {
            this.getProtocolConverter().onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    public void sendToActiveMQ(Command command) {
        this.protocolLock.lock();
        try {
            this.doConsume(command);
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.mqttInactivityMonitor.stop();
        this.handleStopped();
    }

    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.mqttInactivityMonitor.setTransportListener(this.getTransportListener());
        this.mqttInactivityMonitor.startConnectChecker(this.wireFormat.getConnectAttemptTimeout());
    }

    public abstract void sendToMQTT(MQTTFrame var1) throws IOException;

    public abstract void handleStopped() throws IOException;

    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.mqttInactivityMonitor;
    }

    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    public void setPeerCertificates(X509Certificate[] certificates) {
        this.peerCertificates = certificates;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQTTProtocolConverter getProtocolConverter() {
        if (this.protocolConverter == null) {
            AbstractMQTTSocket abstractMQTTSocket = this;
            synchronized (abstractMQTTSocket) {
                if (this.protocolConverter == null) {
                    MQTTProtocolConverter newProtocolConverter = new MQTTProtocolConverter((MQTTTransport)this, this.brokerService);
                    IntrospectionSupport.setProperties((Object)newProtocolConverter, this.transportOptions);
                    this.protocolConverter = newProtocolConverter;
                }
            }
        }
        return this.protocolConverter;
    }

    protected boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }
}

