/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activeio.xnet.hba.IPAddressPermission;

public class StartWithIPAddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.0$");
    private final byte[] bytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public StartWithIPAddressPermission(String mask) {
        int i;
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        Byte[] tmpBytes = new Byte[4];
        boolean isWildCard = false;
        int size = 0;
        for (i = 0; i < 3; ++i) {
            String group = matcher.group(i + 1);
            if (group.equals("0")) {
                isWildCard = true;
                continue;
            }
            if (isWildCard) {
                throw new IllegalArgumentException("0 at position " + size + " in mask");
            }
            int value = Integer.parseInt(group);
            if (value < 0 || 255 < value) {
                throw new IllegalArgumentException("byte #" + i + " is not valid.");
            }
            tmpBytes[i] = new Byte((byte)value);
            ++size;
        }
        this.bytes = new byte[size];
        for (i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = tmpBytes[i];
        }
    }

    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < this.bytes.length; ++i) {
            if (byteAddress[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }
}

