/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.support.TypeConverterSupport;

public class ArrayTypeConverter
extends TypeConverterSupport {
    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (type.isArray()) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object array = Array.newInstance(type.getComponentType(), collection.size());
                if (array instanceof Object[]) {
                    collection.toArray((Object[])array);
                } else {
                    int index = 0;
                    for (Object element : collection) {
                        Array.set(array, index++, element);
                    }
                }
                return (T)array;
            }
            if (value != null && value.getClass().isArray()) {
                int size2 = Array.getLength(value);
                Object answer = Array.newInstance(type.getComponentType(), size2);
                for (int i = 0; i < size2; ++i) {
                    Array.set(answer, i, Array.get(value, i));
                }
                return (T)answer;
            }
        } else if (Collection.class.isAssignableFrom(type) && value != null) {
            if (value instanceof Object[]) {
                return (T)Arrays.asList((Object[])value);
            }
            if (value.getClass().isArray()) {
                int size3 = Array.getLength(value);
                ArrayList<Object> answer = new ArrayList<Object>(size3);
                for (int i = 0; i < size3; ++i) {
                    answer.add(Array.get(value, i));
                }
                return (T)answer;
            }
        }
        return null;
    }
}

